/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web;

import com.sun.enterprise.admin.monitor.stats.WebModuleStats;
import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.server.pluggable.WebContainerFeatureFactory;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.HealthChecker;
import com.sun.enterprise.web.PEWebContainerFeatureFactoryImpl;
import com.sun.enterprise.web.ReplicationReceiver;
import com.sun.enterprise.web.SSOFactory;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebContainerStartStopOperation;
import java.io.File;
import java.lang.reflect.Method;

public class EEWebContainerFeatureFactoryImpl
extends PEWebContainerFeatureFactoryImpl
implements WebContainerFeatureFactory {
    private final String EE_WEB_MODULE_STATS_IMPL = "com.sun.enterprise.ee.web.stats.EEWebModuleStatsImpl";
    private final String EE_WEB_CONTAINER_START_STOP_OPERATION_IMPL = "com.sun.enterprise.ee.web.sessmgmt.EEWebContainerStartStopOperation";
    private final String EE_HEALTH_CHECKER_IMPL = "com.sun.enterprise.ee.web.sessmgmt.EEHADBHealthChecker";
    private final String EE_REPLICATION_RECEIVER_IMPL = "com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationReceiver";
    private final String EE_SSO_FACTORY_IMPL = "com.sun.enterprise.ee.web.initialization.EESSOFactory";

    private boolean isHADBInstalled() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.isHADBInstalled();
    }

    public WebModuleStats getWebModuleStats() {
        if (!this.isHADBInstalled()) {
            return super.getWebModuleStats();
        }
        WebModuleStats stats = null;
        try {
            stats = (WebModuleStats)Class.forName("com.sun.enterprise.ee.web.stats.EEWebModuleStatsImpl").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stats != null) {
            return stats;
        }
        return super.getWebModuleStats();
    }

    public WebContainerStartStopOperation getWebContainerStartStopOperation() {
        if (!this.isHADBInstalled()) {
            return super.getWebContainerStartStopOperation();
        }
        WebContainerStartStopOperation startStopOperation = null;
        try {
            startStopOperation = (WebContainerStartStopOperation)Class.forName("com.sun.enterprise.ee.web.sessmgmt.EEWebContainerStartStopOperation").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (startStopOperation != null) {
            return startStopOperation;
        }
        return super.getWebContainerStartStopOperation();
    }

    public HealthChecker getHADBHealthChecker(WebContainer webContainer) {
        if (!this.isHADBInstalled()) {
            return super.getHADBHealthChecker(webContainer);
        }
        HealthChecker healthChecker = null;
        Class<?> healthCheckerClass = null;
        try {
            Class[] classParams = new Class[]{WebContainer.class};
            healthCheckerClass = Class.forName("com.sun.enterprise.ee.web.sessmgmt.EEHADBHealthChecker");
            Method myMethod = healthCheckerClass.getMethod("createInstance", classParams);
            Object[] params = new Object[]{webContainer};
            healthChecker = (HealthChecker)myMethod.invoke(null, params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (healthChecker != null) {
            return healthChecker;
        }
        return super.getHADBHealthChecker(webContainer);
    }

    public ReplicationReceiver getReplicationReceiver(EmbeddedWebContainer embedded) {
        ReplicationReceiver replicationReceiver = null;
        Class<?> replicationReceiverClass = null;
        try {
            Class[] classParams = new Class[]{EmbeddedWebContainer.class};
            replicationReceiverClass = Class.forName("com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationReceiver");
            Method myMethod = replicationReceiverClass.getMethod("createInstance", classParams);
            Object[] params = new Object[]{embedded};
            replicationReceiver = (ReplicationReceiver)myMethod.invoke(null, params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (replicationReceiver != null) {
            return replicationReceiver;
        }
        return super.getReplicationReceiver(embedded);
    }

    public SSOFactory getSSOFactory() {
        SSOFactory ssoFactory = null;
        try {
            ssoFactory = (SSOFactory)Class.forName("com.sun.enterprise.ee.web.initialization.EESSOFactory").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ssoFactory != null) {
            return ssoFactory;
        }
        return super.getSSOFactory();
    }

    public VirtualServer getVirtualServer() {
        boolean useWebcore = false;
        if (System.getProperty("com.sun.enterprise.web.useWebcore") != null) {
            useWebcore = Boolean.parseBoolean(System.getProperty("com.sun.enterprise.web.useWebcore"));
        }
        VirtualServer vs = null;
        if (useWebcore) {
            try {
                vs = (VirtualServer)Class.forName("com.sun.enterprise.web.HttpServiceVirtualServer").newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            vs = new VirtualServer();
        }
        return vs;
    }

    public String getSSLImplementationName() {
        String sslImplName = null;
        String dbDir = System.getProperty("com.sun.appserv.nss.db");
        if (new File(dbDir, "key3.db").exists()) {
            sslImplName = "com.sun.enterprise.ee.security.NssImplementation";
        }
        return sslImplName;
    }

    public String getDefaultAccessLogPrefix() {
        return "_access_log";
    }

    public String getDefaultAccessLogSuffix() {
        return "";
    }

    public String getDefaultAccessLogDateStampPattern() {
        return AccessLog.getDefaultRotationSuffix();
    }

    public boolean getAddDateStampToFirstAccessLogFile() {
        return false;
    }

    public int getDefaultRotationIntervalInMinutes() {
        return Integer.parseInt(AccessLog.getDefaultRotationIntervalInMinutes());
    }
}

