/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.tx;

import com.sun.enterprise.ee.synchronization.tx.TransactionManager;
import com.sun.enterprise.ee.synchronization.util.concurrent.CyclicBarrier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Transaction {
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private int txId;
    private int numParties;
    private int commitVotes = 0;
    private int rbVotes = 0;
    private long timeout;
    private boolean votedCommit = true;
    private CyclicBarrier bar;

    public Transaction(int id, int np, long msecs) {
        this.bar = new CyclicBarrier(np, null);
        this.txId = id;
        this.numParties = np;
        this.timeout = msecs;
    }

    private boolean preVote() {
        try {
            if (this.timeout > 0L) {
                this.bar.attemptBarrier(this.timeout);
            } else {
                this.bar.barrier();
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "synchronization.prevote.failed", e);
            return false;
        }
        return true;
    }

    private void postVote() {
        if (this.unvotedParties() == 0) {
            TransactionManager.getTransactionManager().resolveTransaction(this.txId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void voteRollback() {
        Transaction transaction = this;
        synchronized (transaction) {
            ++this.rbVotes;
            this.votedCommit = false;
        }
        this.preVote();
        this.postVote();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void voteCommit() {
        boolean b = this.preVote();
        Transaction transaction = this;
        synchronized (transaction) {
            if (b) {
                ++this.commitVotes;
            } else {
                ++this.rbVotes;
                this.votedCommit = false;
            }
        }
        this.postVote();
    }

    public int numRollbackVotes() {
        return this.rbVotes;
    }

    public int numCommitVotes() {
        return this.commitVotes;
    }

    public int unvotedParties() {
        int ucV = this.numParties - (this.rbVotes + this.commitVotes);
        if (ucV < 0) {
            ucV = 0;
        }
        return ucV;
    }

    public int totalParties() {
        return this.numParties;
    }

    public int getId() {
        return this.txId;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isCommited() {
        return this.votedCommit;
    }
}

