/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.cleaner;

import com.sun.enterprise.ee.synchronization.RequestMediator;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.cleaner.CleanerConstants;
import com.sun.enterprise.ee.synchronization.cleaner.DirPruner;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CleanerUtils {
    private static final String TRASH_FILE = ".com_sun_appserv_trash";
    private static String[] _dnrList = null;
    private static boolean _dnrListInit = false;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManager _localStrMgr = StringManager.getManager(CleanerUtils.class);

    public static boolean isExcluded(String file) {
        if (file == null) {
            return false;
        }
        String f = FileUtils.makeForwardSlashes((String)file);
        for (int i = 0; i < CleanerConstants.EXCLUDE_LIST.length; ++i) {
            String s = CleanerConstants.EXCLUDE_LIST[i];
            if (f.indexOf(s) == -1) continue;
            return true;
        }
        try {
            CleanerUtils.initDoNotRemoveList();
            if (_dnrList != null) {
                for (int j = 0; j < _dnrList.length; ++j) {
                    if (f.indexOf(_dnrList[j]) != -1) {
                        return true;
                    }
                    if (_dnrList[j].indexOf(f) == -1) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "synchronization.mbean.failed", e);
        }
        return false;
    }

    static boolean isParentOrExcluded(String dir) {
        boolean tf;
        block6: {
            tf = false;
            if (dir != null) {
                String d = FileUtils.makeForwardSlashes((String)dir);
                try {
                    CleanerUtils.initDoNotRemoveList();
                    if (_dnrList == null) break block6;
                    for (int i = 0; i < _dnrList.length; ++i) {
                        if (d.indexOf(_dnrList[i]) != -1) {
                            tf = true;
                        } else {
                            if (_dnrList[i].indexOf(d) == -1) continue;
                            tf = true;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    _logger.log(Level.FINE, "synchronization.mbean.failed", e);
                }
            }
        }
        return tf;
    }

    private static void initDoNotRemoveList() {
        try {
            if (_dnrList == null && !_dnrListInit) {
                String sysProperty = System.getProperty("com.sun.appserv.doNotRemoveList");
                _logger.fine("DO NOT REMOVE LIST=" + sysProperty);
                if (sysProperty != null) {
                    String iRoot = System.getProperty("com.sun.aas.instanceRoot");
                    if (iRoot == null) {
                        String msg = _localStrMgr.getString("iRootIsNull", (Object)"com.sun.aas.instanceRoot");
                        throw new IllegalArgumentException(msg);
                    }
                    StringTokenizer st = new StringTokenizer(sysProperty, ",");
                    int tokenCount = st.countTokens();
                    _dnrList = new String[tokenCount];
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        String tk = null;
                        tk = iRoot.endsWith("/") || iRoot.endsWith("\\") ? FileUtils.makeForwardSlashes((String)(iRoot + st.nextToken())) : FileUtils.makeForwardSlashes((String)(iRoot + "/" + st.nextToken()));
                        if (tk.endsWith("/")) {
                            CleanerUtils._dnrList[i++] = tk.substring(0, tk.length() - 1);
                            continue;
                        }
                        CleanerUtils._dnrList[i++] = tk;
                    }
                }
                _dnrListInit = true;
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "synchronization.mbean.failed", e);
        }
    }

    public static void removeEmptyDir(File dir) {
        if (dir != null) {
            File[] child = dir.listFiles();
            for (int i = 0; i < child.length; ++i) {
                if (!child[i].isDirectory()) continue;
                String[] list = child[i].list();
                if (list.length == 0) {
                    try {
                        String childDir = child[i].getCanonicalPath();
                        if (CleanerUtils.isParentOrExcluded(childDir)) continue;
                        child[i].delete();
                    }
                    catch (IOException e) {
                        _logger.log(Level.FINE, "Error while removing directory", e);
                    }
                    continue;
                }
                CleanerUtils.removeEmptyDir(child[i]);
            }
            try {
                String[] again = dir.list();
                String dirPath = dir.getCanonicalPath();
                if (again.length == 0) {
                    if (!CleanerUtils.isParentOrExcluded(dirPath)) {
                        _logger.fine("Removing empty directory: " + dirPath);
                        dir.delete();
                    }
                } else {
                    _logger.fine("Directory is not empty: " + dirPath);
                }
            }
            catch (IOException ioe) {
                _logger.log(Level.FINE, "Error while removing directory", ioe);
            }
        }
    }

    static File getMainTrash() {
        String iRoot = System.getProperty("com.sun.aas.instanceRoot");
        File trash = new File(iRoot + File.separator + "generated" + File.separator + TRASH_FILE);
        if (!trash.exists()) {
            trash.mkdirs();
            _logger.fine("Created main trash folder: " + trash.getPath());
        }
        return trash;
    }

    static File getTemporaryTrash() {
        File temp = CleanerUtils.getMainTrash();
        long ts = System.currentTimeMillis();
        File trash = new File(temp, Long.toString(ts));
        while (trash.exists()) {
            trash = new File(temp, Long.toString(++ts));
        }
        trash.mkdirs();
        _logger.fine("Created temporary trash folder: " + trash.getPath());
        return trash;
    }

    static DirPruner[] getDirPruner(RequestMediator[] mReqs, File trash) {
        DirPruner[] pruners = null;
        if (mReqs == null || trash == null) {
            return null;
        }
        pruners = new DirPruner[mReqs.length];
        for (int i = 0; i < pruners.length; ++i) {
            SynchronizationResponse res = mReqs[i].getResponse();
            SynchronizationRequest[] reqs = res.getReply();
            if (reqs[0] == null) continue;
            String baseDir = reqs[0].getBaseDirectory();
            String targetDir = reqs[0].getTargetDirectory();
            File reqDir = new File(baseDir + File.separator + targetDir);
            pruners[i] = new DirPruner(reqDir, trash, mReqs[i].getCRInventory());
        }
        return pruners;
    }
}

