/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.ee.admin.clientreg.MBeanServerConnectionInfo;
import com.sun.enterprise.ee.admin.proxy.MBeanServerProxy;
import com.sun.enterprise.ee.synchronization.Command;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.SynchronizationMBean;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

class JmxGetCommand
implements Command {
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManager _localStrMgr = StringManager.getManager(JmxGetCommand.class);
    private MBeanServerConnectionInfo _connInfo = null;
    private SynchronizationRequest _request = null;
    private SynchronizationResponse _result = null;
    private static final String NAME = "Synchronization-Get-Command";
    private static final String MBEAN_NAME = "com.sun.appserv:type=synchronization,category=config";

    JmxGetCommand(SynchronizationRequest req, MBeanServerConnectionInfo connInfo) {
        this._request = req;
        this._connInfo = connInfo;
    }

    public void execute() throws SynchronizationException {
        try {
            SynchronizationRequest[] reqArray = new SynchronizationRequest[]{this._request};
            SynchronizationMBean proxy = (SynchronizationMBean)MBeanServerProxy.getMBeanServerProxy(SynchronizationMBean.class, new ObjectName(MBEAN_NAME), this._connInfo);
            _logger.log(Level.FINE, "synchronization.request_start", this._request.getMetaFileName());
            this._result = proxy.synchronize(reqArray);
            _logger.log(Level.FINE, "synchronization.file_received", this._request.getMetaFileName());
        }
        catch (Exception e) {
            String msg = _localStrMgr.getString("fileRetrieveError", (Object)this._request.getMetaFileName());
            throw new SynchronizationException(msg, e);
        }
        if (this._result == null) {
            String msg = _localStrMgr.getString("fileRetrieveError", (Object)this._request.getMetaFileName());
            throw new SynchronizationException(msg);
        }
    }

    public String getName() {
        return NAME;
    }

    public Object getResult() {
        return this._result;
    }
}

