/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.admin.server.core.channel.RRStateFactory;
import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.synchronization.ApplicationSynchRequest;
import com.sun.enterprise.ee.synchronization.DASCommunicationException;
import com.sun.enterprise.ee.synchronization.NonMatchingDASContactedException;
import com.sun.enterprise.ee.synchronization.Ping;
import com.sun.enterprise.ee.synchronization.RequestMediator;
import com.sun.enterprise.ee.synchronization.SynchronizationConfig;
import com.sun.enterprise.ee.synchronization.SynchronizationDriver;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.SynchronizationPingResponse;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.audit.AuditException;
import com.sun.enterprise.ee.synchronization.audit.AuditMgr;
import com.sun.enterprise.ee.synchronization.cleaner.CacheRepositoryCleanerMain;
import com.sun.enterprise.ee.synchronization.tx.Transaction;
import com.sun.enterprise.ee.synchronization.tx.TransactionManager;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseSynchronizationDriver
implements SynchronizationDriver {
    protected static final Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    static final StringManager _localStrMgr = StringManager.getManager(BaseSynchronizationDriver.class);
    protected String _metaFile = null;
    protected String _instanceRoot = null;
    protected DASPropertyReader _dpr = null;
    static final int MAJOR_VERSION = 9;
    static final int MINOR_VERSION = 1;
    static final String THREAD_NAME = "sync-";

    public boolean acceptsURL(String url) {
        return "synchronization-meta-data.xml".equals(url) || "na-synchronization-meta-data.xml".equals(url) || "na-startup-meta-data.xml".equals(url);
    }

    public int getMajorVersion() {
        return 9;
    }

    public int getMinorVersion() {
        return 1;
    }

    public void synchronize() throws SynchronizationException {
        try {
            this.synchronizeInternal();
        }
        catch (DASCommunicationException dce) {
            throw dce;
        }
        catch (SynchronizationException e) {
            _logger.log(Level.INFO, "synchronization.retry_synchronization");
            this.synchronizeInternal();
        }
    }

    private String secondsString(double d, int numDecimalPlaces) {
        String format = "%." + numDecimalPlaces + "f";
        return String.format(format, d);
    }

    void synchronizeInternal() throws SynchronizationException {
        long startTime = System.currentTimeMillis();
        try {
            TransactionManager txMgr = TransactionManager.getTransactionManager();
            Ping pc = this.getPingCommand();
            pc.execute();
            if (pc.isAlive()) {
                int i;
                SynchronizationRequest[] reqs = this.getAllRequests(pc);
                assert (reqs.length != 0);
                assert (this._dpr != null);
                Transaction tx = txMgr.begin(reqs.length);
                RequestMediator[] mReqs = new RequestMediator[reqs.length];
                Thread[] reqThreads = new Thread[reqs.length];
                for (i = 0; i < reqs.length; ++i) {
                    mReqs[i] = this.getRequestMediator(reqs[i], tx);
                    reqThreads[i] = new Thread((Runnable)mReqs[i], THREAD_NAME + i);
                    reqThreads[i].start();
                }
                for (i = 0; i < reqThreads.length; ++i) {
                    reqThreads[i].join();
                }
                String configDir = System.getProperty("com.sun.aas.instanceRoot") + File.separator + "config";
                File nssFile = new File(configDir, "key3.db");
                if (!nssFile.exists()) {
                    if (System.getProperty("javax.net.ssl.keyStore") == null) {
                        System.setProperty("javax.net.ssl.keyStore", configDir + File.separator + "keystore.jks");
                    }
                    if (System.getProperty("javax.net.ssl.trustStore") == null) {
                        System.setProperty("javax.net.ssl.trustStore", configDir + File.separator + "cacerts.jks");
                    }
                }
                for (int i2 = 0; i2 < reqThreads.length; ++i2) {
                    if (mReqs[i2].isException()) {
                        throw mReqs[i2].getException();
                    }
                    _logger.log(Level.FINE, "synchronization.done_request", mReqs[i2].getRequest().getMetaFileName());
                }
                double elapsedSeconds = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                _logger.log(Level.INFO, "synchronization.time_taken", this.secondsString(elapsedSeconds, 3));
                if ("synchronization-meta-data.xml".equals(this._metaFile)) {
                    long cleanerStartMillis = System.currentTimeMillis();
                    CacheRepositoryCleanerMain cleanerMain = CacheRepositoryCleanerMain.getInstance();
                    cleanerMain.run(mReqs);
                    RRStateFactory.removeStateFile();
                    double cleanerSeconds = (double)(System.currentTimeMillis() - cleanerStartMillis) / 1000.0;
                    _logger.log(Level.INFO, "synchronization.cleaner.time_taken", this.secondsString(cleanerSeconds, 3));
                    try {
                        AuditMgr aMgr = new AuditMgr(reqs);
                        aMgr.auditServer(this._dpr);
                    }
                    catch (AuditException aEx) {
                        _logger.log(Level.SEVERE, "synchronization.audit_fail", aEx);
                    }
                }
            } else {
                String msg = _localStrMgr.getString("dasCommunicationError");
                if (pc != null) {
                    Object pingResult = pc.getResult();
                    if (pingResult instanceof NonMatchingDASContactedException) {
                        NonMatchingDASContactedException oriEx = (NonMatchingDASContactedException)pingResult;
                        throw oriEx;
                    }
                    _logger.log(Level.INFO, "synchronization.skipping_synchronization");
                    if (pingResult instanceof Exception) {
                        Exception oriEx = (Exception)pingResult;
                        throw new DASCommunicationException(msg, oriEx);
                    }
                    throw new DASCommunicationException(msg);
                }
            }
        }
        catch (DASCommunicationException dce) {
            throw dce;
        }
        catch (NonMatchingDASContactedException nmde) {
            throw nmde;
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "synchronization.sync_fail", e);
            throw new SynchronizationException(e);
        }
    }

    protected abstract Ping getPingCommand();

    protected abstract RequestMediator getRequestMediator(SynchronizationRequest var1, Transaction var2);

    private SynchronizationRequest[] getAllRequests(Ping pc) throws IOException {
        SynchronizationRequest[] reqs = this.getRequests();
        ArrayList<SynchronizationRequest> list = new ArrayList<SynchronizationRequest>();
        list.addAll(Arrays.asList(reqs));
        SynchronizationPingResponse pr = (SynchronizationPingResponse)pc.getResult();
        if (pr != null && pr instanceof SynchronizationPingResponse) {
            SynchronizationPingResponse pingResponse = pr;
            List appReqs = pingResponse.getApplicationSynchRequests();
            for (ApplicationSynchRequest aReq : appReqs) {
                list.addAll(aReq.toSynchronizationRequest());
            }
        }
        SynchronizationRequest[] allReqs = new SynchronizationRequest[list.size()];
        return list.toArray(allReqs);
    }

    private SynchronizationRequest[] getRequests() throws IOException {
        assert (this._metaFile != null);
        SynchronizationConfig sConfig = new SynchronizationConfig(this._metaFile);
        SynchronizationRequest[] requests = sConfig.getSyncRequests();
        return requests;
    }
}

