/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.ee.synchronization.ApplicationSynchRequest;
import com.sun.enterprise.ee.synchronization.RequestBuilderBase;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ApplicationRequestBuilder
extends RequestBuilderBase {
    public ApplicationRequestBuilder(ConfigContext ctx, String serverName) {
        super(ctx, serverName);
    }

    String getApplicationName(ConfigBean cb) {
        return ((J2eeApplication)cb).getName();
    }

    public ApplicationSynchRequest build(J2eeApplication app) {
        ApplicationSynchRequest asr = super.build((ConfigBean)app);
        SynchronizationRequest sr = this.buildJspDir((ConfigBean)app);
        asr.setJSPRequest(sr);
        sr = this.buildEjbDir((ConfigBean)app);
        asr.setEJBRequest(sr);
        return asr;
    }

    List getAllDirectories(ConfigBean cb) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getAppDir(cb));
        list.add(this.getJspDir(cb, "j2ee-apps"));
        list.add(this.getEjbDir(cb, "j2ee-apps"));
        list.add(this.getXmlDir(cb, "j2ee-apps"));
        list.add(this.getPolicyDir(cb));
        list.add(this.getAppLibsDir(cb));
        list.add(this.getJwsDir(cb));
        return list;
    }

    private String getAppDir(ConfigBean cb) {
        String src = this.OPEN_PROP + "com.sun.aas.instanceRoot" + this.CLOSE_PROP + File.separator + "applications" + File.separator + "j2ee-apps" + File.separator + this.getApplicationName(cb);
        return src;
    }

    SynchronizationRequest buildAppDir(ConfigBean cb) {
        return this.buildRequest(this.getAppDir(cb));
    }

    SynchronizationRequest buildJspDir(ConfigBean cb) {
        return this.buildJspDir(cb, "j2ee-apps");
    }

    SynchronizationRequest buildEjbDir(ConfigBean cb) {
        return this.buildEjbDir(cb, "j2ee-apps");
    }

    SynchronizationRequest buildXmlDir(ConfigBean cb) {
        return this.buildXmlDir(cb, "j2ee-apps");
    }
}

