/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.selfmanagement.actions;

import com.sun.enterprise.ee.selfmanagement.actions.Instance;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class RestartInstance
implements Runnable {
    private static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.selfmanagement");
    private final String mbeanName = "com.sun.appserv:type=servers,category=config";
    private final String stopOpName = "stopServerInstance";
    private final String startOpName = "startServerInstance";
    private ObjectName objName;
    private Instance instance = null;
    private MBeanServer mbeanServer = null;
    private String instanceName = null;
    private String clusterName = null;

    public RestartInstance(Instance value, MBeanServer server) {
        try {
            this.instance = value;
            this.mbeanServer = server;
            this.instanceName = this.instance.getServer().getName();
            this.clusterName = this.instance.getClusterName();
            this.objName = new ObjectName("com.sun.appserv:type=servers,category=config");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean stopInstance() {
        boolean stopped = true;
        try {
            Object[] params = new Object[]{this.instanceName};
            String[] types = new String[]{String.class.getName()};
            if (this.clusterName == null) {
                _logger.log(Level.INFO, "sgmt.instancehang_prestopinstance", this.instanceName);
            } else {
                _logger.log(Level.INFO, "sgmt.instancehang_prestopclinstance", new Object[]{this.instanceName, this.clusterName});
            }
            this.mbeanServer.invoke(this.objName, "stopServerInstance", params, types);
            if (this.clusterName == null) {
                _logger.log(Level.INFO, "sgmt.instancehang_poststopinstance", this.instanceName);
            } else {
                _logger.log(Level.INFO, "sgmt.instancehang_poststopclinstance", new Object[]{this.instanceName, this.clusterName});
            }
        }
        catch (Exception ex) {
            if (this.clusterName == null) {
                _logger.log(Level.INFO, "sgmt.instancehang_errstopinstance", this.instanceName);
            } else {
                _logger.log(Level.INFO, "sgmt.instancehang_errstopclinstance", new Object[]{this.instanceName, this.clusterName});
            }
            stopped = false;
        }
        return stopped;
    }

    private void startInstance() {
        try {
            Object[] params = new Object[]{this.instanceName};
            String[] types = new String[]{String.class.getName()};
            if (this.clusterName == null) {
                _logger.log(Level.INFO, "sgmt.instancehang_prestartinstance", this.instanceName);
            } else {
                _logger.log(Level.INFO, "sgmt.instancehang_prestartclinstance", new Object[]{this.instanceName, this.clusterName});
            }
            this.mbeanServer.invoke(this.objName, "startServerInstance", params, types);
            if (this.clusterName == null) {
                _logger.log(Level.INFO, "sgmt.instancehang_poststartinstance", this.instanceName);
            } else {
                _logger.log(Level.INFO, "sgmt.instancehang_poststartclinstance", new Object[]{this.instanceName, this.clusterName});
            }
        }
        catch (Exception ex) {
            if (this.clusterName == null) {
                _logger.log(Level.INFO, "sgmt.instancehang_errststartinstance", this.instanceName);
            }
            _logger.log(Level.INFO, "sgmt.instancehang_errstartclinstance", new Object[]{this.instanceName, this.clusterName});
        }
    }

    public void run() {
        boolean isStopped = this.stopInstance();
        if (isStopped) {
            this.startInstance();
        }
    }
}

