/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.selfmanagement.actions;

import java.util.Arrays;

public class BoundedCircularQueue {
    private int capacity = 5;
    private int size = 0;
    private int cursor = -1;
    private long[] elems;
    int percentileindex = 0;

    public BoundedCircularQueue() {
        this.elems = new long[this.capacity];
        this.percentileindex = (int)Math.floor((double)this.capacity * 0.9);
    }

    public BoundedCircularQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.elems = new long[capacity];
        this.percentileindex = (int)Math.floor((double)capacity * 0.9);
    }

    public synchronized void add(long data) {
        this.cursor = (this.cursor + 1) % this.capacity;
        this.elems[this.cursor] = data;
        if (this.size < this.capacity) {
            ++this.size;
        }
    }

    public synchronized long get() {
        if (this.cursor == -1) {
            throw new IllegalStateException();
        }
        return this.elems[this.cursor];
    }

    public synchronized long getApprox90thPercentile() {
        if (this.cursor != -1 && this.size < this.capacity) {
            return this.get();
        }
        long[] cloneElems = new long[this.capacity];
        for (int i = 0; i < this.capacity; ++i) {
            cloneElems[i] = this.elems[i];
        }
        Arrays.sort(cloneElems);
        return cloneElems[this.percentileindex];
    }
}

