/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.nodeagent.mbeans;

import com.sun.appserv.management.client.AdminRMISSLClientSocketFactoryEnvImpl;
import com.sun.appserv.management.client.HandshakeCompletedListenerImpl;
import com.sun.appserv.management.client.TLSParams;
import com.sun.appserv.management.client.TrustStoreTrustManager;
import com.sun.enterprise.admin.common.JMXFileTransfer;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.admin.servermgmt.NodeAgentPropertyReader;
import com.sun.enterprise.ee.diagnostics.EEDiagnosticAgent;
import com.sun.enterprise.ee.nodeagent.mbeans.NodeAgentDiagnosticMBean;
import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeAgentDiagnostic
implements NodeAgentDiagnosticMBean {
    protected Logger _logger = null;
    protected static final StringManager _strMgr = StringManager.getManager(NodeAgentDiagnostic.class);
    protected DASPropertyReader dasReader = null;
    protected NodeAgentPropertyReader naReader = null;
    private static final String UPLOAD_DIRECTORY = "reports_temp";
    public static final String DEFAULT_TRUST_STORE_NAME = ".asadmintruststore";
    public static final String DEFAULT_TRUST_STORE_PASSWORD = "changeit";
    public static TLSParams mTLSParams = NodeAgentDiagnostic.createTLSParams();

    public NodeAgentDiagnostic() {
        this.initLogger();
        this.initDAS();
        this.initNodeAgent();
    }

    @Override
    public String generateReport(Map options, List<String> instances, String targetType) {
        try {
            EEDiagnosticAgent agent = new EEDiagnosticAgent();
            String fileName = agent.generateReport(options, instances, targetType);
            this.uploadZipFile(fileName);
            return fileName;
        }
        catch (Exception de) {
            this._logger.log(Level.WARNING, "diagnostic-service.error_generating_report_na", de);
            return null;
        }
    }

    private void uploadZipFile(String zipFileName) {
        this._logger.log(Level.INFO, "NodeAgentDiagnosticMBean uploadZipFile ...");
        try {
            JMXConnector jmxC = this.getJMXConnector(new JMXServiceURL(this.dasReader.getJMXURL()));
            MBeanServerConnection mbsc = jmxC.getMBeanServerConnection();
            JMXFileTransfer jmxFileTfr = new JMXFileTransfer(mbsc);
            jmxFileTfr.uploadFile(zipFileName, UPLOAD_DIRECTORY);
        }
        catch (MalformedURLException mfue) {
            this._logger.log(Level.WARNING, "nodeAgentDiagnostic.incorrect_jmx_service_url", mfue);
        }
        catch (IOException ioe) {
            this._logger.log(Level.WARNING, "nodeAgentDiagnostic.no_mbean_server_connection", ioe);
        }
    }

    private JMXConnector getJMXConnector(JMXServiceURL jurl) {
        try {
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("jmx.remote.credentials", new String[]{IdentityManager.getUser(), IdentityManager.getPassword()});
            env.put("USER", IdentityManager.getUser());
            env.put("PASSWORD", IdentityManager.getPassword());
            HandshakeCompletedListenerImpl hcListener = new HandshakeCompletedListenerImpl(NodeAgentDiagnostic.getSuppliedHandshakeCompletedListener());
            AdminRMISSLClientSocketFactoryEnvImpl rmiEnv = AdminRMISSLClientSocketFactoryEnvImpl.getInstance();
            rmiEnv.setHandshakeCompletedListener((HandshakeCompletedListener)hcListener);
            rmiEnv.setTrustManagers((TrustManager[])NodeAgentDiagnostic.getTrustManagers());
            JMXConnector conn = JMXConnectorFactory.connect(jurl, env);
            return conn;
        }
        catch (IOException ioe) {
            this._logger.log(Level.WARNING, "nodeAgentDiagnostic.cannot_connect_to_jmx_connector_factory", ioe);
            return null;
        }
    }

    private static final X509TrustManager[] getTrustManagers() {
        return mTLSParams == null ? null : mTLSParams.getTrustManagers();
    }

    public static TLSParams createTLSParams() {
        File trustStoreFile = NodeAgentDiagnostic.getDefaultTrustStore();
        char[] trustStorePassword = DEFAULT_TRUST_STORE_PASSWORD.toCharArray();
        HandshakeCompletedListenerImpl handshakeCompletedListener = new HandshakeCompletedListenerImpl();
        TrustStoreTrustManager trustMgr = new TrustStoreTrustManager(trustStoreFile, trustStorePassword);
        trustMgr.setPrompt(false);
        mTLSParams = new TLSParams((X509TrustManager)trustMgr, (HandshakeCompletedListener)handshakeCompletedListener);
        return mTLSParams;
    }

    private static final HandshakeCompletedListener getSuppliedHandshakeCompletedListener() {
        return mTLSParams == null ? null : mTLSParams.getHandshakeCompletedListener();
    }

    private void initLogger() {
        this._logger = Logger.getLogger("javax.ee.enterprise.system.nodeagent", "com.sun.logging.ee.enterprise.system.nodeagent.LogStrings");
    }

    private void initDAS() {
        try {
            this.dasReader = new DASPropertyReader(new AgentConfig());
            this.dasReader.read();
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "nodeAgent.das_properties_not_found", e);
        }
    }

    private void initNodeAgent() {
        try {
            this.naReader = new NodeAgentPropertyReader(new AgentConfig());
            this.naReader.read();
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "nodeAgent.nodeagent_properties_not_found", e);
        }
    }

    public static File getDefaultTrustStore() {
        String homeDir = System.getProperty("user.home");
        String sep = System.getProperty("file.separator");
        return new File(homeDir + sep + DEFAULT_TRUST_STORE_NAME);
    }
}

