/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.nodeagent;

import com.sun.enterprise.ee.admin.servermgmt.EEInstancesManager;
import com.sun.enterprise.ee.admin.servermgmt.InstanceConfig;
import com.sun.enterprise.ee.nodeagent.AbstractProcessInstance;
import com.sun.enterprise.ee.nodeagent.InstanceDirs;
import com.sun.enterprise.ee.nodeagent.ProcessManager;
import com.sun.enterprise.ee.nodeagent.ProcessManagerException;

public class ProcessInstanceInternal
extends AbstractProcessInstance {
    public ProcessInstanceInternal(String name) {
        this.setName(name);
    }

    public void startInstance() throws ProcessManagerException {
        try {
            if (bDebug) {
                System.err.println("\n" + this.getClass().getName() + ": ProcessInstanceInternal:startInstance for :" + this.getName());
            }
            InstanceConfig instanceConfig = new InstanceConfig(InstanceDirs.getRepositoryName(), InstanceDirs.getRepositoryRoot(), this.getName());
            EEInstancesManager eeInstancesManager = new EEInstancesManager(instanceConfig);
            this.setExitCode(0);
            this.setProcess(eeInstancesManager.startInstance());
            if (bDebug) {
                System.out.println("\nCurrently Running:" + ProcessManager.getInstance().toString());
            }
        }
        catch (Exception e) {
            throw new ProcessManagerException(e);
        }
    }

    public void stopInstance() throws ProcessManagerException {
        this.stopInstance(false, -1);
    }

    public void stopInstance(int timeout) throws ProcessManagerException {
        this.stopInstance(true, timeout);
    }

    private void stopInstance(boolean isTimeBound, int timeout) throws ProcessManagerException {
        try {
            this.setStopping(true);
            if (bDebug) {
                System.err.println("\n" + this.getClass().getName() + ": ProcessInstanceInternal:stopInstance for :" + this.getName());
            }
            InstanceConfig instanceConfig = new InstanceConfig(InstanceDirs.getRepositoryName(), InstanceDirs.getRepositoryRoot(), this.getName());
            EEInstancesManager eeInstancesManager = new EEInstancesManager(instanceConfig);
            if (isTimeBound) {
                boolean stopped = false;
                if (timeout > 0) {
                    stopped = eeInstancesManager.stopInstanceWithinTime(timeout);
                }
                if (!stopped) {
                    eeInstancesManager.killRelatedProcesses();
                }
            } else {
                eeInstancesManager.stopInstance();
            }
            if (bDebug) {
                System.out.println("\nCurrently Running:" + ProcessManager.getInstance().toString());
            }
        }
        catch (Exception e) {
            throw new ProcessManagerException(e);
        }
    }
}

