/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.nodeagent;

import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.ee.nodeagent.BaseNodeAgent;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstanceDirs {
    private static String nodeAgentInstanceRoot;
    private static String repName;
    private static String repRoot;

    static synchronized void initialize(RepositoryConfig config) {
        InstanceDirs.initialize(config.getRepositoryRoot() + "/" + config.getRepositoryName() + "/" + config.getInstanceName());
    }

    static synchronized void initialize(String instanceRootString) {
        if (!InstanceDirs.verify(instanceRootString)) {
            nodeAgentInstanceRoot = null;
            repName = null;
            repRoot = null;
        } else {
            nodeAgentInstanceRoot = instanceRootString;
            File instanceRoot = new File(nodeAgentInstanceRoot);
            File repositoryDir = instanceRoot.getParentFile();
            File repositoryRoot = repositoryDir.getParentFile();
            repName = repositoryDir.getName();
            repRoot = repositoryRoot.getAbsolutePath().replace('\\', '/');
        }
    }

    public static synchronized void resetSysProp() {
        StringManager sm = BaseNodeAgent._strMgr;
        Logger logger = Logger.getLogger("javax.ee.enterprise.system.nodeagent", "com.sun.logging.ee.enterprise.system.nodeagent.LogStrings");
        boolean logOK = sm != null && logger != null;
        String irSysProp = System.getProperty("com.sun.aas.instanceRoot");
        if (nodeAgentInstanceRoot == null) {
            if (logOK) {
                logger.log(Level.WARNING, sm.getString("nodeAgent.InstanceDirs.noInstanceRoot"));
            }
            return;
        }
        if (irSysProp == null) {
            if (logOK) {
                logger.log(Level.WARNING, sm.getString("nodeAgent.InstanceDirs.noSysProp", (Object)nodeAgentInstanceRoot));
            }
            System.setProperty("com.sun.aas.instanceRoot", nodeAgentInstanceRoot);
            return;
        }
        if (!nodeAgentInstanceRoot.equals(irSysProp)) {
            if (logOK) {
                logger.log(Level.WARNING, sm.getString("nodeAgent.InstanceDirs.funkyInstanceRoot", (Object)irSysProp, (Object)nodeAgentInstanceRoot));
            }
            System.setProperty("com.sun.aas.instanceRoot", nodeAgentInstanceRoot);
            return;
        }
        if (logOK) {
            logger.log(Level.INFO, sm.getString("nodeAgent.InstanceDirs.allOK", (Object)nodeAgentInstanceRoot));
        }
    }

    public static String getInstanceRoot() {
        return nodeAgentInstanceRoot;
    }

    public static String getRepositoryRoot() {
        return repRoot;
    }

    public static String getRepositoryName() {
        return repName;
    }

    private static boolean verify(String ir) {
        try {
            File grandParent = new File(ir).getParentFile().getParentFile();
            return grandParent.isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }
}

