/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.nodeagent;

import com.sun.enterprise.ee.nodeagent.ProcessInstance;
import com.sun.enterprise.ee.nodeagent.ProcessManagerException;
import java.util.Iterator;
import java.util.Observable;
import java.util.Vector;
import java.util.logging.Logger;

public abstract class AbstractProcessInstance
extends Observable
implements ProcessInstance {
    private String _name = null;
    private Vector _startCommand = new Vector();
    private Vector _stopCommand = new Vector();
    private Vector _env = new Vector();
    private String _workingDir = null;
    private Process _process = null;
    private Thread _thread = null;
    private int _exitCode = 0;
    private Logger _logger = null;
    private boolean _restartProcess = true;
    protected static boolean bDebug = false;
    private boolean _isStopping = false;

    public abstract void startInstance() throws ProcessManagerException;

    public abstract void stopInstance() throws ProcessManagerException;

    public void setExitCode(int exitCode) {
        this.setChanged();
        this._exitCode = exitCode;
    }

    public int getExitCode() {
        return this._exitCode;
    }

    public void setProcess(Process process) {
        if (bDebug) {
            System.err.println("Changing Process for " + this.getName() + " to " + process);
        }
        this._process = process;
    }

    public Process getProcess() {
        return this._process;
    }

    public void setRestartProcess(boolean restartProcess) {
        this._restartProcess = restartProcess;
    }

    public boolean getRestartProcess() {
        return this._restartProcess;
    }

    public boolean restartProcess() {
        return this._restartProcess;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void addCommandLine(String type, String cmd) {
        if (type.equals("start")) {
            this.addStartCommandLine(cmd);
        } else if (type.equals("stop")) {
            this.addStopCommandLine(cmd);
        }
    }

    public void addStartCommandLine(String cmd) {
        this._startCommand.add(cmd);
    }

    public String[] getStartCommandAsArray() {
        String[] array = new String[this._startCommand.size()];
        return this._startCommand.toArray(array);
    }

    public String getStartCommand() {
        StringBuffer sbRet = new StringBuffer();
        Iterator it = this._startCommand.iterator();
        while (it.hasNext()) {
            sbRet.append((String)it.next() + " ");
        }
        return sbRet.toString();
    }

    public void addStopCommandLine(String cmd) {
        this._stopCommand.add(cmd);
    }

    public String[] getStopCommandAsArray() {
        String[] array = new String[this._stopCommand.size()];
        return this._stopCommand.toArray(array);
    }

    public String getStopCommand() {
        StringBuffer sbRet = new StringBuffer();
        Iterator it = this._stopCommand.iterator();
        while (it.hasNext()) {
            sbRet.append((String)it.next() + " ");
        }
        return sbRet.toString();
    }

    public void setEnvironmentVariable(String name_value_pair) {
        this._env.add(name_value_pair);
    }

    public void removeEnvironmentVariable(String name_value_pair) {
        this._env.remove(name_value_pair);
    }

    public String[] getEnvironmentAsArray() {
        String[] array = new String[this._env.size()];
        return this._env.toArray(array);
    }

    public String getEnvironmentAsString() {
        String[] array = this.getEnvironmentAsArray();
        StringBuffer sbRet = new StringBuffer();
        for (int ii = 0; ii < array.length; ++ii) {
            sbRet.append(array[ii] + " ");
        }
        return sbRet.toString();
    }

    public void setWorkingDirectory(String dir) {
        this._workingDir = dir;
    }

    public String getWorkingDirectory() {
        return this._workingDir;
    }

    protected Logger getLogger() {
        if (this._logger == null) {
            this._logger = Logger.getLogger("javax.ee.enterprise.system.nodeagent", "com.sun.logging.ee.enterprise.system.nodeagent.LogStrings");
        }
        return this._logger;
    }

    public String toString() {
        StringBuffer sbRet = new StringBuffer("\n**Process Name:" + this.getName());
        sbRet.append("\n\tStartCommandLine:" + this.getStartCommand());
        sbRet.append("\n\tStopCommandLine:" + this.getStopCommand());
        sbRet.append("\n\tEnvironment Variables:" + this.getEnvironmentAsString());
        sbRet.append("\n\tWorking Directory:" + this.getWorkingDirectory());
        return sbRet.toString();
    }

    public boolean isStopping() {
        return this._isStopping;
    }

    public void setStopping(boolean value) {
        this._isStopping = value;
    }
}

