/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.diagnostics.collect;

import com.sun.enterprise.diagnostics.Defaults;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.ReportConfig;
import com.sun.enterprise.diagnostics.TargetType;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.Harvester;
import com.sun.enterprise.diagnostics.collect.LogCollector;
import com.sun.enterprise.ee.diagnostics.EEConstants;
import com.sun.enterprise.ee.diagnostics.EEExecutionContext;
import com.sun.enterprise.ee.diagnostics.EETargetType;
import com.sun.enterprise.ee.diagnostics.collect.AgentConfigCollector;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;

public class NodeAgentHarvester
extends Harvester {
    protected static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.admin");

    public NodeAgentHarvester(ReportConfig config) {
        super(config);
    }

    public void addRemoteCollectors() {
    }

    public void initialize() throws DiagnosticException {
        super.initialize();
        TargetType type = this.target.getType();
        if (type.equals((Object)EETargetType.NODEAGENT) || this.config.getExecutionContext().equals((Object)EEExecutionContext.NODEAGENT_EC) && type.equals((Object)EETargetType.DOMAIN)) {
            String repositoryDir = this.target.getTargetDir() + EEConstants.AGENT_DIR;
            String reportDir = this.target.getIntermediateReportDir() + EEConstants.AGENT_DIR;
            this.addCollector((Collector)new AgentConfigCollector(repositoryDir, reportDir));
            this.addCollector((Collector)new LogCollector(reportDir, repositoryDir + Defaults.DEST_LOG_FILE));
        }
    }
}

