/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.deployment.phasing;

import com.sun.enterprise.admin.target.DomainTarget;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DeploymentTargetException;
import com.sun.enterprise.deployment.phasing.ServerDeploymentTarget;
import com.sun.enterprise.util.i18n.StringManager;

public final class DomainDeploymentTarget
extends DomainTarget
implements DeploymentTarget {
    protected static final StringManager localStrings = StringManager.getManager(DomainDeploymentTarget.class);
    protected String thisTargetName = null;
    protected ConfigContext configContext = null;
    protected String domainName = null;

    public DomainDeploymentTarget(ConfigContext configContext, String domainName, String targetName) {
        super(targetName, configContext);
        this.configContext = configContext;
        this.thisTargetName = targetName;
        this.domainName = domainName;
    }

    public String[] getModules(DeployableObjectType type, Boolean enabled) throws DeploymentTargetException {
        try {
            ServerDeploymentTarget sdTarget = new ServerDeploymentTarget(this.configContext, this.domainName, "");
            return sdTarget.getModules(this.getAppsInDomain(), type, enabled);
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public void addAppReference(String appName, boolean enabled, String virtualServers) throws DeploymentTargetException {
    }

    public void removeAppReference(String appName) throws DeploymentTargetException {
    }

    public boolean sendStartEvent(int eventType, String appName, String moduleType) throws DeploymentTargetException {
        return this.sendStartEvent(eventType, appName, moduleType, false);
    }

    public boolean sendStartEvent(int eventType, String appName, String moduleType, boolean isForced) throws DeploymentTargetException {
        return this.sendStartEvent(eventType, appName, moduleType, isForced, 0);
    }

    public boolean sendStartEvent(int eventType, String appName, String moduleType, boolean isForced, int loadUnloadAction) throws DeploymentTargetException {
        try {
            boolean domainResult = true;
            String[] svrRef = this.getServersReferencingApp(appName);
            for (int i = 0; i < svrRef.length; ++i) {
                ServerDeploymentTarget sdTarget = new ServerDeploymentTarget(this.configContext, this.domainName, svrRef[i]);
                boolean serverResult = sdTarget.sendStartEvent(eventType, appName, moduleType, isForced, loadUnloadAction);
                if (serverResult) continue;
                domainResult = false;
            }
            return domainResult;
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public boolean sendStopEvent(int eventType, String appName, String moduleType, boolean cascade) throws DeploymentTargetException {
        try {
            String[] svrRef = this.getServersReferencingApp(appName);
            for (int i = 0; i < svrRef.length; ++i) {
                ServerDeploymentTarget sdTarget = new ServerDeploymentTarget(this.configContext, this.domainName, svrRef[i]);
                sdTarget.sendStopEvent(eventType, appName, moduleType, cascade);
            }
            return true;
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public boolean sendStopEvent(int eventType, String appName, String moduleType, boolean cascade, boolean force) throws DeploymentTargetException {
        try {
            String[] svrRef = this.getServersReferencingApp(appName);
            for (int i = 0; i < svrRef.length; ++i) {
                ServerDeploymentTarget sdTarget = new ServerDeploymentTarget(this.configContext, this.domainName, svrRef[i]);
                sdTarget.sendStopEvent(eventType, appName, moduleType, cascade, force);
            }
            return true;
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public boolean sendStopEvent(int eventType, String appName, String moduleType, boolean cascade, boolean force, int loadUnloadAction) throws DeploymentTargetException {
        try {
            String[] svrRef = this.getServersReferencingApp(appName);
            for (int i = 0; i < svrRef.length; ++i) {
                ServerDeploymentTarget sdTarget = new ServerDeploymentTarget(this.configContext, this.domainName, svrRef[i]);
                sdTarget.sendStopEvent(eventType, appName, moduleType, cascade, force, loadUnloadAction);
            }
            return true;
        }
        catch (Throwable t) {
            throw new DeploymentTargetException(t);
        }
    }

    public Target getTarget() {
        return this;
    }

    private String[] getServersReferencingApp(String appName) throws ConfigException {
        Server[] servers = ServerHelper.getServersReferencingApplication((ConfigContext)this.configContext, (String)appName);
        int size = servers.length;
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = servers[i].getName();
        }
        return result;
    }

    private String[] getAppsInDomain() throws ConfigException {
        return ApplicationHelper.getApplicationsInDomain((ConfigContext)this.configContext);
    }

    public String getName() {
        return this.thisTargetName;
    }

    public String getDescription() {
        return localStrings.getString("enterprise.deployment.phasing.deploymenttarget.domain.description", (Object)this.thisTargetName);
    }
}

