/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.AgentException;
import com.sun.enterprise.ee.admin.servermgmt.AgentManager;
import com.sun.enterprise.ee.cli.commands.BaseNodeAgentCommand;
import com.sun.enterprise.util.i18n.StringManager;

public class StopNodeAgentCommand
extends BaseNodeAgentCommand {
    private static final StringManager _strMgr = StringManager.getManager(StopNodeAgentCommand.class);

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        try {
            String agentName = this.getAgentName();
            AgentConfig agentConfig = new AgentConfig(agentName, this.getAgentPath());
            AgentManager manager = this.getAgentManager(agentConfig);
            manager.validateNodeAgent(agentConfig, true);
            if (this.isNotRunning(manager, agentConfig)) {
                CLILogger.getInstance().printDetailMessage(_strMgr.getString("TargetAlreadyStopped", new Object[]{agentName}));
                return;
            }
            this.stopNodeAgent(manager, agentConfig);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), (Throwable)e);
        }
    }

    private void stopNodeAgent(AgentManager mgr, AgentConfig cfg) throws AgentException {
        String forceOption = this.getCLOption("kill");
        if (forceOption == null) {
            mgr.stopNodeAgent();
        } else {
            int timeout = this.getIntegerOption("kill");
            mgr.stopNodeAgentForcibly(timeout);
        }
    }
}

