/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.launch.ASLauncherException;
import com.sun.enterprise.admin.servermgmt.pe.PEInstancesManager;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.AgentManager;
import com.sun.enterprise.ee.admin.servermgmt.EEInstancesManager;
import java.io.File;
import java.io.IOException;

public class ASShutdown {
    private File serverDir;
    private RepositoryConfig config;
    private ServerType type;
    private static final String ENV_INSTALL_ROOT = "AS_INSTALL";
    private static final String ENV_CONFIG_ROOT = "AS_CONFIG";
    private static final String ENV_INSTANCE_ROOT = "INSTANCE_ROOT";
    private static final String ENV_SERVER_NAME = "SERVER_NAME";
    private static final String ENV_PROCESS_NAME = "PROCESS_NAME";
    private static final String ID_DAS = "server";
    private static final String ID_NA = "nodeagent";

    public void shutdown() throws ASLauncherException {
        this.setup();
        try {
            switch (this.type) {
                case DAS: {
                    new PEInstancesManager(this.config).stopInstance();
                    break;
                }
                case NA: {
                    new AgentManager((AgentConfig)this.config).stopInstance();
                    break;
                }
                case INSTANCE: {
                    new EEInstancesManager(this.config).stopInstance();
                }
            }
        }
        catch (Exception e) {
            throw new ASLauncherException("Error trying to stop server.", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            ASShutdown shutdown = new ASShutdown();
            shutdown.shutdown();
            System.out.println("Server was successfully stopped.");
        }
        catch (ASLauncherException ex) {
            ex.printStackTrace();
        }
    }

    private void setup() throws ASLauncherException {
        this.setSystemProperty("com.sun.aas.installRoot", ENV_INSTALL_ROOT);
        this.setSystemProperty("com.sun.aas.configRoot", ENV_CONFIG_ROOT);
        this.setServerDir();
        this.setType();
        this.createConfig();
    }

    private void createConfig() throws ASLauncherException {
        try {
            File parent = this.serverDir.getParentFile();
            switch (this.type) {
                case DAS: {
                    this.config = new RepositoryConfig(this.serverDir.getName(), parent.getPath());
                    break;
                }
                case INSTANCE: {
                    this.config = new RepositoryConfig(this.serverDir.getAbsolutePath());
                    break;
                }
                case NA: {
                    this.config = new AgentConfig(parent.getName(), parent.getParent(), this.serverDir.getName());
                }
            }
        }
        catch (Exception e) {
            throw new ASLauncherException("Error attempting to create Repository Config", (Throwable)e);
        }
    }

    private void setServerDir() throws ASLauncherException {
        this.serverDir = new File(this.getEnvironmentVariable(ENV_INSTANCE_ROOT));
        if (!this.serverDir.isDirectory()) {
            throw new ASLauncherException("Server root directory, " + this.serverDir + ", doesn't exist.");
        }
        try {
            this.serverDir = new File(this.serverDir.getCanonicalPath());
        }
        catch (IOException ex) {
            this.serverDir = new File(this.serverDir.getAbsolutePath());
        }
    }

    private void setType() throws ASLauncherException {
        String name = this.getEnvironmentVariable(ENV_SERVER_NAME);
        String proc = System.getenv(ENV_PROCESS_NAME);
        if (name.equals(ID_DAS)) {
            this.type = ServerType.DAS;
            return;
        }
        if (this.ok(proc) && proc.indexOf(ID_NA) >= 0) {
            this.type = ServerType.NA;
            return;
        }
        this.type = ServerType.INSTANCE;
    }

    private void setSystemProperty(String sysProp, String envProp) throws ASLauncherException {
        System.setProperty(sysProp, this.getEnvironmentVariable(envProp));
    }

    private String getEnvironmentVariable(String envProp) throws ASLauncherException {
        String envValue = System.getProperty(envProp);
        if (!this.ok(envValue) && !this.ok(envValue = System.getenv(envProp))) {
            throw new ASLauncherException("The environmental variable or System Property, " + envProp + ", must be set.");
        }
        return envValue;
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ServerType {
        DAS,
        NA,
        INSTANCE;

    }
}

