/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.ee.admin.hadbmgmt.BackDoor;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBConfigureCluster;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBConfigurePersistence;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBConfigurePersistenceInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBCreateDBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBCreateSchema;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBPingAgent;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBRemoveCluster;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBRemoveClusterInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBResourceManager;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBRestartDB;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBRuntimeInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBStartDB;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBStopDB;
import com.sun.enterprise.ee.admin.mbeans.EEBaseConfigMBean;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HadbConfigMBean
extends EEBaseConfigMBean
implements com.sun.enterprise.ee.admin.mbeanapi.HadbConfigMBean {
    private Properties readWriteAttributes;
    private Properties readOnlyAttributes;
    private static final StringManager STR_MGR = StringManager.getManager(HadbConfigMBean.class);
    private static Logger logger;
    public static final String AgentPortKey = "agent-port";

    private Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return logger;
    }

    @Override
    public Object[] createHACluster(Properties props) throws HADBSetupException {
        Properties hadbProps = new Properties();
        Set<Map.Entry<Object, Object>> propSet = props.entrySet();
        if (propSet == null || propSet.size() < 2) {
            throw new IllegalArgumentException();
        }
        String hosts = this.getValue(propSet, "hosts");
        String agentPort = this.getValue(propSet, "agentPort");
        String haAdminPassword = this.getValue(propSet, "haAdminPassword");
        String haAdminPasswordFile = this.getValue(propSet, "haAdminPasswordFile");
        String deviceSize = this.getValue(propSet, "deviceSize");
        String portbase = this.getValue(propSet, "portbase");
        String clusterName = this.getValue(propSet, "clusterName");
        String s = this.getValue(propSet, "autohadb");
        Boolean autohadb = s == null ? null : new Boolean(s);
        for (Map.Entry<Object, Object> entry : propSet) {
            hadbProps.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return this.createHACluster(hosts, agentPort, haAdminPassword, haAdminPasswordFile, deviceSize, autohadb, portbase, clusterName, hadbProps);
    }

    @Override
    public Object[] createHACluster(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String deviceSize, Boolean autohadb, String portbase, String clusterName, Properties props) throws HADBSetupException {
        HADBInfo info = null;
        try {
            String pw = haAdminPassword == null ? "null" : "******";
            String s = "HADBConfigMBean.createHACluster() called with hosts=" + hosts + ", agentPort=" + agentPort + ", haAdminPassword=" + pw + ", haAdminPasswordFile=" + haAdminPasswordFile + ", deviceSize=" + deviceSize + ", autohadb=" + autohadb + ", portbase=" + portbase + ", clusterName=" + clusterName + ", props=" + props;
            this.getLogger().log(Level.INFO, s);
            info = new HADBCreateDBInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, autohadb, portbase, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            ((HADBCreateDBInfo)info).setDeviceSize(deviceSize);
            ((HADBCreateDBInfo)info).setProperties(props);
            HADBConfigureCluster hcc = new HADBConfigureCluster((HADBCreateDBInfo)info);
            Object[] objectArray = hcc.configure();
            return objectArray;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    @Override
    public Object[] deleteHACluster(String clusterName) throws HADBSetupException {
        return this.deleteHACluster(null, null, null, null, clusterName);
    }

    @Override
    public Object[] deleteHACluster(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String clusterName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            String pw = haAdminPassword == null ? "null" : "******";
            String s = "HADBConfigMBean.deleteHACluster() called with hosts=" + hosts + ", agentPort=" + agentPort + ", haAdminPassword=" + pw + ", haAdminPasswordFile=" + haAdminPasswordFile + ", clusterName=" + clusterName;
            this.getLogger().log(Level.INFO, s);
            info = new HADBRemoveClusterInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            HADBRemoveCluster rc = new HADBRemoveCluster(info);
            Object[] objectArray = rc.remove();
            return objectArray;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    @Override
    public Object[] createHASchema(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String storeuser, String storepassword, String dbsystempassword, String databaseName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            String a_pw = haAdminPassword == null ? "null" : "******";
            String d_pw = dbsystempassword == null ? "null" : "******";
            String s_pw = storepassword == null ? "null" : "******";
            String s = "HADBConfigMBean.createHASchema() called with hosts=" + hosts + ", agentPort=" + agentPort + ", haAdminPassword=" + a_pw + ", haAdminPasswordFile=" + haAdminPasswordFile + ", storeuser=" + storeuser + ", storepassword=" + s_pw + ", dbsystempassword=" + d_pw + ", databaseName=" + databaseName;
            this.getLogger().log(Level.INFO, s);
            info = new HADBCreateDBInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, false, null, databaseName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setDatabaseUser(storeuser);
            info.setDatabasePassword(storepassword);
            info.setSystemPassword(dbsystempassword);
            info.setup();
            HADBCreateSchema creator = new HADBCreateSchema(info);
            Object[] objectArray = creator.create();
            return objectArray;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    @Override
    public Object[] clearHASchema(String databaseName) throws HADBSetupException {
        return this.clearHASchema(null, null, null, null, null, null, null, databaseName);
    }

    @Override
    public Object[] clearHASchema(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String storeuser, String storepassword, String dbsystempassword, String databaseName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            String a_pw = haAdminPassword == null ? "null" : "******";
            String d_pw = dbsystempassword == null ? "null" : "******";
            String s_pw = storepassword == null ? "null" : "******";
            String s = "HADBConfigMBean.createHASchema() called with hosts=" + hosts + ", agentPort=" + agentPort + ", haAdminPassword=" + a_pw + ", haAdminPasswordFile=" + haAdminPasswordFile + ", storeuser=" + storeuser + ", storepassword=" + s_pw + ", dbsystempassword=" + d_pw + ", databaseName=" + databaseName;
            this.getLogger().log(Level.INFO, s);
            info = new HADBCreateDBInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, false, null, databaseName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setDatabaseUser(storeuser);
            info.setDatabasePassword(storepassword);
            info.setSystemPassword(dbsystempassword);
            info.setup();
            HADBCreateSchema creator = new HADBCreateSchema(info);
            Object[] objectArray = creator.clear();
            return objectArray;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    @Override
    public Object[] configureHAPersistence(String type, String frequency, String scope, String store, Properties props, String clusterName) throws HADBSetupException {
        try {
            this.getLogger().log(Level.INFO, "HADBConfigMBean.configureHAPersistence() called with type = " + type + ", frequency = " + frequency + ", scope = " + scope + ", store = " + store + ", clusterName = " + clusterName + ", props = " + props);
            HADBConfigurePersistenceInfo info = new HADBConfigurePersistenceInfo(clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer(), type, frequency, scope, store, props);
            info.setup();
            HADBConfigurePersistence worker = new HADBConfigurePersistence(info);
            return worker.commit();
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
    }

    @Override
    public Object[] stopDB(String clusterName) throws HADBSetupException {
        return this.stopDB(null, null, null, null, clusterName);
    }

    @Override
    public Object[] stopDB(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String clusterName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            String pw = haAdminPassword == null ? "null" : "******";
            String s = "HADBConfigMBean.stopDB() called with hosts=" + hosts + ", agentPort=" + agentPort + ", haAdminPassword=" + pw + ", haAdminPasswordFile=" + haAdminPasswordFile + ", clusterName=" + clusterName;
            this.getLogger().log(Level.INFO, s);
            info = new HADBInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            HADBStopDB sdb = new HADBStopDB(info);
            Object[] objectArray = sdb.stopDB();
            return objectArray;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    @Override
    public Object[] startDB(String clusterName) throws HADBSetupException {
        return this.startDB(null, null, null, null, clusterName);
    }

    @Override
    public Object[] startDB(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String clusterName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            String pw = haAdminPassword == null ? "null" : "******";
            String s = "HADBConfigMBean.startDB() called with hosts=" + hosts + ", agentPort=" + agentPort + ", haAdminPassword=" + pw + ", haAdminPasswordFile=" + haAdminPasswordFile + ", clusterName=" + clusterName;
            this.getLogger().log(Level.INFO, s);
            info = new HADBInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            HADBStartDB sdb = new HADBStartDB(info);
            Object[] objectArray = sdb.startDB();
            return objectArray;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    @Override
    public Object[] restartDB(String clusterName) throws HADBSetupException {
        return this.restartDB(null, null, null, null, clusterName);
    }

    @Override
    public Object[] restartDB(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String clusterName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            String pw = haAdminPassword == null ? "null" : "******";
            String s = "HADBConfigMBean.restartDB() called with hosts=" + hosts + ", agentPort=" + agentPort + ", haAdminPassword=" + pw + ", haAdminPasswordFile=" + haAdminPasswordFile + ", clusterName=" + clusterName;
            this.getLogger().log(Level.INFO, s);
            info = new HADBInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            HADBRestartDB rsdb = new HADBRestartDB(info);
            Object[] objectArray = rsdb.restartDB();
            return objectArray;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    @Override
    public Object[] isHadbInstalled() {
        Object[] ret = HADBInfo.isHadbInstalled();
        String s = "HADBConfigMBean.isHadbInstalled() called.  Returned: " + Arrays.toString(ret);
        this.getLogger().log(Level.INFO, s);
        return ret;
    }

    @Override
    public Object[] pingHadbAgent(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String clusterName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            String pw = haAdminPassword == null ? "null" : "******";
            String s = "HADBConfigMBean.pingHadbAgent() called with hosts=" + hosts + ", agentPort=" + agentPort + ", haAdminPassword=" + pw + ", haAdminPasswordFile=" + haAdminPasswordFile + ", clusterName=" + clusterName;
            this.getLogger().log(Level.INFO, s);
            info = new HADBInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            HADBPingAgent pinger = new HADBPingAgent(info);
            Object[] objectArray = pinger.ping();
            return objectArray;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    @Override
    public Boolean getAutoHadb(String clusterName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            this.getLogger().log(Level.INFO, "HADBConfigMBean.getAutoHadb() called with cluster = " + clusterName);
            info = new HADBInfo(null, null, null, null, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setHostsRequired(false);
            info.setup();
            HADBResourceManager hrm = new HADBResourceManager(info);
            return hrm.getAutoHadbFromConfig() != false && hrm.isAvailabilityEnabled();
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
    }

    public void setAutoHadb(Boolean newAutoHadb, String clusterName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            this.getLogger().log(Level.INFO, "HADBConfigMBean.setAutoHadb() called with cluster = " + clusterName + ", new autohadb = " + newAutoHadb);
            info = new HADBInfo(null, null, null, null, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            HADBResourceManager hrm = new HADBResourceManager(info);
            hrm.setAutoHadb(newAutoHadb);
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
    }

    public String getHosts(String clusterName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            info = new HADBInfo(null, null, null, null, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            HADBResourceManager hrm = new HADBResourceManager(info);
            String hosts = hrm.getHostsFromConfig();
            this.getLogger().log(Level.INFO, "HADBConfigMBean.getHosts() called with cluster = " + clusterName + " Returned: " + hosts);
            return hosts;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
    }

    @Override
    public String getAgentPort(String clusterName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            info = new HADBInfo(null, null, null, null, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            HADBResourceManager hrm = new HADBResourceManager(info);
            String port = hrm.getAgentPortFromConfig();
            this.getLogger().log(Level.INFO, "HADBConfigMBean.getAgentPort() called with cluster = " + clusterName + " Returned: " + port);
            return port;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
    }

    @Override
    public Object[] getHADBInfo(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String clusterName) throws HADBSetupException {
        Properties p = this.getHADBDatabaseAttributes(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName);
        List<String> info = this.nameValuePropsToStrings(p);
        info.add(0, this.getHADBRuntimeInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName));
        info.add(1, STR_MGR.getString("HADB.RuntimeAttributesHeader"));
        return info.toArray();
    }

    public Object[] setAndThenGetHADBInfo(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String clusterName, String props) throws HADBSetupException {
        Properties pprops = this.setHADBDatabaseAttributes(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName, props);
        List<String> info = this.nameValuePropsToStrings(pprops);
        return info.toArray();
    }

    @Override
    public Properties setHADBDatabaseAttributes(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String clusterName, String props) throws HADBSetupException {
        return this.setHADBDatabaseAttributes(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName, props, null);
    }

    @Override
    public Properties setHADBDatabaseAttributes(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String clusterName, Properties props) throws HADBSetupException {
        return this.setHADBDatabaseAttributes(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName, null, props);
    }

    @Override
    public Properties setHADBDatabaseAttributes(String clusterName, Properties props) throws HADBSetupException {
        return this.setHADBDatabaseAttributes(null, null, null, null, clusterName, null, props);
    }

    private Properties setHADBDatabaseAttributes(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String clusterName, String sprops, Properties pprops) throws HADBSetupException {
        HADBInfo info = null;
        try {
            String pw = haAdminPassword == null ? "null" : "******";
            String s = "HADBConfigMBean.pingHadbAgent() called with hosts=" + hosts + ", agentPort=" + agentPort + ", haAdminPassword=" + pw + ", haAdminPasswordFile=" + haAdminPasswordFile + ", clusterName=" + clusterName + ", sprops=" + sprops + ", pprops=" + pprops;
            this.getLogger().log(Level.INFO, s);
            info = new HADBInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            HADBRuntimeInfo rtinfo = new HADBRuntimeInfo(info);
            if (pprops != null) {
                rtinfo.setAttributes(pprops);
            } else if (sprops != null) {
                rtinfo.setAttributes(sprops);
            }
            Properties properties = rtinfo.getAttributes();
            return properties;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    @Override
    public Properties getHADBDatabaseAttributes(String clusterName) throws HADBSetupException {
        return this.getHADBDatabaseAttributes(null, null, null, null, clusterName);
    }

    @Override
    public Properties getHADBDatabaseAttributes(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String clusterName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            String pw = haAdminPassword == null ? "null" : "******";
            String s = "HADBConfigMBean.pingHadbAgent() called with hosts=" + hosts + ", agentPort=" + agentPort + ", haAdminPassword=" + pw + ", haAdminPasswordFile=" + haAdminPasswordFile + ", clusterName=" + clusterName;
            this.getLogger().log(Level.INFO, s);
            info = new HADBInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            HADBRuntimeInfo rtinfo = new HADBRuntimeInfo(info);
            this.readWriteAttributes = rtinfo.getReadWriteAttributes();
            this.readOnlyAttributes = rtinfo.getReadOnlyAttributes();
            Properties properties = rtinfo.getAttributes();
            return properties;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    @Override
    public Properties getHADBReadOnlyDatabaseAttributes(String clusterName) throws HADBSetupException {
        this.getHADBDatabaseAttributes(null, null, null, null, clusterName);
        return this.readOnlyAttributes;
    }

    @Override
    public Properties getHADBReadWriteDatabaseAttributes(String clusterName) throws HADBSetupException {
        this.getHADBDatabaseAttributes(null, null, null, null, clusterName);
        return this.readWriteAttributes;
    }

    @Override
    public String getHADBRuntimeInfo(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String clusterName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            String pw = haAdminPassword == null ? "null" : "******";
            String s = "HADBConfigMBean.pingHadbAgent() called with hosts=" + hosts + ", agentPort=" + agentPort + ", haAdminPassword=" + pw + ", haAdminPasswordFile=" + haAdminPasswordFile + ", clusterName=" + clusterName;
            this.getLogger().log(Level.INFO, s);
            info = new HADBInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            HADBRuntimeInfo rtinfo = new HADBRuntimeInfo(info);
            String string = rtinfo.getOtherInfo();
            return string;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    @Override
    public Object[] isHA(String clusterName) {
        try {
            HADBInfo info = new HADBInfo(null, null, null, null, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setHostsRequired(false);
            info.setup();
            HADBResourceManager hrm = new HADBResourceManager(info);
            boolean isha = hrm.isHA();
            this.getLogger().log(Level.INFO, "HADBConfigMBean.isHA() called with cluster = " + clusterName + " Returned: " + isha);
            return new Object[]{isha};
        }
        catch (Exception e) {
            return new Object[]{false};
        }
    }

    @Override
    public String[] getNodeList(String clusterName) throws HADBSetupException {
        return this.getNodeList(null, null, null, null, clusterName);
    }

    @Override
    public String[] getNodeList(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String clusterName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            String pw = haAdminPassword == null ? "null" : "******";
            String s = "HADBConfigMBean.getNodeList() called with hosts=" + hosts + ", agentPort=" + agentPort + ", haAdminPassword=" + pw + ", haAdminPasswordFile=" + haAdminPasswordFile + ", clusterName=" + clusterName;
            this.getLogger().log(Level.INFO, s);
            info = new HADBInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            HADBRuntimeInfo rtinfo = new HADBRuntimeInfo(info);
            String[] stringArray = rtinfo.getNodeList();
            return stringArray;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    @Override
    public String getDatabaseStatus(String hosts, String agentPort, String haAdminPassword, String haAdminPasswordFile, String clusterName) throws HADBSetupException {
        HADBInfo info = null;
        try {
            String pw = haAdminPassword == null ? "null" : "******";
            String s = "HADBConfigMBean.getdatabaseStatus() called with hosts=" + hosts + ", agentPort=" + agentPort + ", haAdminPassword=" + pw + ", haAdminPasswordFile=" + haAdminPasswordFile + ", clusterName=" + clusterName;
            this.getLogger().log(Level.INFO, s);
            info = new HADBInfo(hosts, agentPort, haAdminPassword, haAdminPasswordFile, clusterName, this.getLogger(), this.getConfigContext(), this.getMBeanServer());
            info.setup();
            HADBRuntimeInfo rtinfo = new HADBRuntimeInfo(info);
            String string = rtinfo.getDatabaseStatus();
            return string;
        }
        catch (HADBSetupException hse) {
            throw hse;
        }
        catch (Exception e) {
            throw new HADBSetupException(e);
        }
        finally {
            if (info != null) {
                info.cleanup();
            }
        }
    }

    @Override
    public boolean isHadbmError(String s, int errno) {
        String err;
        if (s == null) {
            return false;
        }
        return (s = s.toLowerCase()).indexOf(err = "hadbm:error " + errno) >= 0;
    }

    @Override
    public boolean isAuthError(String s) {
        return this.isHadbmError(s, 22005);
    }

    private String getValue(Set<Map.Entry<Object, Object>> set, String name) {
        Iterator<Map.Entry<Object, Object>> it = set.iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            String key = (String)entry.getKey();
            if (!key.equalsIgnoreCase(name)) continue;
            it.remove();
            return (String)entry.getValue();
        }
        return null;
    }

    private List<String> nameValuePropsToStrings(Properties props) {
        ArrayList<String> list = new ArrayList<String>();
        Set<Map.Entry<Object, Object>> set = props.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            list.add(new String(entry.getKey().toString() + " = " + entry.getValue().toString()));
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public Object[] backdoor(String s1, String s2, String s3, String s4, String s5) {
        ArrayList<String> ss = new ArrayList<String>();
        if (s1 != null) {
            ss.add(s1);
        }
        if (s2 != null) {
            ss.add(s2);
        }
        if (s3 != null) {
            ss.add(s3);
        }
        if (s4 != null) {
            ss.add(s4);
        }
        if (s5 != null) {
            ss.add(s5);
        }
        BackDoor bd = new BackDoor(ss);
        return bd.exec();
    }
}

