/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.MBeanHelper;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.ee.admin.mbeanapi.NodeAgentMBean;
import com.sun.enterprise.ee.admin.mbeans.EEBaseConfigMBean;
import com.sun.enterprise.ee.admin.proxy.NodeAgentProxy;
import com.sun.enterprise.ee.admin.servermgmt.AgentException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanInfo;

public class BaseNodeAgentLogMBean
extends EEBaseConfigMBean {
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;

    protected static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    public AttributeList setAttributes(AttributeList list) {
        list = super.setAttributes(list);
        this.informNodeAgent();
        return list;
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, MBeanException, ReflectionException {
        super.setAttribute(attr);
        this.informNodeAgent();
    }

    private void informNodeAgent() {
        String agentName = null;
        try {
            agentName = this.getNodeAgentName();
            this.flushAll();
            NodeAgentMBean agentMBean = NodeAgentProxy.getNodeAgentProxy(agentName);
            agentMBean.synchronizeWithDAS();
        }
        catch (ConfigException ce) {
            BaseNodeAgentLogMBean.getLogger().log(Level.WARNING, "eeadmin.nodeagentconfig.flush_failed");
        }
        catch (AgentException ae) {
            BaseNodeAgentLogMBean.getLogger().log(Level.WARNING, "eeadmin.nodeagentconfig.agent_exp", agentName);
        }
        catch (MBeanException mbe) {
            BaseNodeAgentLogMBean.getLogger().log(Level.WARNING, "eeadmin.nodeagentconfig.mbean_exp", mbe);
        }
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(BaseNodeAgentLogMBean.getLogger());
        }
        return _handler;
    }

    private String getNodeAgentName() throws AgentException {
        try {
            String[] locs = MBeanHelper.getLocation((ModelMBeanInfo)((ModelMBeanInfo)((Object)this.getMBeanInfo())));
            return locs[1];
        }
        catch (Exception ex) {
            throw BaseNodeAgentLogMBean.getExceptionHandler().handleAgentException(ex, "nodeagent.NodeAgentConfigMBean.Exception", "unknown");
        }
    }
}

