/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.monitor;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.LoadBalancer;
import com.sun.enterprise.ee.admin.lbadmin.connection.ConnectionManager;
import com.sun.enterprise.ee.admin.lbadmin.writer.LbConfigWriter;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.logging.Logger;

public class LbMonitoringHelper {
    private ConfigContext _ctx = null;
    private String _name = null;
    private String _lbName = null;
    private ConnectionManager _connectionManager = null;
    private static final StringManager _strMgr = StringManager.getManager(LbConfigWriter.class);
    private static final String LB_MONITORING_CONTEXT_ROOT = "/lbgetmonitordata";
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");

    public LbMonitoringHelper(ConfigContext ctx, String lbConfigName, String lbName) {
        this._name = lbConfigName;
        this._lbName = lbName;
        this._ctx = ctx;
        LoadBalancer lb = null;
        try {
            lb = ((Domain)this._ctx.getRootConfigBean()).getLoadBalancers().getLoadBalancerByName(lbName);
            ElementProperty[] properties = lb.getElementProperty();
            ElementProperty host = null;
            ElementProperty port = null;
            ElementProperty proxyHost = null;
            ElementProperty proxyPort = null;
            ElementProperty secProp = null;
            for (ElementProperty prop : properties) {
                if (prop.getName().equals("ssl-proxy-host")) {
                    proxyHost = prop;
                    continue;
                }
                if (prop.getName().equals("ssl-proxy-port")) {
                    proxyPort = prop;
                    continue;
                }
                if (prop.getName().equals("device-host")) {
                    host = prop;
                    continue;
                }
                if (prop.getName().equals("device-admin-port")) {
                    port = prop;
                    continue;
                }
                if (!prop.getName().equals("is-device-ssl-enabled")) continue;
                secProp = prop;
            }
            String lbHost = host != null ? host.getValue() : null;
            String lbPort = port != null ? port.getValue() : null;
            String lbProxyHost = proxyHost != null ? proxyHost.getValue() : null;
            String lbProxyPort = proxyPort != null ? proxyPort.getValue() : null;
            boolean isSec = secProp != null ? Boolean.getBoolean(secProp.getValue()) : true;
            this._connectionManager = new ConnectionManager(lbHost, lbPort, lbProxyHost, lbProxyPort, lbName, isSec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMonitoringXml() throws IOException {
        HttpURLConnection conn = this._connectionManager.getConnection(LB_MONITORING_CONTEXT_ROOT);
        InputStream in = null;
        String xml = "";
        String s = "";
        try {
            conn.setRequestMethod("GET");
            conn.connect();
            in = conn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((s = reader.readLine()) != null) {
                xml = xml + s + "\n";
            }
        }
        finally {
            if (in != null && conn != null) {
                int code = conn.getResponseCode();
                in.close();
                conn.disconnect();
                in = null;
                conn = null;
            }
        }
        return xml;
    }

    public boolean reset() throws IOException {
        HttpURLConnection conn = this._connectionManager.getConnection("/lbgetmonitordata?reset=true");
        conn.setRequestMethod("GET");
        conn.connect();
        int code = conn.getResponseCode();
        return true;
    }
}

