/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.mbeans;

import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.LoadBalancer;
import com.sun.enterprise.config.serverbeans.LoadBalancers;
import com.sun.enterprise.ee.admin.lbadmin.mbeans.HTTPLBAdminConfigMBean;
import com.sun.enterprise.ee.admin.lbadmin.writer.LbConfigPublisher;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;

public final class LoadBalancerAdminConfig
extends BaseConfigMBean {
    private static final StringManager _strMgr = StringManager.getManager(HTTPLBAdminConfigMBean.class);
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
    private static final StringManagerBase _sMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());

    public void applyLBChanges() throws MBeanException {
        _logger.log(Level.FINE, "[LoadBalancerAdminConfig] applyLBChanges called ");
        String configName = null;
        String lbName = null;
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            LoadBalancers lbs = ((Domain)ctx.getRootConfigBean()).getLoadBalancers();
            if (lbs == null) {
                throw new MBeanException(new Exception("No Loadbalancers configured"));
            }
            lbName = (String)this.getAttribute("name");
            LoadBalancer lb = lbs.getLoadBalancerByName(lbName);
            if (lb == null) {
                throw new MBeanException(new Exception("No Loadbalancer configured by name " + lbName));
            }
            configName = lb.getLbConfigName();
            LbConfigPublisher lbp = new LbConfigPublisher(ctx, configName, lbName);
            lbp.publish();
            _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.ExportConfig", (Object)configName, (Object)lbName));
        }
        catch (Exception e) {
            String msg = _strMgr.getString("LbExportFailed", configName, lbName);
            throw new MBeanException(e, msg);
        }
    }

    public void applyLBChanges(String target) throws MBeanException {
    }

    public boolean isApplyChangeRequired() throws MBeanException {
        return true;
    }
}

