/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.ConfigAttributeManager;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBMExecutor;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBUtils;
import com.sun.enterprise.ee.admin.hadbmgmt.LoggerHelper;
import com.sun.enterprise.ee.admin.hadbmgmt.StringHelper;
import com.sun.enterprise.util.StringUtils;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HADBRuntimeInfo {
    private HADBInfo info;
    private Properties allAtts;
    private Properties readOnlyAtts;
    private Properties readWriteAtts;

    public HADBRuntimeInfo(HADBInfo info) {
        this.info = info;
    }

    public Properties getAttributes() throws HADBSetupException {
        if (this.allAtts != null) {
            return this.allAtts;
        }
        this.allAtts = new Properties();
        if (HADBUtils.noHADB()) {
            this.allAtts.setProperty("foo", "goo");
            return this.allAtts;
        }
        String[] commands = this.info.getGetAttributesCommands();
        HADBMExecutor exec = new HADBMExecutor(this.info.getExecutable(), commands);
        int exitValue = exec.exec();
        if (exitValue != 0) {
            String out = exec.getStdout();
            String err = exec.getStderr();
            String msg = StringHelper.get("hadbmgmt-res.getAttributesFailed", new Object[]{"" + exitValue, out, err});
            if (exec.isHadbmError(22005)) {
                msg = StringHelper.get("hadbmgmt-res.AuthError") + " -- " + msg;
            }
            throw new HADBSetupException(msg);
        }
        LoggerHelper.fine("***** get --all STDOUT\n" + exec.getStdout());
        LoggerHelper.fine("***** get --all STDERR\n" + exec.getStderr());
        String s = exec.getStdout();
        if (!StringUtils.ok((String)s)) {
            return this.allAtts;
        }
        String[] ss = s.split("\\s+");
        if (ss == null || ss.length == 0 || ss.length % 2 != 0) {
            throw new HADBSetupException("hadbmgmt-res.gdtAttributesFailed", new Object[]{"" + exitValue, s, exec.getStderr()});
        }
        for (int i = 2; i < ss.length; i += 2) {
            this.allAtts.setProperty(ss[i], ss[i + 1]);
        }
        return this.allAtts;
    }

    public Properties getReadOnlyAttributes() throws HADBSetupException {
        this.separateAttributes();
        return this.readOnlyAtts;
    }

    public Properties getReadWriteAttributes() throws HADBSetupException {
        this.separateAttributes();
        return this.readWriteAtts;
    }

    public void setAttributes(String sprops) throws HADBSetupException {
        String errmsg = StringHelper.get("hadbmgmt-res.BadProperties", sprops);
        if (sprops == null) {
            throw new HADBSetupException(errmsg);
        }
        if (sprops.indexOf(61) < 0) {
            throw new HADBSetupException(errmsg);
        }
        Properties props = new Properties();
        String[] pairs = sprops.split(":");
        if (pairs == null || pairs.length <= 0) {
            throw new HADBSetupException(errmsg);
        }
        for (String pair : pairs) {
            if (pair == null) {
                throw new HADBSetupException(errmsg);
            }
            String[] splitpair = pair.split("=");
            if (splitpair == null || splitpair.length != 2) {
                throw new HADBSetupException(errmsg);
            }
            if (!StringUtils.ok((String)splitpair[0]) || !StringUtils.ok((String)splitpair[1])) {
                throw new HADBSetupException(errmsg);
            }
            props.setProperty(splitpair[0], splitpair[1]);
        }
        if (props.size() < 1) {
            throw new HADBSetupException(errmsg);
        }
        this.setAttributes(props);
    }

    public void setAttributes(Properties props) throws HADBSetupException {
        if (HADBUtils.noHADB()) {
            return;
        }
        if (props == null || props.size() <= 0) {
            throw new HADBSetupException("hadbmgmt-res.NothingToDo");
        }
        String[] commands = this.info.getSetAttributesCommands(props);
        HADBMExecutor exec = new HADBMExecutor(this.info.getExecutable(), commands);
        int exitValue = exec.exec();
        if (exitValue != 0) {
            throw new HADBSetupException("hadbmgmt-res.setAttributesFailed", new Object[]{"" + exitValue, exec.getStdout(), exec.getStderr()});
        }
        LoggerHelper.fine("***** 'hadbm set' STDOUT\n" + exec.getStdout());
        LoggerHelper.fine("***** 'hadbm set' STDERR\n" + exec.getStderr());
    }

    public String getOtherInfo() throws HADBSetupException {
        String stars = "  ********  ";
        StringBuilder sb = new StringBuilder();
        sb.append("  ********  ").append(StringHelper.get("hadbmgmt-res.NodeListHeader")).append("  ********  ").append('\n').append('\n');
        sb.append(this.info.getNodeList()).append('\n').append('\n');
        sb.append("  ********  ").append(StringHelper.get("hadbmgmt-res.PackagesListHeader")).append("  ********  ").append('\n').append('\n');
        sb.append(this.info.getPackagesList()).append('\n');
        sb.append("  ********  ").append(StringHelper.get("hadbmgmt-res.dbStatusHeader")).append("  ********  ").append('\n').append('\n');
        sb.append(this.getDatabaseStatus()).append('\n');
        return sb.toString();
    }

    public String getDatabaseStatus() throws HADBSetupException {
        String[] commands = this.info.getExistsCommands();
        HADBMExecutor r = new HADBMExecutor(this.info.getExecutable(), commands);
        int exitValue = r.exec();
        String err = StringHelper.get("hadbmgmt-res.getDBStatusFailed", new Object[]{this.info.getClusterName(), exitValue, r.getStdout(), r.getStderr()});
        if (exitValue != 0) {
            throw new HADBSetupException(err);
        }
        String out = r.getStdout();
        if (out == null || out.length() < 2) {
            throw new HADBSetupException(err);
        }
        try {
            Scanner scanner = new Scanner(out);
            scanner.nextLine();
            if (!scanner.next().equals(this.info.getClusterName())) {
                throw new HADBSetupException(err);
            }
            return scanner.next();
        }
        catch (HADBSetupException he) {
            throw he;
        }
        catch (Exception e) {
            throw new HADBSetupException(err);
        }
    }

    boolean isRunning() throws HADBSetupException {
        String status = this.getDatabaseStatus();
        return !status.equals("NonOperational") && !status.equals("Stopped") && !status.equals("Unknown");
    }

    public String[] getNodeList() throws HADBSetupException {
        String raw = this.info.getNodeList();
        String err = StringHelper.get("hadbmgmt-res.getNodeListFailedB", raw);
        if (!StringUtils.ok((String)raw)) {
            throw new HADBSetupException(err);
        }
        try {
            ArrayList<String> ss = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new StringReader(raw));
            reader.readLine();
            String line = reader.readLine();
            while (line != null) {
                String[] words = line.split("\\s");
                List<String> wordlist = this.stripEmpty(words);
                if (wordlist.size() < 6) {
                    throw new HADBSetupException(err);
                }
                ss.add(wordlist.get(1) + "," + wordlist.get(4));
                line = reader.readLine();
            }
            return ss.toArray(new String[ss.size()]);
        }
        catch (Exception exception) {
            throw new HADBSetupException(err);
        }
    }

    private List<String> stripEmpty(String[] ss) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : ss) {
            if (s == null || s.length() <= 0) continue;
            list.add(s);
        }
        return list;
    }

    private void separateAttributes() throws HADBSetupException {
        if (this.readOnlyAtts != null) {
            return;
        }
        this.getAttributes();
        ConfigAttributeManager cam = new ConfigAttributeManager(this.allAtts);
        this.readOnlyAtts = cam.getReadOnlyAttributes();
        this.readWriteAtts = cam.getReadWriteAttributes();
    }
}

