/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.HADBCreateDBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBMExecutor;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.LoggerHelper;

class HADBCreateDB {
    private HADBCreateDBInfo info;

    HADBCreateDB(HADBCreateDBInfo info) {
        this.info = info;
    }

    void create() throws HADBSetupException {
        this.info.validate();
        String[] commands = this.info.getCreateCommands();
        HADBMExecutor exec = new HADBMExecutor(this.info.getExecutable(), commands);
        int exitValue = exec.exec();
        if (exitValue != 0) {
            throw new HADBSetupException("hadbmgmt-res.CreateFailed", new Object[]{"" + exitValue, exec.getStdout(), exec.getStderr()});
        }
        LoggerHelper.fine("hadbmgmt-res.CreateDBOutput", exec.getStdout(), exec.getStderr());
    }

    void delete() throws HADBSetupException {
        String[] commands = this.info.getStopCommands();
        HADBMExecutor exec = new HADBMExecutor(this.info.getExecutable(), commands);
        int exitValue = exec.exec();
        commands = this.info.getDeleteCommands();
        exec = new HADBMExecutor(this.info.getExecutable(), commands);
        exitValue = exec.exec();
        if (exitValue != 0) {
            throw new HADBSetupException("hadbmgmt-res.DeleteFailed", new Object[]{"" + exitValue, exec.getStdout(), exec.getStderr()});
        }
        LoggerHelper.fine("hadbmgmt-res.DeleteDBOutput", exec.getStdout(), exec.getStderr());
    }

    boolean exists() throws HADBSetupException {
        String[] commands = this.info.getExistsCommands();
        HADBMExecutor r = new HADBMExecutor(this.info.getExecutable(), commands);
        int exitValue = r.exec();
        if (exitValue == 0) {
            this.info.setDBPreExists();
            return true;
        }
        return false;
    }
}

