/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.ee.admin.event.EndPoint;
import com.sun.enterprise.ee.admin.event.EndPointHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

class DispatchMgr {
    private AdminEvent _event = null;
    private EndPoint[] _info = null;
    private static final String HANDLER_NAME = "event-handler-";
    private static final long DEFAULT_TIME_OUT = 3600000L;
    private static Logger _logger = null;

    DispatchMgr(AdminEvent e, EndPoint[] destinations) {
        assert (destinations != null);
        assert (e != null);
        this._event = e;
        this._info = destinations;
    }

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    synchronized AdminEventResult forward() {
        AdminEventResult retResult;
        block10: {
            retResult = null;
            try {
                int i;
                retResult = new AdminEventResult(this._event.getSequenceNumber());
                EndPointHandler[] handlers = new EndPointHandler[this._info.length];
                Thread[] eThreads = new Thread[this._info.length];
                AdminEvent[] cloneEvents = new AdminEvent[this._info.length];
                for (i = 0; i < this._info.length; ++i) {
                    cloneEvents[i] = (AdminEvent)this._event.clone();
                }
                for (i = 0; i < this._info.length; ++i) {
                    assert (this._info[i].getHost() != null);
                    cloneEvents[i].setEffectiveDestination(this._info[i].getHost());
                    handlers[i] = new EndPointHandler(cloneEvents[i], this._info[i]);
                    eThreads[i] = new Thread((Runnable)handlers[i], HANDLER_NAME + i);
                    eThreads[i].start();
                }
                int j = 0;
                for (int i2 = 0; i2 < this._info.length; ++i2) {
                    eThreads[i2].join(3600000L);
                    retResult.addEventResult(this._info[i2].getHost(), handlers[i2].getResult());
                    AdminEventResult r = handlers[i2].getResult();
                    if (r != null && (r == null || r.getResultCode().equals("success"))) continue;
                    ++j;
                }
                if (j == 0) {
                    retResult.setResultCode("success");
                } else if (j == this._info.length) {
                    retResult.setResultCode("Event did not reach any recipient");
                } else {
                    retResult.setResultCode("mixed_result");
                }
            }
            catch (Exception e) {
                DispatchMgr.getLogger().log(Level.WARNING, "eeadmin.dispatchmgr.exception", e);
                if (retResult == null) break block10;
                retResult.setResultCode("Event did not reach any recipient");
                if (this._event == null) break block10;
                retResult.addException(this._event.getTargetDestination(), (Throwable)e);
            }
        }
        return retResult;
    }
}

