/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.configbeans;

import com.sun.enterprise.admin.configbeans.BaseConfigBean;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.InvalidPortException;
import com.sun.enterprise.ee.admin.PortInUse;
import com.sun.enterprise.ee.admin.PortInUseException;
import com.sun.enterprise.ee.admin.clientreg.InstanceRegistry;
import com.sun.enterprise.ee.admin.clientreg.MBeanServerConnectionInfo;
import com.sun.enterprise.ee.admin.clientreg.NodeAgentRegistry;
import com.sun.enterprise.ee.admin.configbeans.PropertyConfigBean;
import com.sun.enterprise.ee.admin.servermgmt.AgentException;
import com.sun.enterprise.util.net.NetUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class PortConflictCheckerConfigBean
extends BaseConfigBean
implements IAdminConstants {
    private static final String PORT_SUFFIX = "port";

    public PortConflictCheckerConfigBean(ConfigContext configContext) {
        super(configContext);
    }

    public static boolean isLocalHost(String host) {
        return host.equals("localhost") || host.equals("127.0.0.1") || host.equals(System.getProperty("com.sun.aas.hostName"));
    }

    private boolean isServerRunningOnDASHost(Server s) throws ConfigException, InstanceException {
        if (!this.isBoundToHost(s)) {
            return false;
        }
        ConfigContext configContext = this.getConfigContext();
        if (ServerHelper.isDAS((ConfigContext)configContext, (Server)s)) {
            return true;
        }
        MBeanServerConnectionInfo dasInfo = InstanceRegistry.getDASConnectionInfo(configContext);
        MBeanServerConnectionInfo serverInfo = InstanceRegistry.getInstanceConnectionInfo(configContext, s.getName());
        return dasInfo.getHost().equals(serverInfo.getHost()) || PortConflictCheckerConfigBean.isLocalHost(serverInfo.getHost());
    }

    private NodeAgent[] getOtherNodeAgentsOnSameHost(NodeAgent agent) throws ConfigException, AgentException {
        ConfigContext configContext = this.getConfigContext();
        ArrayList<NodeAgent> result = new ArrayList<NodeAgent>();
        if (NodeAgentHelper.hasNodeAgentRendezvousd((ConfigContext)configContext, (NodeAgent)agent)) {
            MBeanServerConnectionInfo agentInfo = NodeAgentRegistry.getNodeAgentConnectionInfo(configContext, agent.getName());
            String hostName = agentInfo.getHost();
            NodeAgent[] agents = NodeAgentHelper.getNodeAgentsInDomain((ConfigContext)configContext);
            for (int i = 0; i < agents.length; ++i) {
                if (!NodeAgentHelper.hasNodeAgentRendezvousd((ConfigContext)configContext, (NodeAgent)agents[i]) || agents[i].getName().equals(agent.getName()) || !hostName.equals((agentInfo = NodeAgentRegistry.getNodeAgentConnectionInfo(configContext, agents[i].getName())).getHost())) continue;
                result.add(agents[i]);
            }
        }
        return result.toArray(new NodeAgent[result.size()]);
    }

    private Server[] getServersRunningOnDASHost(boolean includeDAS) throws ConfigException, InstanceException {
        ConfigContext configCtx = this.getConfigContext();
        ArrayList<Server> servers = new ArrayList<Server>();
        Server[] allServers = ServerHelper.getServersInDomain((ConfigContext)configCtx);
        for (int i = 0; i < allServers.length; ++i) {
            Server s = allServers[i];
            boolean isDAS = ServerHelper.isDAS((ConfigContext)configCtx, (Server)s);
            if (isDAS && includeDAS) {
                servers.add(s);
                continue;
            }
            if (isDAS || !this.isServerRunningOnDASHost(s)) continue;
            servers.add(s);
        }
        return servers.toArray(new Server[0]);
    }

    boolean isBoundToHost(Server server) throws ConfigException {
        ConfigContext configContext = this.getConfigContext();
        if (ServerHelper.isDAS((ConfigContext)configContext, (Server)server)) {
            return true;
        }
        NodeAgent agent = NodeAgentHelper.getNodeAgentForServer((ConfigContext)configContext, (String)server.getName());
        return NodeAgentHelper.hasNodeAgentRendezvousd((ConfigContext)configContext, (NodeAgent)agent);
    }

    private void checkForPortPropertyConflicts(String propertyName, int port, Properties serverProps, String serverName, String hostName) throws ConfigException, PortInUseException, InstanceException {
        Enumeration<?> e = serverProps.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            if (propName.toLowerCase().indexOf(PORT_SUFFIX) < 0) continue;
            String propValue = serverProps.getProperty(propName);
            try {
                if (port != Integer.parseInt(propValue)) continue;
                throw new PortInUseException(serverName, hostName, port, propertyName, propName);
            }
            catch (NumberFormatException ex) {
            }
        }
    }

    private void checkForInvalidPorts(Properties newServerProps) throws InvalidPortException {
        ArrayList<PortInUse> invalidPorts = new ArrayList<PortInUse>();
        Enumeration<?> e = newServerProps.propertyNames();
        while (e.hasMoreElements()) {
            String value;
            String name = (String)e.nextElement();
            if (name.toLowerCase().indexOf(PORT_SUFFIX) < 0 || NetUtils.isPortStringValid((String)(value = newServerProps.getProperty(name)))) continue;
            invalidPorts.add(new PortInUse(name));
        }
        if (invalidPorts.size() > 0) {
            throw new InvalidPortException(invalidPorts);
        }
    }

    private PortInUseException checkForDuplicatePorts(Properties newServerProps, String hostName, String serverName, PortInUseException exception) throws ConfigException, InstanceException {
        ConfigContext configContext = this.getConfigContext();
        PortInUseException result = exception;
        Properties serverProps = this.getPropertyConfigBean().getTargetedProperties(serverName, true);
        Enumeration<?> e = newServerProps.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.toLowerCase().indexOf(PORT_SUFFIX) < 0) continue;
            String value = newServerProps.getProperty(name);
            try {
                int port = Integer.parseInt(value);
                if (result != null && result.portAlreadyConflicts(port)) continue;
                Enumeration<?> e2 = serverProps.propertyNames();
                while (e2.hasMoreElements()) {
                    String name2 = (String)e2.nextElement();
                    if (name2.toLowerCase().indexOf(PORT_SUFFIX) < 0) continue;
                    String value2 = serverProps.getProperty(name2);
                    if (name2.equals(name) || !value.equals(value2)) continue;
                    PortInUseException ex2 = new PortInUseException(serverName, hostName, port, name, name2);
                    if (result == null) {
                        result = ex2;
                        continue;
                    }
                    result.augmentException(ex2);
                }
            }
            catch (NumberFormatException ex) {
            }
        }
        return result;
    }

    private PortInUseException checkForPortInUseConflicts(Properties serverProps, String hostName, String serverName, PortInUseException exception) throws ConfigException, InstanceException {
        ConfigContext configContext = this.getConfigContext();
        PortInUseException result = exception;
        Enumeration<?> e = serverProps.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.toLowerCase().indexOf(PORT_SUFFIX) < 0) continue;
            String value = serverProps.getProperty(name);
            try {
                int port = Integer.parseInt(value);
                if (result != null && result.portAlreadyConflicts(port) || NetUtils.isPortFree((String)hostName, (int)port)) continue;
                PortInUseException ex2 = new PortInUseException(serverName, hostName, port, name, null);
                if (result == null) {
                    result = ex2;
                    continue;
                }
                result.augmentException(ex2);
            }
            catch (NumberFormatException ex) {}
        }
        return result;
    }

    private PortInUseException checkForServerPortPropertyConflicts(Properties serverProps, String hostName, String serverName, Server[] servers, PortInUseException exception) throws ConfigException, InstanceException {
        PropertyConfigBean pcb = this.getPropertyConfigBean();
        PortInUseException result = exception;
        Enumeration<?> e = serverProps.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.toLowerCase().indexOf(PORT_SUFFIX) < 0) continue;
            String value = serverProps.getProperty(name);
            try {
                int port = Integer.parseInt(value);
                if (result != null && result.portAlreadyConflicts(port)) continue;
                String nextServerName = null;
                for (int i = 0; i < servers.length; ++i) {
                    nextServerName = servers[i].getName();
                    if (nextServerName.equals(serverName)) continue;
                    Properties props = pcb.getTargetedProperties(nextServerName, true);
                    try {
                        this.checkForPortPropertyConflicts(name, port, props, nextServerName, hostName);
                        continue;
                    }
                    catch (PortInUseException ex) {
                        if (result == null) {
                            result = ex;
                            continue;
                        }
                        result.augmentException(ex);
                    }
                }
            }
            catch (NumberFormatException ex) {
            }
        }
        return result;
    }

    void checkForPortConflicts(Server server, Properties newServerProps, boolean isServerRunning) throws ConfigException, PortInUseException, InstanceException, AgentException {
        String serverName = server.getName();
        Properties existingServerProps = this.getPropertyConfigBean().getTargetedProperties(serverName, true);
        this.checkForPortConflicts(server, existingServerProps, newServerProps, isServerRunning);
    }

    void checkForPortConflicts(Server server, Properties existingServerProps, Properties newServerProps, boolean isServerRunning) throws ConfigException, PortInUseException, InstanceException, AgentException {
        ConfigContext configContext = this.getConfigContext();
        String serverName = server.getName();
        MBeanServerConnectionInfo serverInfo = InstanceRegistry.getInstanceConnectionInfo(configContext, serverName);
        String hostName = serverInfo.getHost();
        boolean isBoundToHost = this.isBoundToHost(server);
        PortInUseException exception = null;
        this.checkForInvalidPorts(existingServerProps);
        exception = this.checkForDuplicatePorts(existingServerProps, hostName, serverName, exception);
        if (isBoundToHost) {
            if (!isServerRunning) {
                exception = this.checkForPortInUseConflicts(existingServerProps, hostName, serverName, exception);
            } else if (newServerProps != null) {
                exception = this.checkForPortInUseConflicts(newServerProps, hostName, serverName, exception);
            }
        }
        if (!ServerHelper.isDAS((ConfigContext)configContext, (Server)server)) {
            Server[] servers;
            if (this.isServerRunningOnDASHost(server)) {
                servers = new Server[]{ServerHelper.getDAS((ConfigContext)configContext)};
                exception = this.checkForServerPortPropertyConflicts(existingServerProps, hostName, serverName, servers, exception);
            }
            servers = ServerHelper.getServersOfANodeAgent((ConfigContext)configContext, (String)server.getNodeAgentRef());
            exception = this.checkForServerPortPropertyConflicts(existingServerProps, hostName, serverName, servers, exception);
            if (isBoundToHost) {
                NodeAgent agent = NodeAgentHelper.getNodeAgentForServer((ConfigContext)configContext, (String)serverName);
                NodeAgent[] agents = this.getOtherNodeAgentsOnSameHost(agent);
                for (int i = 0; i < agents.length; ++i) {
                    servers = ServerHelper.getServersOfANodeAgent((ConfigContext)configContext, (String)agents[i].getName());
                    exception = this.checkForServerPortPropertyConflicts(existingServerProps, hostName, serverName, servers, exception);
                }
            }
        } else {
            Server[] servers = this.getServersRunningOnDASHost(false);
            exception = this.checkForServerPortPropertyConflicts(existingServerProps, hostName, serverName, servers, exception);
        }
        if (exception != null) {
            throw exception;
        }
    }

    private PropertyConfigBean getPropertyConfigBean() {
        return new PropertyConfigBean(this.getConfigContext());
    }
}

