/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.concurrent;

import com.sun.enterprise.ee.admin.concurrent.Task;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Executor
implements Runnable {
    private Task[] _tasks;
    private static boolean THREADED = !Boolean.getBoolean("com.sun.appserv.notThreaded");
    private static long DEFAULT_TIMEOUT_IN_MILLIS = 300000L;
    private static Logger _logger = null;

    protected static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    public Executor(Task[] tasks) {
        this._tasks = tasks;
    }

    public void run() {
        int numTasks = this._tasks.length;
        if (THREADED) {
            int i;
            Thread[] threads = new Thread[numTasks];
            for (i = 0; i < numTasks; ++i) {
                threads[i] = new Thread(this._tasks[i]);
                threads[i].setDaemon(true);
                threads[i].start();
            }
            for (i = 0; i < numTasks; ++i) {
                try {
                    threads[i].join(this._tasks[i].getTimeoutInMillis());
                    if (!threads[i].isAlive()) continue;
                    Executor.getLogger().log(Level.WARNING, "Thread " + threads[i].getName() + " for task " + this._tasks[i] + " has timed out after " + this._tasks[i].getTimeoutInMillis() + " ms and is still alive.");
                    threads[i].interrupt();
                    if (!threads[i].isAlive()) continue;
                    Executor.getLogger().log(Level.WARNING, "Thread " + threads[i].getName() + " for task " + this._tasks[i] + " did not respond to the interrupt.");
                    continue;
                }
                catch (Exception ex) {
                    Executor.getLogger().log(Level.WARNING, "eeadmin.executor.exception", ex);
                }
            }
        } else {
            for (int i = 0; i < numTasks; ++i) {
                try {
                    this._tasks[i].run();
                    continue;
                }
                catch (Exception ex) {
                    Executor.getLogger().log(Level.WARNING, "eeadmin.executor.exception", ex);
                }
            }
        }
    }
}

