/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.enc.EncryptionProcessor;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.HarnessUtil;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.apachecrypto.DecryptionProcessor;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.KeyBindingBase;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class EncryptionFilter {
    protected static final Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl.filter", "com.sun.xml.wss.logging.impl.filter.LogStrings");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void process(FilterProcessingContext context) throws XWSSecurityException {
        block38: {
            EncryptionPolicy resolvedPolicy;
            block41: {
                EncryptionPolicy policy;
                block39: {
                    WSSPolicy originalKeyBinding;
                    block44: {
                        DerivedTokenKeyBinding dtk;
                        String dataEncAlgo;
                        WSSPolicy keyBinding;
                        boolean wss10;
                        boolean sendEKSHA1;
                        boolean wss11Sender;
                        block43: {
                            block42: {
                                block40: {
                                    KeyBindingBase binding;
                                    if (context.isInboundMessage()) break block38;
                                    resolvedPolicy = policy = (EncryptionPolicy)context.getSecurityPolicy();
                                    boolean wss11Receiver = "true".equals(context.getExtraneousProperty("EnableWSS11PolicyReceiver"));
                                    wss11Sender = "true".equals(context.getExtraneousProperty("EnableWSS11PolicySender"));
                                    sendEKSHA1 = wss11Receiver && wss11Sender && EncryptionFilter.getReceivedSecret(context) != null;
                                    boolean bl = wss10 = !wss11Sender;
                                    if (context.makeDynamicPolicyCallback()) break block39;
                                    keyBinding = (WSSPolicy)policy.getKeyBinding();
                                    dataEncAlgo = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
                                    EncryptionPolicy.FeatureBinding featureBinding = (EncryptionPolicy.FeatureBinding)policy.getFeatureBinding();
                                    String tmp = featureBinding.getDataEncryptionAlgorithm();
                                    if ((tmp == null || "".equals(tmp)) && context.getAlgorithmSuite() != null) {
                                        tmp = context.getAlgorithmSuite().getEncryptionAlgorithm();
                                    }
                                    if (tmp != null && !"".equals(tmp)) {
                                        dataEncAlgo = tmp;
                                    }
                                    if (PolicyTypeUtil.derivedTokenKeyBinding(keyBinding) && PolicyTypeUtil.x509CertificateBinding(originalKeyBinding = (dtk = (DerivedTokenKeyBinding)keyBinding.clone()).getOriginalKeyBinding())) {
                                        AuthenticationTokenPolicy.X509CertificateBinding ckBindingClone = (AuthenticationTokenPolicy.X509CertificateBinding)originalKeyBinding.clone();
                                        SymmetricKeyBinding skb = new SymmetricKeyBinding();
                                        skb.setKeyBinding(ckBindingClone);
                                        dtk.setOriginalKeyBinding(skb);
                                        keyBinding = dtk;
                                    }
                                    if (PolicyTypeUtil.x509CertificateBinding(keyBinding)) {
                                        try {
                                            binding = (AuthenticationTokenPolicy.X509CertificateBinding)keyBinding.clone();
                                            String certIdentifier = ((AuthenticationTokenPolicy.X509CertificateBinding)binding).getCertificateIdentifier();
                                            X509Certificate cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), certIdentifier, false);
                                            ((AuthenticationTokenPolicy.X509CertificateBinding)binding).setX509Certificate(cert);
                                            context.setX509CertificateBinding((AuthenticationTokenPolicy.X509CertificateBinding)binding);
                                        }
                                        catch (Exception e) {
                                            log.log(Level.SEVERE, "WSS1413.error.extracting.certificate", e);
                                            throw new XWSSecurityException(e);
                                        }
                                    }
                                    if (PolicyTypeUtil.symmetricKeyBinding(keyBinding)) {
                                        try {
                                            binding = (SymmetricKeyBinding)keyBinding.clone();
                                            String keyIdentifier = ((SymmetricKeyBinding)binding).getKeyIdentifier();
                                            SecretKey sKey = null;
                                            WSSPolicy ckBinding = (WSSPolicy)binding.getKeyBinding();
                                            if (PolicyTypeUtil.x509CertificateBinding(ckBinding)) {
                                                try {
                                                    if (!sendEKSHA1) {
                                                        AuthenticationTokenPolicy.X509CertificateBinding ckBindingClone = (AuthenticationTokenPolicy.X509CertificateBinding)ckBinding.clone();
                                                        String certIdentifier = ckBindingClone.getCertificateIdentifier();
                                                        X509Certificate cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), certIdentifier, false);
                                                        ckBindingClone.setX509Certificate(cert);
                                                        context.setX509CertificateBinding(ckBindingClone);
                                                    }
                                                }
                                                catch (Exception e) {
                                                    log.log(Level.SEVERE, "WSS1413.error.extracting.certificate", e);
                                                    throw new XWSSecurityException(e);
                                                }
                                            }
                                            if (!keyIdentifier.equals(MessageConstants._EMPTY)) {
                                                sKey = context.getSecurityEnvironment().getSecretKey(context.getExtraneousProperties(), keyIdentifier, true);
                                            } else if (sendEKSHA1) {
                                                sKey = EncryptionFilter.getReceivedSecret(context);
                                            } else if (wss11Sender || wss10) {
                                                sKey = SecurityUtil.generateSymmetricKey(dataEncAlgo);
                                            }
                                            ((SymmetricKeyBinding)binding).setSecretKey(sKey);
                                            context.setSymmetricKeyBinding((SymmetricKeyBinding)binding);
                                        }
                                        catch (Exception e) {
                                            log.log(Level.SEVERE, "WSS1414.error.extracting.symmetrickey", new Object[]{e.getMessage()});
                                            throw new XWSSecurityException(e);
                                        }
                                    }
                                    if (!PolicyTypeUtil.samlTokenPolicy(keyBinding)) break block40;
                                    keyBinding = (WSSPolicy)policy.getKeyBinding();
                                    DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                                    dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                                    dynamicContext.inBoundMessage(false);
                                    AuthenticationTokenPolicy.SAMLAssertionBinding binding2 = (AuthenticationTokenPolicy.SAMLAssertionBinding)keyBinding;
                                    binding2.isReadOnly(true);
                                    AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding = new AuthenticationTokenPolicy.SAMLAssertionBinding();
                                    if (context.getExtraneousProperty("incoming_saml_assertion") == null) {
                                        samlBinding = context.getSecurityEnvironment().populateSAMLPolicy(context.getExtraneousProperties(), binding2, dynamicContext);
                                    } else {
                                        Object assertion = context.getExtraneousProperty("incoming_saml_assertion");
                                        if (assertion instanceof Element) {
                                            samlBinding.setAssertion((Element)assertion);
                                            if (samlBinding.getAssertion() == null) {
                                                log.log(Level.SEVERE, "WSS1415.saml.assertion.notset");
                                                throw new XWSSecurityException("SAML Assertion not set by CallbackHandler  for Encryption Processing");
                                            }
                                        }
                                    }
                                    policy.setKeyBinding(samlBinding);
                                    resolvedPolicy = policy;
                                    break block41;
                                }
                                if (!PolicyTypeUtil.secureConversationTokenKeyBinding(keyBinding)) break block42;
                                SecureConversationTokenKeyBinding sctBinding = (SecureConversationTokenKeyBinding)keyBinding;
                                SecurityUtil.resolveSCT(context, sctBinding);
                                break block41;
                            }
                            if (!PolicyTypeUtil.issuedTokenKeyBinding(keyBinding)) break block43;
                            IssuedTokenKeyBinding itkb = (IssuedTokenKeyBinding)keyBinding;
                            SecurityUtil.resolveIssuedToken(context, itkb);
                            break block41;
                        }
                        if (!PolicyTypeUtil.derivedTokenKeyBinding(keyBinding)) {
                            log.log(Level.SEVERE, "WSS1422.unsupported.keybinding.EncryptionPolicy");
                            throw new XWSSecurityException("Unsupported KeyBinding for EncryptionPolicy");
                        }
                        dtk = (DerivedTokenKeyBinding)keyBinding.clone();
                        originalKeyBinding = dtk.getOriginalKeyBinding();
                        if (!PolicyTypeUtil.symmetricKeyBinding(originalKeyBinding)) break block44;
                        SymmetricKeyBinding symmBinding = (SymmetricKeyBinding)originalKeyBinding.clone();
                        SecretKey sKey = null;
                        WSSPolicy ckBinding = (WSSPolicy)originalKeyBinding.getKeyBinding();
                        if (PolicyTypeUtil.x509CertificateBinding(ckBinding)) {
                            try {
                                if (!sendEKSHA1) {
                                    AuthenticationTokenPolicy.X509CertificateBinding ckBindingClone = (AuthenticationTokenPolicy.X509CertificateBinding)ckBinding.clone();
                                    String certIdentifier = ckBindingClone.getCertificateIdentifier();
                                    X509Certificate cert = context.getSecurityEnvironment().getCertificate(context.getExtraneousProperties(), certIdentifier, false);
                                    ckBindingClone.setX509Certificate(cert);
                                    context.setX509CertificateBinding(ckBindingClone);
                                }
                            }
                            catch (Exception e) {
                                log.log(Level.SEVERE, "WSS1413.error.extracting.certificate", e);
                                throw new XWSSecurityException(e);
                            }
                        }
                        if (sendEKSHA1) {
                            sKey = EncryptionFilter.getReceivedSecret(context);
                        } else if (wss11Sender || wss10) {
                            sKey = SecurityUtil.generateSymmetricKey(dataEncAlgo);
                        }
                        symmBinding.setSecretKey(sKey);
                        context.setSymmetricKeyBinding(symmBinding);
                        break block41;
                    }
                    if (PolicyTypeUtil.secureConversationTokenKeyBinding(originalKeyBinding)) {
                        SecureConversationTokenKeyBinding sctBinding = (SecureConversationTokenKeyBinding)originalKeyBinding;
                        SecurityUtil.resolveSCT(context, sctBinding);
                        break block41;
                    } else if (PolicyTypeUtil.issuedTokenKeyBinding(originalKeyBinding)) {
                        IssuedTokenKeyBinding itkb = (IssuedTokenKeyBinding)originalKeyBinding;
                        SecurityUtil.resolveIssuedToken(context, itkb);
                    }
                    break block41;
                }
                try {
                    policy.isReadOnly(true);
                    DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                    dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                    dynamicContext.inBoundMessage(false);
                    DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(policy, dynamicContext);
                    ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
                    HarnessUtil.makeDynamicPolicyCallback(dynamicCallback, context.getSecurityEnvironment().getCallbackHandler());
                    resolvedPolicy = (EncryptionPolicy)dynamicCallback.getSecurityPolicy();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "WSS1412.error.processing.dynamicpolicy", new Object[]{e.getMessage()});
                    throw new XWSSecurityException(e);
                }
            }
            context.setSecurityPolicy(resolvedPolicy);
            EncryptionFilter.encrypt(context);
            return;
        }
        if (context.makeDynamicPolicyCallback()) {
            WSSPolicy policy = (WSSPolicy)context.getSecurityPolicy();
            EncryptionPolicy resolvedPolicy = null;
            try {
                ((EncryptionPolicy)policy).isReadOnly(true);
                DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
                dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                dynamicContext.inBoundMessage(true);
                DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(policy, dynamicContext);
                ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
                HarnessUtil.makeDynamicPolicyCallback(dynamicCallback, context.getSecurityEnvironment().getCallbackHandler());
                resolvedPolicy = (EncryptionPolicy)dynamicCallback.getSecurityPolicy();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS1420.dynamic.policy.signature", new Object[]{e.getMessage()});
                throw new XWSSecurityException(e);
            }
            context.setSecurityPolicy(resolvedPolicy);
        }
        DecryptionProcessor.decrypt(context);
    }

    private static void encrypt(FilterProcessingContext context) throws XWSSecurityException {
        if (context instanceof JAXBFilterProcessingContext) {
            new EncryptionProcessor().process((JAXBFilterProcessingContext)context);
        } else {
            com.sun.xml.wss.impl.apachecrypto.EncryptionProcessor.encrypt(context);
        }
    }

    private static SecretKey getReceivedSecret(FilterProcessingContext context) {
        SecretKey sKey = null;
        sKey = (SecretKey)context.getExtraneousProperty("SecretKeyValue");
        return sKey;
    }
}

