/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.Token;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.UserNameToken;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsernameToken
extends PolicyAssertion
implements UserNameToken,
Cloneable,
SecurityAssertionValidator {
    private String tokenType;
    private String id;
    private String includeToken = Token.INCLUDE_ALWAYS;
    private boolean populated;
    private QName itQname = new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "IncludeToken");
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private boolean hasPassword = true;

    public UsernameToken() {
        UUID uid = UUID.randomUUID();
        this.id = uid.toString();
    }

    public UsernameToken(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        UUID uid = UUID.randomUUID();
        this.id = uid.toString();
    }

    public void setType(String type) {
        this.tokenType = type;
    }

    @Override
    public String getType() {
        this.populate();
        return this.tokenType;
    }

    @Override
    public String getTokenId() {
        return this.id;
    }

    public void setTokenId(String _id) {
        this.id = _id;
    }

    @Override
    public String getIncludeToken() {
        this.populate();
        return this.includeToken;
    }

    public void setIncludeToken(String type) {
        Map<QName, String> attrs = this.getAttributes();
        QName itQname = new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "IncludeToken");
        attrs.put(itQname, type);
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    @Override
    public boolean hasPassword() {
        return this.hasPassword;
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy;
            if (this.getAttributeValue(this.itQname) != null) {
                this.includeToken = this.getAttributeValue(this.itQname);
            }
            if ((policy = this.getNestedPolicy()) == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet assertionSet = policy.getAssertionSet();
            for (PolicyAssertion assertion : assertionSet) {
                if (PolicyUtil.isUsernameTokenType(assertion)) {
                    this.tokenType = assertion.getName().getLocalPart();
                    continue;
                }
                if (PolicyUtil.hasPassword(assertion)) {
                    this.hasPassword = false;
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "UsernameToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException();
    }
}

