/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.server;

import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.rm.BufferFullException;
import com.sun.xml.ws.rm.Constants;
import com.sun.xml.ws.rm.CreateSequenceException;
import com.sun.xml.ws.rm.DuplicateMessageException;
import com.sun.xml.ws.rm.InvalidSequenceException;
import com.sun.xml.ws.rm.Message;
import com.sun.xml.ws.rm.MessageNumberRolloverException;
import com.sun.xml.ws.rm.RMConstants;
import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.RMSecurityException;
import com.sun.xml.ws.rm.TerminateSequenceException;
import com.sun.xml.ws.rm.jaxws.runtime.InboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.PipeBase;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.jaxws.runtime.server.Messages;
import com.sun.xml.ws.rm.jaxws.runtime.server.RMDestination;
import com.sun.xml.ws.rm.jaxws.runtime.server.ServerInboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.server.ServerOutboundSequence;
import com.sun.xml.ws.rm.jaxws.util.LoggingHelper;
import com.sun.xml.ws.rm.protocol.AcceptType;
import com.sun.xml.ws.rm.protocol.AckRequestedElement;
import com.sun.xml.ws.rm.protocol.CreateSequenceElement;
import com.sun.xml.ws.rm.protocol.CreateSequenceResponseElement;
import com.sun.xml.ws.rm.protocol.Identifier;
import com.sun.xml.ws.rm.protocol.OfferType;
import com.sun.xml.ws.rm.protocol.SequenceAcknowledgementElement;
import com.sun.xml.ws.rm.protocol.SequenceElement;
import com.sun.xml.ws.rm.protocol.SequenceFaultElement;
import com.sun.xml.ws.rm.protocol.TerminateSequenceElement;
import com.sun.xml.ws.runtime.util.Session;
import com.sun.xml.ws.runtime.util.SessionManager;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.secext10.ObjectFactory;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.str.DirectReference;
import com.sun.xml.ws.security.trust.elements.str.Reference;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import java.net.URI;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMServerPipe
extends PipeBase<RMDestination, ServerOutboundSequence, ServerInboundSequence> {
    public static final Logger logger = Logger.getLogger(LoggingHelper.getLoggerName(RMServerPipe.class), Messages.class.getName());
    public static final LoggingHelper loggingHelper = new LoggingHelper(logger);
    private static HashMap<String, ActionHandler> actionMap = new HashMap();
    private RMConstants constants;
    protected WSDLPort wsdlModel;
    protected WSEndpoint owner;
    protected SequenceConfig config;
    private boolean secureReliableMessaging = false;
    protected WSBinding binding;
    private SessionManager sessionManager = SessionManager.getSessionManager();

    public RMServerPipe(WSDLPort wsdlModel, WSEndpoint owner, Pipe nextPipe) {
        super(RMDestination.getRMDestination(), nextPipe);
        this.wsdlModel = wsdlModel;
        this.owner = owner;
        this.binding = this.owner.getBinding();
        this.config = this.getSequenceConfig();
        this.constants = this.config.getRMConstants();
        this.unmarshaller = this.constants.createUnmarshaller();
        this.marshaller = this.constants.createMarshaller();
    }

    private RMServerPipe(RMServerPipe toCopy, PipeCloner cloner) {
        super(RMDestination.getRMDestination(), null);
        cloner.add(toCopy, this);
        this.nextPipe = cloner.copy(toCopy.nextPipe);
        this.wsdlModel = toCopy.wsdlModel;
        this.owner = toCopy.owner;
        this.config = toCopy.config;
        this.binding = this.owner.getBinding();
        this.constants = RMConstants.getRMConstants(this.binding.getAddressingVersion());
        this.unmarshaller = this.constants.createUnmarshaller();
        this.marshaller = this.constants.createMarshaller();
    }

    @Override
    public Packet process(Packet packet) {
        Message message = null;
        SOAPFault soapFault = null;
        try {
            ServerInboundSequence inboundSequence;
            Packet ret = null;
            try {
                ret = this.handleProtocolMessage(packet);
            }
            catch (CreateSequenceException e) {
                soapFault = this.newCreateSequenceRefusedFault(e);
            }
            catch (TerminateSequenceException e) {
                soapFault = this.newSequenceTerminatedFault(e);
            }
            catch (InvalidSequenceException e) {
                soapFault = this.newUnknownSequenceFault(e);
            }
            if (ret != null) {
                return ret;
            }
            try {
                message = this.handleInboundMessage(packet);
            }
            catch (MessageNumberRolloverException e) {
                soapFault = this.newMessageNumberRolloverFault(e);
            }
            catch (InvalidSequenceException e) {
                soapFault = this.newUnknownSequenceFault(e);
            }
            Packet retPacket = null;
            if (soapFault != null) {
                com.sun.xml.ws.api.message.Message m = com.sun.xml.ws.api.message.Messages.create(soapFault);
                if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_11) {
                    Header header = Headers.create(this.constants.getJAXBContext(), (Object)new SequenceFaultElement());
                    m.getHeaders().add(header);
                }
                retPacket = packet.createServerResponse(m, this.constants.getAddressingVersion(), this.binding.getSOAPVersion(), this.constants.getAddressingVersion().getDefaultFaultAction());
                retPacket.setMessage(m);
                return retPacket;
            }
            if (this.filter != null) {
                this.filter.handleEndpointRequestMessage(message);
            }
            if ((inboundSequence = (ServerInboundSequence)message.getSequence()) == null) {
                logger.log(Level.SEVERE, Messages.NOT_RELIABLE_SEQ_OR_PROTOCOL_MESSAGE.format(new Object[0]));
                throw new RMException(Messages.NOT_RELIABLE_SEQ_OR_PROTOCOL_MESSAGE.format(new Object[0]));
            }
            inboundSequence.resetLastActivityTime();
            ServerOutboundSequence outboundSequence = (ServerOutboundSequence)inboundSequence.getOutboundSequence();
            if (this.secureReliableMessaging) {
                this.checkSTR(packet, inboundSequence);
            }
            this.setSessionData(packet, inboundSequence);
            inboundSequence.holdIfUndeliverable(message);
            packet.transportBackChannel = null;
            packet.invocationProperties.put("com.sun.xml.ws.sequence", inboundSequence);
            packet.invocationProperties.put("com.sun.xml.ws.messagenumber", message.getMessageNumber());
            ret = this.nextPipe.process(packet);
            packet.invocationProperties.put("com.sun.xml.ws.sequence", null);
            packet.invocationProperties.put("com.sun.xml.ws.messagenumber", null);
            com.sun.xml.ws.api.message.Message responseMessage = ret.getMessage();
            if (responseMessage == null) {
                com.sun.xml.ws.api.message.Message emptyMessage = com.sun.xml.ws.api.message.Messages.createEmpty(this.config.getSoapVersion());
                ret.setMessage(emptyMessage);
                ret.invocationProperties.put("onewayresponse", true);
            }
            inboundSequence.releaseNextMessage(message);
            Message om = this.handleOutboundMessage(outboundSequence, ret);
            if (this.filter != null) {
                this.filter.handleEndpointResponseMessage(om);
            }
            if (responseMessage == null && ret.getMessage() != null && !ret.getMessage().hasHeaders()) {
                ret.setMessage(null);
            } else {
                message.setRelatedMessage(om);
                if (responseMessage == null && ret.getMessage() != null) {
                    HeaderList headerList = ret.getMessage().getHeaders();
                    headerList.add(Headers.create(this.constants.getAddressingVersion().actionTag, "http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement"));
                }
            }
            return ret;
        }
        catch (BufferFullException e) {
            if (packet.getMessage().isOneWay(this.wsdlModel)) {
                Packet ret = new Packet();
                ret.invocationProperties.putAll(packet.invocationProperties);
                return ret;
            }
            try {
                ServerInboundSequence seq = (ServerInboundSequence)e.getSequence();
                if (seq != null) {
                    return this.generateAckMessage(packet, seq, this.constants.getSequenceAcknowledgementAction());
                }
                return null;
            }
            catch (RMException ee) {
                logger.severe(Messages.ACKNOWLEDGEMENT_MESSAGE_EXCEPTION.format(new Object[0]) + e);
                throw new WebServiceException(Messages.ACKNOWLEDGEMENT_MESSAGE_EXCEPTION.format(new Object[0]) + e);
            }
        }
        catch (DuplicateMessageException e) {
            com.sun.xml.ws.api.message.Message response;
            if (packet.getMessage().isOneWay(this.wsdlModel)) {
                Packet ret = new Packet();
                ret.invocationProperties.putAll(packet.invocationProperties);
                return ret;
            }
            Message original = e.getRMMessage();
            Message origresp = original.getRelatedMessage();
            if (origresp != null && (response = origresp.getCopy()) != null) {
                Packet ret = new Packet(response);
                ret.invocationProperties.putAll(packet.invocationProperties);
                return ret;
            }
            try {
                ServerInboundSequence seq = (ServerInboundSequence)original.getSequence();
                return this.generateAckMessage(packet, seq, this.constants.getSequenceAcknowledgementAction());
            }
            catch (RMException ee) {
                throw new WebServiceException((Throwable)ee);
            }
        }
        catch (RMException e) {
            com.sun.xml.ws.api.message.Message m = e.getFaultMessage();
            if (m != null) {
                return new Packet(m);
            }
            throw new WebServiceException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    @Override
    public void preDestroy() {
        this.nextPipe.preDestroy();
    }

    @Override
    public Pipe copy(PipeCloner cloner) {
        return new RMServerPipe(this, cloner);
    }

    public Packet handleProtocolMessage(Packet packet) throws RMException {
        String actionValue = packet.getMessage().getHeaders().getAction(this.constants.getAddressingVersion(), this.config.getSoapVersion());
        if (actionValue == null || actionValue.equals("")) {
            logger.severe(Messages.NON_RM_REQUEST_OR_MISSING_WSA_ACTION_HEADER.format(new Object[0]));
            throw new RMException(Messages.NON_RM_REQUEST_OR_MISSING_WSA_ACTION_HEADER.format(new Object[0]));
        }
        ActionHandler handler = actionMap.get(actionValue);
        if (handler != null) {
            return handler.process(this, packet);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Packet handleCreateSequenceAction(Packet packet) throws RMException {
        Identifier id;
        CreateSequenceElement csrElement;
        String offeredId = null;
        com.sun.xml.ws.api.message.Message message = packet.getMessage();
        try {
            csrElement = (CreateSequenceElement)message.readPayloadAsJAXB(this.unmarshaller);
        }
        catch (JAXBException e) {
            logger.severe(Messages.CREATESEQUENCE_HEADER_PROBLEM.format(new Object[0]) + (Object)((Object)e));
            throw new RMException(Messages.CREATESEQUENCE_HEADER_PROBLEM.format(new Object[0]) + (Object)((Object)e));
        }
        URI acksTo = this.constants.getAnonymousURI();
        OfferType offer = csrElement.getOffer();
        if (offer != null && (id = offer.getIdentifier()) != null) {
            offeredId = id.getValue();
        }
        ServerInboundSequence inboundSequence = ((RMDestination)this.provider).createSequence(acksTo, null, offeredId, this.config);
        inboundSequence.resetLastActivityTime();
        boolean bl = this.secureReliableMessaging = csrElement.getSecurityTokenReference() != null;
        if (this.secureReliableMessaging) {
            JAXBElement<SecurityTokenReferenceType> jaxbElem;
            SecurityTokenReferenceType strType = csrElement.getSecurityTokenReference();
            SecurityContextToken sct = (SecurityContextToken)packet.invocationProperties.get("Incoming_SCT");
            if (sct == null) throw new RMSecurityException(Messages.NULL_SECURITY_TOKEN.format(new Object[0]));
            String strId = sct.getIdentifier().toString();
            WSTrustElementFactory wsTrustElemFactory = WSTrustElementFactory.newInstance();
            SecurityTokenReference str = wsTrustElemFactory.createSecurityTokenReference(jaxbElem = new ObjectFactory().createSecurityTokenReference(strType));
            Reference ref = str.getReference();
            if (!(ref instanceof DirectReference)) throw new RMSecurityException(Messages.SECURITY_REFERENCE_ERROR.format(ref.getClass().getName()));
            DirectReference directRef = (DirectReference)ref;
            String gotId = directRef.getURIAttr().toString();
            if (!gotId.equals(strId)) throw new RMSecurityException(Messages.SECURITY_TOKEN_AUTHORIZATION_ERROR.format(gotId, strId));
            inboundSequence.setStrId(strId);
        }
        this.startSession(inboundSequence);
        if (offeredId == null) {
            inboundSequence.getOutboundSequence().saveMessages = false;
        }
        CreateSequenceResponseElement crsElement = new CreateSequenceResponseElement();
        Identifier id2 = new Identifier();
        id2.setValue(inboundSequence.getId());
        crsElement.setIdentifier(id2);
        if (offeredId != null) {
            URI dest;
            String destString = message.getHeaders().getTo(this.constants.getAddressingVersion(), this.config.getSoapVersion());
            try {
                dest = new URI(destString);
            }
            catch (Exception e) {
                logger.severe(Messages.INVALID_OR_MISSING_TO_ON_CS_MESSAGE.format(new Object[0]));
                throw new RMException(Messages.INVALID_OR_MISSING_TO_ON_CS_MESSAGE.format(new Object[0]));
            }
            AcceptType accept = new AcceptType();
            WSEndpointReference wsepr = new WSEndpointReference(dest, this.constants.getAddressingVersion());
            if (this.constants.getAddressingVersion() == AddressingVersion.W3C) {
                W3CEndpointReference endpointReference = (W3CEndpointReference)wsepr.toSpec();
                accept.setAcksTo(endpointReference);
            }
            crsElement.setAccept(accept);
        }
        com.sun.xml.ws.api.message.Message response = com.sun.xml.ws.api.message.Messages.create(this.constants.getJAXBContext(), (Object)crsElement, this.config.getSoapVersion());
        message.assertOneWay(false);
        return packet.createServerResponse(response, this.constants.getAddressingVersion(), this.config.getSoapVersion(), "http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequenceResponse");
    }

    public Packet handleTerminateSequenceAction(Packet packet) throws RMException {
        Packet ret;
        TerminateSequenceElement tsElement;
        com.sun.xml.ws.api.message.Message message = packet.getMessage();
        try {
            tsElement = (TerminateSequenceElement)message.readPayloadAsJAXB(this.unmarshaller);
        }
        catch (JAXBException e) {
            logger.severe(Messages.TERMINATE_SEQUENCE_EXCEPTION.format(new Object[0]) + (Object)((Object)e));
            throw new TerminateSequenceException(Messages.TERMINATE_SEQUENCE_EXCEPTION.format(new Object[0]) + (Object)((Object)e));
        }
        String id = tsElement.getIdentifier().getValue();
        ServerInboundSequence seq = (ServerInboundSequence)((RMDestination)this.provider).getInboundSequence(id);
        if (seq == null) {
            logger.severe(String.format("The message contains an unknown sequence id,  %s " + id, new Object[0]));
            throw new InvalidSequenceException(String.format("The message contains an unknown sequence id,  %s ", id), id);
        }
        this.endSession(seq);
        ((RMDestination)this.provider).terminateSequence(id);
        OutboundSequence outboundSequence = seq.getOutboundSequence();
        if (outboundSequence.saveMessages) {
            TerminateSequenceElement terminateSeqResponse = new TerminateSequenceElement();
            Identifier id2 = new Identifier();
            id2.setValue(outboundSequence.getId());
            terminateSeqResponse.setIdentifier(id2);
            com.sun.xml.ws.api.message.Message response = com.sun.xml.ws.api.message.Messages.create(this.constants.getJAXBContext(), (Object)terminateSeqResponse, this.config.getSoapVersion());
            ret = packet.createServerResponse(response, this.constants.getAddressingVersion(), this.config.getSoapVersion(), "http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence");
            SequenceAcknowledgementElement element = seq.generateSequenceAcknowledgement(null, this.marshaller);
            Header header = this.createHeader(element);
            response.getHeaders().add(header);
        } else {
            packet.transportBackChannel.close();
            ret = new Packet(null);
        }
        return ret;
    }

    public Packet handleLastMessageAction(Packet inbound) throws RMException {
        try {
            com.sun.xml.ws.api.message.Message message = inbound.getMessage();
            Header header = message.getHeaders().get(this.constants.getSequenceQName(), true);
            if (header == null) {
                logger.severe(Messages.INVALID_LAST_MESSAGE.format(new Object[0]));
                throw new RMException(Messages.INVALID_LAST_MESSAGE.format(new Object[0]));
            }
            SequenceElement el = (SequenceElement)header.readAsJAXB(this.unmarshaller);
            String id = el.getId();
            ServerInboundSequence seq = (ServerInboundSequence)((RMDestination)this.provider).getInboundSequence(id);
            if (seq == null) {
                logger.severe(String.format("The message contains an unknown sequence id,  %s ", id + id));
                throw new InvalidSequenceException(String.format("The message contains an unknown sequence id,  %s ", id), id);
            }
            int messageNumber = el.getNumber();
            seq.set(messageNumber, new Message(message));
            return this.generateAckMessage(inbound, seq, this.constants.getLastAction());
        }
        catch (JAXBException e) {
            logger.severe(Messages.LAST_MESSAGE_EXCEPTION.format(new Object[0]) + (Object)((Object)e));
            throw new RMException(Messages.LAST_MESSAGE_EXCEPTION.format(new Object[0]) + (Object)((Object)e));
        }
    }

    public Packet handleAckRequestedAction(Packet inbound) throws RMException {
        try {
            com.sun.xml.ws.api.message.Message message = inbound.getMessage();
            Header header = message.getHeaders().get(this.constants.getAckRequestedQName(), true);
            if (header == null) {
                logger.severe(Messages.INVALID_ACK_REQUESTED.format(new Object[0]));
                throw new RMException(Messages.INVALID_ACK_REQUESTED.format(new Object[0]));
            }
            AckRequestedElement el = (AckRequestedElement)header.readAsJAXB(this.unmarshaller);
            String id = el.getId();
            ServerInboundSequence seq = (ServerInboundSequence)((RMDestination)this.provider).getInboundSequence(id);
            if (seq == null) {
                logger.severe("The message contains an unknown sequence id,  %s " + id);
                throw new InvalidSequenceException(String.format("The message contains an unknown sequence id,  %s ", id), id);
            }
            seq.resetLastActivityTime();
            return this.generateAckMessage(inbound, seq, this.constants.getSequenceAcknowledgementAction());
        }
        catch (JAXBException e) {
            logger.severe(Messages.ACK_REQUESTED_EXCEPTION.format(new Object[0]));
            throw new RMException(Messages.ACK_REQUESTED_EXCEPTION.format(new Object[0]) + (Object)((Object)e));
        }
    }

    public Packet handleSequenceAcknowledgementAction(Packet inbound) throws RMException {
        try {
            com.sun.xml.ws.api.message.Message message = inbound.getMessage();
            Header header = message.getHeaders().get(this.constants.getSequenceAcknowledgementQName(), false);
            if (header == null) {
                logger.severe(Messages.INVALID_SEQ_ACKNOWLEDGEMENT.format(new Object[0]));
                throw new RMException(Messages.INVALID_SEQ_ACKNOWLEDGEMENT.format(new Object[0]));
            }
            SequenceAcknowledgementElement el = (SequenceAcknowledgementElement)header.readAsJAXB(this.unmarshaller);
            String id = el.getId();
            ServerInboundSequence seq = (ServerInboundSequence)((RMDestination)this.provider).getInboundSequence(id);
            seq.resetLastActivityTime();
            this.handleInboundMessage(inbound);
            inbound.transportBackChannel.close();
            Packet ret = new Packet(null);
            ret.invocationProperties.putAll(inbound.invocationProperties);
            return ret;
        }
        catch (JAXBException e) {
            logger.severe(Messages.SEQ_ACKNOWLEDGEMENT_EXCEPTION.format(new Object[0]));
            throw new RMException(Messages.SEQ_ACKNOWLEDGEMENT_EXCEPTION.format(new Object[0]) + (Object)((Object)e));
        }
    }

    public Packet handleCreateSequenceResponseAction(Packet inbound) throws RMException {
        return null;
    }

    private static void initActionMap() {
        actionMap.put("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence", new ActionHandler(){

            public Packet process(RMServerPipe pipe, Packet packet) throws RMException {
                return pipe.handleCreateSequenceAction(packet);
            }
        });
        actionMap.put("http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence", new ActionHandler(){

            public Packet process(RMServerPipe pipe, Packet packet) throws RMException {
                return pipe.handleTerminateSequenceAction(packet);
            }
        });
        actionMap.put("http://schemas.xmlsoap.org/ws/2005/02/rm/AckRequested", new ActionHandler(){

            public Packet process(RMServerPipe pipe, Packet packet) throws RMException {
                return pipe.handleAckRequestedAction(packet);
            }
        });
        actionMap.put("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage", new ActionHandler(){

            public Packet process(RMServerPipe pipe, Packet packet) throws RMException {
                return pipe.handleLastMessageAction(packet);
            }
        });
        actionMap.put("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequenceResponse", new ActionHandler(){

            public Packet process(RMServerPipe pipe, Packet packet) throws RMException {
                return pipe.handleCreateSequenceResponseAction(packet);
            }
        });
        actionMap.put("http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement", new ActionHandler(){

            public Packet process(RMServerPipe pipe, Packet packet) throws RMException {
                return pipe.handleSequenceAcknowledgementAction(packet);
            }
        });
    }

    SequenceConfig getSequenceConfig() {
        SequenceConfig ret;
        if (this.wsdlModel != null) {
            ret = new SequenceConfig(this.wsdlModel, this.binding);
            BindingID bindingid = this.wsdlModel.getBinding().getBindingId();
            if (bindingid.equals(BindingID.parse("http://schemas.xmlsoap.org/wsdl/soap/http"))) {
                ret.setSoapVersion(SOAPVersion.SOAP_11);
            } else {
                ret.setSoapVersion(SOAPVersion.SOAP_12);
            }
        } else {
            ret = new SequenceConfig();
        }
        return ret;
    }

    private void checkSTR(Packet packet, InboundSequence seq) throws RMSecurityException {
        SecurityContextToken sct = (SecurityContextToken)packet.invocationProperties.get("Incoming_SCT");
        URI uri = sct.getIdentifier();
        if (!uri.toString().equals(seq.getStrId())) {
            logger.severe(Messages.SECURITY_TOKEN_MISMATCH.format(new Object[0]));
            throw new RMSecurityException(Messages.SECURITY_TOKEN_MISMATCH.format(new Object[0]));
        }
    }

    private Packet generateAckMessage(Packet inbound, ServerInboundSequence seq) throws RMException {
        return this.generateAckMessage(inbound, seq, null);
    }

    private Packet generateAckMessage(Packet inbound, ServerInboundSequence seq, String action) throws RMException {
        com.sun.xml.ws.api.message.Message message = com.sun.xml.ws.api.message.Messages.createEmpty(this.config.getSoapVersion());
        Packet outbound = new Packet(message);
        outbound.invocationProperties.putAll(inbound.invocationProperties);
        SequenceAcknowledgementElement element = seq.generateSequenceAcknowledgement(null, this.marshaller);
        Header header = this.createHeader(element);
        message.getHeaders().add(header);
        if (action != null) {
            Header h = Headers.create(this.constants.getAddressingVersion().actionTag, action);
            message.getHeaders().add(h);
        }
        return outbound;
    }

    private SOAPFault newMessageNumberRolloverFault(MessageNumberRolloverException e) throws RMException {
        QName subcode = Constants.MESSAGE_NUMBER_ROLLOVER_QNAME;
        String faultstring = String.format("The maximum value,  %s,  for {http://schemas.xmlsoap.org/ws/2005/02/rm}:MessageNumber has been exceeded", e.getMessageNumber());
        try {
            SOAPFault fault;
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_12) {
                SOAPFactory factory = SOAPVersion.SOAP_12.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(Constants.SOAP12_SENDER_QNAME);
                fault.appendFaultSubcode(subcode);
            } else {
                SOAPFactory factory = SOAPVersion.SOAP_11.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(subcode);
            }
            fault.setFaultString(faultstring);
            return fault;
        }
        catch (SOAPException se) {
            throw new RMException(se);
        }
    }

    private SOAPFault newUnknownSequenceFault(InvalidSequenceException e) throws RMException {
        QName subcode = Constants.UNKNOWN_SEQUENCE_QNAME;
        String faultstring = String.format("The message contains an unknown sequence id,  %s ", e.getSequenceId());
        try {
            SOAPFault fault;
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_12) {
                SOAPFactory factory = SOAPVersion.SOAP_12.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(Constants.SOAP12_SENDER_QNAME);
                fault.appendFaultSubcode(subcode);
            } else {
                SOAPFactory factory = SOAPVersion.SOAP_11.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(subcode);
            }
            fault.setFaultString(faultstring);
            return fault;
        }
        catch (SOAPException se) {
            throw new RMException(se);
        }
    }

    private SOAPFault newSequenceTerminatedFault(TerminateSequenceException e) throws RMException {
        QName subcode = Constants.SEQUENCE_TERMINATED_QNAME;
        String faultstring = String.format("The sequence has been terminated because of an unrecoverable error", e.getMessage());
        try {
            SOAPFault fault;
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_12) {
                SOAPFactory factory = SOAPVersion.SOAP_12.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(Constants.SOAP12_SENDER_QNAME);
                fault.appendFaultSubcode(subcode);
            } else {
                SOAPFactory factory = SOAPVersion.SOAP_11.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(subcode);
            }
            fault.setFaultString(faultstring);
            return fault;
        }
        catch (SOAPException se) {
            throw new RMException(se);
        }
    }

    private SOAPFault newCreateSequenceRefusedFault(CreateSequenceException e) throws RMException {
        QName subcode = Constants.CREATE_SEQUENCE_REFUSED_QNAME;
        String faultstring = String.format("The create sequence request has been refused by RM Destination -- %s ", e.getMessage());
        try {
            SOAPFault fault;
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_12) {
                SOAPFactory factory = SOAPVersion.SOAP_12.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(Constants.SOAP12_SENDER_QNAME);
                fault.appendFaultSubcode(subcode);
            } else {
                SOAPFactory factory = SOAPVersion.SOAP_11.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(subcode);
            }
            fault.setFaultString(faultstring);
            return fault;
        }
        catch (SOAPException se) {
            throw new RMException(se);
        }
    }

    private Header createHeader(Object obj) {
        return Headers.create(this.constants.getJAXBRIContextHeaders(), obj);
    }

    public Session startSession(InboundSequence sequence) {
        String id = sequence.getSessionId();
        Session sess = this.sessionManager.getSession(id);
        if (sess == null) {
            sess = this.sessionManager.createSession(id);
        }
        sess.setSequence(sequence);
        return sess;
    }

    public void endSession(InboundSequence sequence) {
        String sessionId = sequence.getSessionId();
        if (sessionId.equals(sequence.getId())) {
            this.sessionManager.terminateSession(sessionId);
        }
    }

    public void setSessionData(Packet packet, InboundSequence seq) {
        if (null == packet.invocationProperties.get("com.sun.xml.ws.sessionid")) {
            packet.invocationProperties.put("com.sun.xml.ws.sessionid", seq.getSessionId());
        }
        if (null == packet.invocationProperties.get("com.sun.xml.ws.session")) {
            Session sess = this.sessionManager.getSession(seq.getSessionId());
            packet.invocationProperties.put("com.sun.xml.ws.session", sess.getUserData());
        }
    }

    static {
        RMServerPipe.initActionMap();
    }

    private static interface ActionHandler {
        public Packet process(RMServerPipe var1, Packet var2) throws RMException;
    }
}

