/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter;

import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.Invocation;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.FilteringStateMachine;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.InvocationProcessingState;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.XmlFilteringUtils;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;

public class PrivateElementFilteringStateMachine
implements FilteringStateMachine {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PrivateElementFilteringStateMachine.class);
    private int depth;
    private boolean filteringOn;
    private final QName[] filteredElements;

    public PrivateElementFilteringStateMachine(QName ... filteredElements) {
        this.filteredElements = filteredElements == null ? new QName[0] : filteredElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationProcessingState getState(Invocation invocation, XMLStreamWriter writer) {
        LOGGER.entering(invocation);
        InvocationProcessingState resultingState = InvocationProcessingState.NO_STATE_CHANGE;
        try {
            switch (invocation.getMethodType()) {
                case WRITE_START_ELEMENT: {
                    if (this.filteringOn) {
                        ++this.depth;
                        break;
                    }
                    this.filteringOn = this.startFiltering(invocation, writer);
                    if (!this.filteringOn) break;
                    resultingState = InvocationProcessingState.START_FILTERING;
                    break;
                }
                case WRITE_END_ELEMENT: {
                    if (!this.filteringOn) break;
                    if (this.depth == 0) {
                        this.filteringOn = false;
                        resultingState = InvocationProcessingState.STOP_FILTERING;
                        break;
                    }
                    --this.depth;
                    break;
                }
                case CLOSE: {
                    if (!this.filteringOn) break;
                    this.filteringOn = false;
                    resultingState = InvocationProcessingState.STOP_FILTERING;
                }
            }
            InvocationProcessingState invocationProcessingState = resultingState;
            return invocationProcessingState;
        }
        finally {
            LOGGER.exiting((Object)resultingState);
        }
    }

    private boolean startFiltering(Invocation invocation, XMLStreamWriter writer) {
        QName elementName = XmlFilteringUtils.getElementNameToWrite(invocation, XmlFilteringUtils.getDefaultNamespaceURI(writer));
        for (QName filteredElement : this.filteredElements) {
            if (!filteredElement.equals(elementName)) continue;
            return true;
        }
        return false;
    }
}

