/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.policy;

import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.encoding.policy.EncodingConstants;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.spi.ModelConfiguratorProvider;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;

public class MtomModelConfiguratorProvider
implements ModelConfiguratorProvider {
    public void configure(WSDLModel model, PolicyMap policyMap) throws PolicyException {
        if (null == model || null == policyMap) {
            return;
        }
        for (WSDLService wSDLService : model.getServices().values()) {
            for (WSDLPort wSDLPort : wSDLService.getPorts()) {
                PolicyMapKey key = PolicyMap.createWsdlEndpointScopeKey(wSDLService.getName(), wSDLPort.getName());
                Policy policy = policyMap.getEndpointEffectivePolicy(key);
                if (null == policy || !policy.contains(EncodingConstants.OPTIMIZED_MIME_SERIALIZATION_ASSERTION)) continue;
                for (AssertionSet assertionSet : policy) {
                    for (PolicyAssertion assertion : assertionSet) {
                        if (!EncodingConstants.OPTIMIZED_MIME_SERIALIZATION_ASSERTION.equals(assertion.getName()) || assertion.isOptional()) continue;
                        wSDLPort.getBinding().addFeature((WebServiceFeature)new MTOMFeature(true));
                    }
                }
            }
        }
    }
}

