/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.datetime;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.JspDisplayEvent;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.SelectableGroup;
import com.iplanet.jato.view.html.TextField;
import com.sun.web.ui.common.CCBodyContentImpl;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.common.CCJspWriterImpl;
import com.sun.web.ui.model.CCDateTimeModelInterface;
import com.sun.web.ui.taglib.alert.CCAlertInlineTag;
import com.sun.web.ui.taglib.common.CCTagBase;
import com.sun.web.ui.taglib.help.CCHelpInlineTag;
import com.sun.web.ui.taglib.html.CCButtonTag;
import com.sun.web.ui.taglib.html.CCDropDownMenuTag;
import com.sun.web.ui.taglib.html.CCHrefTag;
import com.sun.web.ui.taglib.html.CCLabelTag;
import com.sun.web.ui.taglib.html.CCTextFieldTag;
import com.sun.web.ui.taglib.legend.CCLegendTag;
import com.sun.web.ui.taglib.skip.CCSkipTag;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.datetime.CCDateTime;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCLabel;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCDateTimeTag
extends CCTagBase {
    protected static final String ATTRIB_SHOWREQUIREDMSG = "showRequiredMsg";
    protected static final String ATTRIB_STARTDATELABEL = "startDateLabel";
    protected static final String ATTRIB_STARTTIMELABEL = "startTimeLabel";
    protected static final String ATTRIB_ENDTIMELABEL = "endTimeLabel";
    protected static final String ATTRIB_SHOW_PREVIEW = "showPreviewButton";
    public static final String STR_HOURS = "datetime.unitHours";
    public static final String STR_DAYS = "datetime.unitDays";
    public static final String STR_WEEKS = "datetime.unitWeeks";
    public static final String STR_MONTHS = "datetime.unitMonths";
    private Locale locale;
    private static int rowsGap = 5;
    private int colsGap = 10;
    private static final String TALL_BLANK_ROW = "<tr>\n<td height=\"60\"></td>\n</tr>\n";
    private static final String EMPTY_ROW_HTML = "<tr><td colspan=\"4\">" + CCDateTimeTag.getImageHTMLString(CCImage.DOT, rowsGap, 1) + "</td></tr>\n";
    private static final String START_ROW_HTML = "<tr>\n<td>&nbsp;</td>\n<td nowrap=\"nowrap\"><span class=\"DatLblTxt\">";
    private static final String MID_ROW_HTML = "</span></td>\n<td>&nbsp;</td>\n<td>\n";
    private static final String END_ROW_HTML = "</td>\n</tr>\n";
    private CCDateTime dateTime = null;
    private View startDateText = null;
    private View hourCombo = null;
    private View minuteCombo = null;
    private View limitPeriodText = null;
    CCDateTimeModelInterface model = null;

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        super.getHTMLStringInternal(parent, pageContext, view);
        this.checkChildType(view, CCDateTime.class);
        this.dateTime = (CCDateTime)view;
        this.model = this.dateTime.getModel();
        if (this.model == null) {
            CCDebug.trace1("Model is null.");
            return null;
        }
        this.setParent(parent);
        this.setPageContext(pageContext);
        this.setAttributes();
        try {
            this.dateTime.beginDisplay((DisplayEvent)new JspDisplayEvent((Tag)this, pageContext));
        }
        catch (ModelControlException e) {
            throw new JspException(e.getMessage());
        }
        int type = this.model.getType();
        boolean hasEndTime = type == 0 || type == 3;
        boolean hasRepeatLimit = type == 0;
        View monthCombo = this.dateTime.getChild("monthMenu");
        View yearCombo = this.dateTime.getChild("yearMenu");
        this.startDateText = this.dateTime.getChild("startDate");
        this.checkChildType(monthCombo, CCDropDownMenu.class);
        this.checkChildType(yearCombo, CCDropDownMenu.class);
        this.checkChildType(this.startDateText, TextField.class);
        this.locale = this.getTagLocale();
        Calendar calendar = this.dateTime.getCalendar();
        Option[] options = ((CCDropDownMenu)monthCombo).getOptions().toOptionArray();
        for (int i = 0; i < options.length; ++i) {
            if (!((CCDropDownMenu)monthCombo).isSelected(options[i])) continue;
            calendar.set(2, i);
            break;
        }
        int year = new Integer(((CCDropDownMenu)yearCombo).getValue().toString());
        calendar.set(1, year);
        CCDropDownMenuTag monthComboTag = new CCDropDownMenuTag();
        CCDropDownMenuTag yearComboTag = new CCDropDownMenuTag();
        CCTextFieldTag startDateTextTag = new CCTextFieldTag();
        startDateTextTag.setAutoSubmit("false");
        startDateTextTag.setElementId(this.startDateText.getQualifiedName());
        monthComboTag.setCommandChild("defaultHref");
        yearComboTag.setCommandChild("defaultHref");
        monthComboTag.setType("jump");
        yearComboTag.setType("jump");
        monthComboTag.setBundleID(this.getBundleID());
        monthComboTag.setTabIndex(this.getTabIndex());
        monthComboTag.setTitle(this.getTagMessage("datetime.monthComboTitle"));
        yearComboTag.setBundleID(this.getBundleID());
        yearComboTag.setTabIndex(this.getTabIndex());
        yearComboTag.setTitle(this.getTagMessage("datetime.yearComboTitle"));
        startDateTextTag.setSize("12");
        startDateTextTag.setTabIndex(this.getTabIndex());
        CCButton decBtn = (CCButton)this.dateTime.getChild("decrease");
        CCButtonTag decBtnTag = new CCButtonTag();
        decBtnTag.setBundleID("com.sun.web.ui");
        decBtnTag.setTabIndex(this.getTabIndex());
        String decBtnHtml = decBtnTag.getHTMLString(parent, pageContext, (View)decBtn);
        CCButton incBtn = (CCButton)this.dateTime.getChild("increase");
        CCButtonTag incBtnTag = new CCButtonTag();
        incBtnTag.setBundleID("com.sun.web.ui");
        incBtnTag.setTabIndex(this.getTabIndex());
        String incBtnHtml = incBtnTag.getHTMLString(parent, pageContext, (View)incBtn);
        String monthHtml = monthComboTag.getHTMLString(parent, pageContext, (View)((SelectableGroup)monthCombo));
        String yearHtml = yearComboTag.getHTMLString(parent, pageContext, (View)((SelectableGroup)yearCombo));
        String startDateHtml = startDateTextTag.getHTMLString(parent, pageContext, (View)((TextField)this.startDateText));
        String calendarControlsHtml = this.createCalendarControlsHtml(monthHtml, yearHtml, decBtnHtml, incBtnHtml);
        String calendarHtml = this.createCalendarHtml(calendar, this.dateTime);
        String repeatHtml = null;
        String startTimeHtml = null;
        if (type != 2 && type != 4) {
            View repeatCombo = this.dateTime.getChild("repeatIntervalMenu");
            this.addItemsToRepeatIntervalCombo(this.dateTime);
            this.checkChildType(repeatCombo, CCDropDownMenu.class);
            CCDropDownMenuTag repeatComboTag = new CCDropDownMenuTag();
            repeatComboTag.setElementId(repeatCombo.getQualifiedName());
            repeatComboTag.setTabIndex(this.getTabIndex());
            repeatComboTag.setType("jump");
            if (hasEndTime) {
                repeatComboTag.setCommandChild("repeatIntervalHref");
            }
            repeatHtml = repeatComboTag.getHTMLString(parent, pageContext, (View)((SelectableGroup)repeatCombo));
            startTimeHtml = this.createTimeHtml(parent, pageContext, this.dateTime, "startHour", "startMinute");
        } else if (type == 4) {
            startTimeHtml = this.createTimeHtml(parent, pageContext, this.dateTime, "startHour", "startMinute");
        }
        String endTimeHtml = null;
        String repeatLimitHtml = null;
        if (hasEndTime) {
            endTimeHtml = this.createTimeHtml(parent, pageContext, this.dateTime, "endHour", "endMinute");
            if (hasRepeatLimit) {
                View limitUnitCombo = this.dateTime.getChild("repeatLimitUnit");
                this.limitPeriodText = this.dateTime.getChild("repeatLimitPeriod");
                CCDropDownMenuTag unitComboTag = new CCDropDownMenuTag();
                unitComboTag.setTabIndex(this.getTabIndex());
                unitComboTag.setBundleID("com.sun.web.ui");
                unitComboTag.setTitle(this.getTagMessage("datetime.repeatLimitTitle"));
                unitComboTag.setEscape("false");
                CCTextFieldTag periodTextTag = new CCTextFieldTag();
                periodTextTag.setElementId(this.limitPeriodText.getQualifiedName());
                if (this.addItemsToRepeatLimitUnitCombo(this.dateTime)) {
                    String trueValue = "true";
                    periodTextTag.setReadOnly(trueValue);
                    periodTextTag.setDisabled(trueValue);
                    unitComboTag.setDisabled(trueValue);
                }
                periodTextTag.setSize("3");
                periodTextTag.setTabIndex(this.getTabIndex());
                String html1 = unitComboTag.getHTMLString(parent, pageContext, (View)((SelectableGroup)limitUnitCombo));
                String html2 = periodTextTag.getHTMLString(parent, pageContext, (View)((DisplayField)this.limitPeriodText));
                repeatLimitHtml = html2 + " " + html1;
            }
        }
        String schedulerSetHtml = this.createSchedulerControlsHtml(this.dateTime.getDateFormatPattern().toLowerCase(), startTimeHtml, endTimeHtml, repeatHtml, repeatLimitHtml);
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        String label = this.getTagMessage("datetime.startDate");
        if (this.getStartDateLabel() != null) {
            label = this.getMessage(this.getStartDateLabel());
        }
        String dateHtml = this.layoutStartDateRow(label, startDateHtml, true);
        CCAlertInlineTag alertTag = new CCAlertInlineTag();
        alertTag.setBundleID("com.sun.web.ui");
        CCAlertInline alert = (CCAlertInline)this.dateTime.getChild("Alert");
        String alertHTML = "";
        String alertSummary = alert.getSummary();
        if (alertSummary != null && alertSummary.trim().length() != 0) {
            alertHTML = alertTag.getHTMLString(parent, pageContext, (View)alert);
        }
        buffer.append("\n").append(alertHTML).append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">").append("\n<tr>\n<td>&nbsp;</td>\n<td>");
        String msg = null;
        msg = this.getShowRequiredMsg() != null && this.getShowRequiredMsg().toLowerCase().equals("false") ? "&nbsp;" : this.getRequiredLabel();
        buffer.append(msg).append("</td>\n</tr><tr>\n<td colspan=\"2\">").append(CCDateTimeTag.getImageHTMLString(CCImage.DOT, 5, 1)).append("</td>\n</tr>\n<tr>\n<td valign=\"top\">").append(calendarControlsHtml).append(calendarHtml).append("</td>\n<td valign=\"top\"><table border=\"0\"").append(" cellspacing=\"0\" cellpadding=\"0\">\n<tr>\n<td>").append(CCDateTimeTag.getImageHTMLString(CCImage.DOT, 1, 30)).append("</td>\n").append(dateHtml).append("</tr><tr>\n").append(schedulerSetHtml);
        if (this.getShowPreviewButton().equals("true")) {
            CCButton previewButton = (CCButton)this.dateTime.getChild("previewButton");
            CCButtonTag previewButtonTag = new CCButtonTag();
            previewButtonTag.setBundleID("com.sun.web.ui");
            previewButtonTag.setTabIndex(this.getTabIndex());
            buffer.append("<tr><td colspan=\"4\">").append(CCDateTimeTag.getImageHTMLString(CCImage.DOT, 20, 1)).append("</td></tr>\n<tr><td colspan=\"3\">&nbsp;</td><td>").append(previewButtonTag.getHTMLString(parent, pageContext, (View)previewButton)).append(CCDateTimeTag.getImageHTMLString(CCImage.DOT, 1, 35)).append(END_ROW_HTML);
        }
        if (repeatHtml == null) {
            buffer.append(TALL_BLANK_ROW);
        }
        buffer.append("</table></td>\n</tr>\n</table>\n");
        return buffer.toString();
    }

    private String getLabel(View view, String text, boolean required) throws JspException {
        CCLabel child = new CCLabel((ContainerView)view.getParent(), view.getName() + ".Label", null);
        child.setShowRequired(required);
        CCLabelTag ccLabelTag = new CCLabelTag();
        child.setValue(text);
        ccLabelTag.setElementId(view.getQualifiedName());
        ccLabelTag.setStyleLevel("2");
        String html = ccLabelTag.getHTMLString(this.getParent(), this.pageContext, (View)child);
        return html != null ? html : "";
    }

    public void reset() {
        super.reset();
        this.locale = null;
        rowsGap = 5;
        this.colsGap = 10;
        this.dateTime = null;
        this.startDateText = null;
        this.hourCombo = null;
        this.minuteCombo = null;
        this.limitPeriodText = null;
        this.model = null;
    }

    private void addItemsToRepeatIntervalCombo(CCDateTime dateTime) {
        CCDropDownMenu repeatIntervalCombo = (CCDropDownMenu)dateTime.getChild("repeatIntervalMenu");
        String[] repeatIntervals = this.model.getRepeatIntervals();
        String[] values = new String[repeatIntervals.length];
        String[] strIntervals = new String[repeatIntervals.length];
        for (int i = 0; i < repeatIntervals.length; ++i) {
            String presentationKey = this.model.getRepeatIntervalPresentation(repeatIntervals[i]);
            strIntervals[i] = this.getTagMessage(presentationKey);
            if (presentationKey.equals(strIntervals[i])) {
                strIntervals[i] = this.getMessage(presentationKey);
            }
            strIntervals[i] = HtmlUtil.escape((String)strIntervals[i]);
            values[i] = "interval" + i;
        }
        repeatIntervalCombo.setOptions(new OptionList(strIntervals, values));
    }

    private boolean addItemsToRepeatLimitUnitCombo(CCDateTime dateTime) {
        boolean bRet = false;
        CCDropDownMenu repeatIntervalCombo = (CCDropDownMenu)dateTime.getChild("repeatIntervalMenu");
        CCDropDownMenu limitUnitCombo = (CCDropDownMenu)dateTime.getChild("repeatLimitUnit");
        String strInterval = (String)repeatIntervalCombo.getValue();
        strInterval = strInterval.substring("interval".length());
        int index = new Integer(strInterval);
        String[] repeatIntervals = this.model.getRepeatIntervals();
        String intervalName = repeatIntervals[index];
        int repeatUnit = this.model.getRepeatIntervalUnit(intervalName);
        String[] units = null;
        String[] values = null;
        if (repeatUnit == 5) {
            bRet = true;
            ((TextField)dateTime.getChild("repeatLimitPeriod")).setValue((Object)"");
            units = new String[]{"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"};
            values = new String[]{"limitUnit0"};
        } else if (repeatUnit == 0) {
            units = new String[]{STR_HOURS, STR_DAYS, STR_WEEKS, STR_MONTHS};
            values = new String[]{"limitUnit0", "limitUnit1", "limitUnit2", "limitUnit3"};
        } else if (repeatUnit == 1) {
            units = new String[]{STR_DAYS, STR_WEEKS, STR_MONTHS};
            values = new String[]{"limitUnit1", "limitUnit2", "limitUnit3"};
        } else if (repeatUnit == 2 || repeatUnit == 4) {
            units = new String[]{STR_WEEKS, STR_MONTHS};
            values = new String[]{"limitUnit2", "limitUnit3"};
        } else if (repeatUnit == 3) {
            units = new String[]{STR_MONTHS};
            values = new String[]{"limitUnit3"};
        }
        limitUnitCombo.setOptions(new OptionList(units, values));
        return bRet;
    }

    private String createTimeHtml(Tag parent, PageContext pageContext, CCDateTime dateTime, String hourChildName, String minuteChildName) throws JspException {
        this.hourCombo = dateTime.getChild(hourChildName);
        this.minuteCombo = dateTime.getChild(minuteChildName);
        this.checkChildType(this.hourCombo, CCDropDownMenu.class);
        this.checkChildType(this.minuteCombo, CCDropDownMenu.class);
        CCDropDownMenuTag hourComboTag = new CCDropDownMenuTag();
        CCDropDownMenuTag minuteComboTag = new CCDropDownMenuTag();
        hourComboTag.setTabIndex(this.getTabIndex());
        hourComboTag.setElementId(this.hourCombo.getQualifiedName());
        minuteComboTag.setTabIndex(this.getTabIndex());
        if (minuteChildName.equals("startMinute")) {
            minuteComboTag.setTitle(this.getTagMessage("datetime.startMinuteTitle"));
        } else {
            minuteComboTag.setTitle(this.getTagMessage("datetime.endMinuteTitle"));
        }
        NonSyncStringBuffer scriptBuffer = new NonSyncStringBuffer();
        scriptBuffer.append("javascript: ").append("if (this.selectedIndex == 0) this.selectedIndex = 1; ");
        minuteComboTag.setOnChange(scriptBuffer.toString());
        scriptBuffer.append("s = elements['").append(this.minuteCombo.getQualifiedName()).append("']; if(s.options[s.selectedIndex].value == '").append("  ").append("') s.selectedIndex = 1;");
        hourComboTag.setOnChange(scriptBuffer.toString());
        String hourHtml = hourComboTag.getHTMLString(parent, pageContext, (View)((SelectableGroup)this.hourCombo));
        String minuteHtml = minuteComboTag.getHTMLString(parent, pageContext, (View)((SelectableGroup)this.minuteCombo));
        Calendar calendar = dateTime.getCalendar();
        TimeZone tz = calendar.getTimeZone();
        NonSyncStringBuffer gmtTimeZone = new NonSyncStringBuffer(8192);
        gmtTimeZone.append(this.getTagMessage("datetime.gmt"));
        int value = calendar.get(15) + calendar.get(16);
        if (value < 0) {
            gmtTimeZone.append('-');
            value = -value;
        } else {
            gmtTimeZone.append('+');
        }
        int num = value / 3600000;
        if (num < 10) {
            gmtTimeZone.append("0");
        }
        gmtTimeZone.append(num).append(":");
        num = value % 3600000 / 60000;
        if (num < 10) {
            gmtTimeZone.append("0");
        }
        gmtTimeZone.append(num);
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        buffer.append("<table cellspacing=\"0\" cellpadding=\"0\">\n<tr>\n").append("<td>").append(hourHtml).append("</td>\n").append("<td>:</td>\n").append("<td>").append(minuteHtml).append("&nbsp;<span class=\"").append("DatZonTxt").append("\">").append(gmtTimeZone.toString()).append("</span></td>\n").append("</tr>\n</table>\n");
        return buffer.toString();
    }

    private String createSchedulerControlsHtml(String promptLabel, String startTimeHtml, String endTimeHtml, String repeatHtml, String repeatLimitHtml) throws JspException {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        buffer.append("<td colspan=\"3\">&nbsp;</td><td>").append(this.makeHintText(promptLabel, "field")).append("</td></tr>\n<tr><td colspan=\"4\">").append(CCDateTimeTag.getImageHTMLString(CCImage.DOT, 5, 1)).append("</td></tr>\n");
        String label = null;
        if (startTimeHtml != null) {
            String startTimeLabel = this.getTagMessage("datetime.startTime");
            if (this.getStartTimeLabel() != null) {
                startTimeLabel = this.getMessage(this.getStartTimeLabel());
            }
            label = this.getLabel(this.dateTime.getChild("startHour"), startTimeLabel, true);
            buffer.append(this.getSchedulerRow(label, startTimeHtml));
            buffer.append(EMPTY_ROW_HTML);
        }
        if (repeatHtml != null) {
            if (endTimeHtml != null) {
                String endTimeLabel = this.getTagMessage("datetime.endTime");
                if (this.getEndTimeLabel() != null) {
                    endTimeLabel = this.getMessage(this.getEndTimeLabel());
                }
                label = this.getLabel(this.hourCombo, endTimeLabel, false);
                buffer.append(this.getSchedulerRow(label, endTimeHtml));
            }
            buffer.append(EMPTY_ROW_HTML);
            label = this.getLabel(this.dateTime.getChild("repeatIntervalMenu"), this.getTagMessage("datetime.repeatInterval"), false);
            buffer.append(this.getSchedulerRow(label, repeatHtml)).append(EMPTY_ROW_HTML);
            if (repeatLimitHtml != null) {
                label = this.getLabel(this.limitPeriodText, this.getTagMessage("datetime.repeatLimit"), false);
                buffer.append(this.getSchedulerRow(label, repeatLimitHtml)).append(START_ROW_HTML).append("&nbsp;").append(MID_ROW_HTML).append(this.makeHintText(this.getTagMessage("datetime.blankForWhat"), "field")).append(END_ROW_HTML);
            } else {
                buffer.append(EMPTY_ROW_HTML).append(EMPTY_ROW_HTML);
            }
        } else {
            buffer.append(TALL_BLANK_ROW);
        }
        return buffer.toString();
    }

    private String getSchedulerRow(String col1, String col2) {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        buffer.append(START_ROW_HTML).append(col1).append(MID_ROW_HTML).append(col2).append(END_ROW_HTML);
        return buffer.toString();
    }

    private String makeHintText(String text, String type) throws JspException {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        CCHelpInlineTag helpTag = new CCHelpInlineTag();
        CCBodyContentImpl bodyContent = new CCBodyContentImpl(new CCJspWriterImpl(null, 100, false));
        try {
            bodyContent.print(text);
        }
        catch (IOException e) {
            CCDebug.trace3(e.getMessage());
        }
        helpTag.setType(type);
        helpTag.setBodyContent(bodyContent);
        buffer.append(helpTag.getHTMLString(this.getParent(), this.pageContext, (View)this.dateTime));
        return buffer.toString();
    }

    private String getRequiredLabel() throws JspException {
        CCLegendTag legendTag = new CCLegendTag();
        return legendTag.getHTMLString(this.getParent(), this.pageContext, null);
    }

    private String layoutStartDateRow(String label, String startDateHtml, boolean required) throws JspException {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        buffer.append("<td nowrap=\"nowrap\">").append(this.getLabel(this.startDateText, label, required)).append("</td>\n<td>").append(CCDateTimeTag.getImageHTMLString(CCImage.DOT, 1, this.colsGap)).append("</td>\n<td>").append(startDateHtml).append("</td>\n");
        return buffer.toString();
    }

    private String createCalendarControlsHtml(String monthHtml, String yearHtml, String decBtnHtml, String incBtnHtml) {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        SimpleDateFormat df = (SimpleDateFormat)this.dateTime.getDateFormat();
        String datePattern = df.toLocalizedPattern();
        boolean yearFirst = false;
        String align = "left";
        if (datePattern.indexOf(121) < datePattern.indexOf(77)) {
            yearFirst = true;
            align = "right";
        }
        buffer.append("<div class=\"").append("DatSelDiv").append("\">\n<table border=\"0\" cellpadding=\"0\" ").append("cellspacing=\"0\">\n").append("<tr>\n").append("<td");
        if (yearFirst) {
            buffer.append(" align=\"right\">").append(yearHtml).append("<td>").append(CCDateTimeTag.getImageHTMLString(CCImage.DOT, 1, 8)).append("</td>\n<td align=\"right\"");
            align = "right";
        }
        buffer.append(">\n").append(decBtnHtml).append("</td>\n").append("<td align=\"").append(align).append("\">\n").append(monthHtml).append("</td>\n").append("<td align=\"").append(align).append("\">\n").append(incBtnHtml).append("</td>\n");
        if (!yearFirst) {
            buffer.append("<td>").append(CCDateTimeTag.getImageHTMLString(CCImage.DOT, 1, 8)).append("</td>\n").append("<td>\n").append(yearHtml).append("</td>\n");
        }
        buffer.append("</tr>\n").append("</table>\n</div>\n");
        return buffer.toString();
    }

    private String createCalendarHtml(Calendar calendar, CCDateTime dateTime) throws JspException {
        View startDateText = dateTime.getChild("startDate");
        String startDateFieldName = startDateText.getQualifiedName();
        DateFormat format = dateTime.getDateFormat();
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        buffer.append("<div class=\"").append("DatCalDiv").append("\">\n<table class=\"").append("DatCalTbl").append("\" width=\"100%\" cellspacing=\"1\"").append(" cellpadding=\"0\" border=\"0\">\n");
        String[] days = new String[]{this.getTagMessage("datetime.weekdaySun"), this.getTagMessage("datetime.weekdayMon"), this.getTagMessage("datetime.weekdayTue"), this.getTagMessage("datetime.weekdayWed"), this.getTagMessage("datetime.weekdayThu"), this.getTagMessage("datetime.weekdayFri"), this.getTagMessage("datetime.weekdaySat")};
        int firstDay = calendar.getFirstDayOfWeek();
        if (firstDay == 2) {
            Vector<String> vec = new Vector<String>();
            for (int i = 1; i < 7; ++i) {
                vec.addElement(days[i]);
            }
            vec.addElement(days[0]);
            days = vec.toArray(days);
        }
        buffer.append("<tr>\n");
        for (int i = 0; i < 7; ++i) {
            buffer.append("<th align=\"center\" scope=\"col\"><span class=\"").append("DatDayHdrTxt").append("\"").append(">").append(days[i]).append("</span></th>\n");
        }
        buffer.append("</tr>\n");
        calendar.set(5, 1);
        SimpleDateFormat dateFormat1 = new SimpleDateFormat("MM/dd/yyyy");
        int maxDay = calendar.getActualMaximum(5);
        int day = calendar.get(7);
        int offset = day - firstDay;
        int dd = 1;
        int diff = offset;
        String strMonth = null;
        int year = 0;
        int process = -1;
        int date = 0;
        while (dd <= maxDay) {
            buffer.append("<tr>\n");
            for (int i = 0; i < 7; ++i) {
                String dateText;
                String strDay;
                Calendar newCalendar;
                if (dd > maxDay) {
                    if (process != 2) {
                        process = 2;
                        newCalendar = (Calendar)calendar.clone();
                        newCalendar.set(5, maxDay);
                        newCalendar.add(5, 1);
                        int month = newCalendar.get(2) + 1;
                        strMonth = (month < 10 ? "0" : "") + month;
                        year = newCalendar.get(1);
                        date = 1;
                    }
                    strDay = "0" + date;
                    dateText = this.changeDateFormat(dateFormat1, format, strMonth + "/" + strDay + "/" + year);
                    this.addOneDay2Calendar(dateTime, buffer, startDateFieldName, date, dateText, false);
                    ++date;
                    continue;
                }
                if (diff > 0) {
                    if (process != 0) {
                        process = 0;
                        newCalendar = (Calendar)calendar.clone();
                        newCalendar.add(5, -1);
                        int month = newCalendar.get(2) + 1;
                        strMonth = month < 10 ? "0" + month : Integer.toString(month);
                        year = newCalendar.get(1);
                        date = newCalendar.get(5) - diff + 1;
                    }
                    strDay = Integer.toString(date);
                    dateText = this.changeDateFormat(dateFormat1, format, strMonth + "/" + strDay + "/" + year);
                    this.addOneDay2Calendar(dateTime, buffer, startDateFieldName, date, dateText, false);
                    ++date;
                    --diff;
                    continue;
                }
                if (process != 1) {
                    process = 1;
                    int month = calendar.get(2) + 1;
                    year = calendar.get(1);
                    strMonth = (month < 10 ? "0" : "") + month;
                    dd = 1;
                }
                strDay = dd < 10 ? "0" + dd : Integer.toString(dd);
                dateText = this.changeDateFormat(dateFormat1, format, strMonth + "/" + strDay + "/" + year);
                this.addOneDay2Calendar(dateTime, buffer, startDateFieldName, dd, dateText, true);
                ++dd;
            }
            buffer.append("</tr>\n");
        }
        buffer.append("</table>\n</div>\n");
        CCSkipTag skipTag = new CCSkipTag();
        skipTag.setBundleID(this.getBundleID());
        skipTag.setColor(CCImage.COLOR_MEDIUM_GREY1);
        skipTag.setTabIndex(this.getTabIndex());
        try {
            CCBodyContentImpl bodyContent = new CCBodyContentImpl(new CCJspWriterImpl(null, 100, false));
            bodyContent.print(buffer.toString());
            skipTag.setBodyContent(bodyContent);
        }
        catch (IOException e) {
            CCDebug.trace1(e.getMessage());
        }
        skipTag.setAlt(HtmlUtil.escape((String)this.getTagMessage("datetime.skipTagAltText")));
        return skipTag.getHTMLString(this.getParent(), this.pageContext, null);
    }

    private String changeDateFormat(DateFormat format1, DateFormat format2, String dateTextForFormat1) {
        try {
            Date date = format1.parse(dateTextForFormat1);
            return format2.format(date);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    private void addOneDay2Calendar(CCDateTime dateTime, NonSyncStringBuffer buffer, String startDateFieldName, int day, String dateText, boolean bIsCurrentMonth) throws JspException {
        CCHref href;
        DateFormat format = dateTime.getDateFormat();
        boolean isScheduled = false;
        try {
            Date date = format.parse(dateText);
            Calendar c = dateTime.getCalendar();
            c.setTime(date);
            c.set(11, 23);
            c.set(12, 59);
            date = c.getTime();
            isScheduled = dateTime.isOneDayScheduled(date);
        }
        catch (ParseException ex) {
            // empty catch block
        }
        String style = null;
        style = !bIsCurrentMonth ? (isScheduled ? "DatOthBldLnk" : "DatOthLnk") : (isScheduled ? "DatBldLnk" : "DatLnk");
        CCHrefTag hrefTag = new CCHrefTag();
        try {
            href = (CCHref)dateTime.getChild("DateHREF");
        }
        catch (Exception e) {
            CCDebug.trace1("Error getting day of month href");
            return;
        }
        href.setValue(dateText);
        hrefTag.setStyleClass(style);
        hrefTag.setSubmitFormData("true");
        hrefTag.setTabIndex(this.getTabIndex());
        hrefTag.setTitle(this.getTagMessage("datetime.setDate", new Object[]{dateText}));
        try {
            CCBodyContentImpl bodyContent = new CCBodyContentImpl(new CCJspWriterImpl(null, 100, false));
            bodyContent.print(day);
            hrefTag.setBodyContent(bodyContent);
        }
        catch (IOException e) {
            CCDebug.trace1(e.getMessage());
        }
        buffer.append("<td align=\"center\">").append(hrefTag.getHTMLString(this.getParent(), this.pageContext, (View)href)).append("</td>\n");
    }

    protected void setAttributes() {
        if (this.model.isShowRequiredMsgSet()) {
            this.setShowRequiredMsg(Boolean.toString(this.model.getShowRequiredMsg()));
        }
        if (this.model.getStartDateLabel() != null) {
            this.setStartDateLabel(this.model.getStartDateLabel());
        }
        if (this.model.getStartTimeLabel() != null) {
            this.setStartTimeLabel(this.model.getStartTimeLabel());
        }
        if (this.model.getEndTimeLabel() != null) {
            this.setEndTimeLabel(this.model.getEndTimeLabel());
        }
        if (this.dateTime.getShowPreviewButton() != null) {
            this.setShowPreviewButton(this.dateTime.getShowPreviewButton().toString());
        }
    }

    public void setShowRequiredMsg(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_SHOWREQUIREDMSG, value);
    }

    public String getShowRequiredMsg() {
        return (String)this.getValue(ATTRIB_SHOWREQUIREDMSG);
    }

    public void setStartDateLabel(String value) {
        this.setValue(ATTRIB_STARTDATELABEL, value);
    }

    public String getStartDateLabel() {
        return (String)this.getValue(ATTRIB_STARTDATELABEL);
    }

    public void setStartTimeLabel(String value) {
        this.setValue(ATTRIB_STARTTIMELABEL, value);
    }

    public String getStartTimeLabel() {
        return (String)this.getValue(ATTRIB_STARTTIMELABEL);
    }

    public void setEndTimeLabel(String value) {
        this.setValue(ATTRIB_ENDTIMELABEL, value);
    }

    public String getEndTimeLabel() {
        return (String)this.getValue(ATTRIB_ENDTIMELABEL);
    }

    public void setShowPreviewButton(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_SHOW_PREVIEW, value);
    }

    public String getShowPreviewButton() {
        return this.getValue(ATTRIB_SHOW_PREVIEW) != null ? (String)this.getValue(ATTRIB_SHOW_PREVIEW) : "false";
    }
}

