/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.util;

import com.sun.enterprise.tools.guiframework.view.ViewDescriptorManager;
import com.sun.enterprise.tools.guiframework.view.ViewXMLEntityResolver;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import javax.servlet.ServletConfig;
import org.xml.sax.EntityResolver;

public class PreloadXML
extends Thread {
    private String _xmlFileName = null;
    private ServletConfig _config = null;

    public PreloadXML(String name, String xmlFileName, ServletConfig config) {
        super(name);
        this.setXMLFileName(xmlFileName);
        this._config = config;
    }

    public PreloadXML(ServletConfig config) {
        this("PreloadXML", null, config);
        String xmlFile = "xml/eeViewDescriptor.xml";
        URL xmlURL = null;
        try {
            xmlURL = this.getClass().getClassLoader().getResource(xmlFile);
            if (xmlURL == null) {
                xmlURL = new URL("file:///" + this._config.getServletContext().getRealPath(xmlFile));
                xmlURL.openConnection().connect();
            }
        }
        catch (Exception ex) {
            xmlFile = "xml/viewDescriptor.xml";
        }
        this.setXMLFileName(xmlFile);
    }

    public static boolean isAlreadyLoaded() {
        ViewDescriptorManager vdm = ViewDescriptorManager.getInstance();
        return vdm.getViewDescriptorURL() != null;
    }

    public void deserialize() {
        ViewDescriptorManager vdm = ViewDescriptorManager.getInstance();
        try {
            vdm.deserialize(new ObjectInputStream(this.getClass().getClassLoader().getResourceAsStream("viewXML.ser")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    public void run() {
        this.init();
        this.deserialize();
    }

    protected void init() {
        URL xmlURL = null;
        try {
            xmlURL = this.getClass().getClassLoader().getResource(this._xmlFileName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            ViewDescriptorManager vdm = ViewDescriptorManager.getInstance();
            if (PreloadXML.isAlreadyLoaded()) {
                return;
            }
            if (xmlURL == null) {
                xmlURL = new URL("file:///" + this._config.getServletContext().getRealPath(this._xmlFileName));
            }
            vdm.setViewDescriptorURL(xmlURL);
            vdm.setDTDURLBase("/xml/");
            vdm.setJSPRoot("/jsp/");
            vdm.setViewXMLEntityResolver((EntityResolver)new ViewXMLEntityResolver());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void printUsage() {
        System.out.println("You must specify the xml file name:\n");
        System.out.println("Usage:\n");
        System.out.println("java " + PreloadXML.class.getName() + " <xml file name>\n");
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            PreloadXML.printUsage();
            return;
        }
        PreloadXML pre = new PreloadXML("na", args[0], (ServletConfig)null);
        pre.init();
        ViewDescriptorManager vdm = ViewDescriptorManager.getInstance();
        vdm.getViewDescriptor("TopFrameset");
        try {
            vdm.serialize(new ObjectOutputStream(new FileOutputStream("viewXML.ser")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        System.out.println("Success!");
    }

    public String getXMLFileName() {
        return this._xmlFileName;
    }

    public void setXMLFileName(String name) {
        this._xmlFileName = name;
    }
}

