/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.tree;

import com.sun.enterprise.tools.admingui.tree.IndexTreeModel;
import com.sun.enterprise.tools.admingui.tree.IndexTreeNode;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MonitorTreeNode
extends IndexTreeNode
implements Serializable {
    protected List reserveKids = new ArrayList();

    public MonitorTreeNode(IndexTreeNode parent, String type, String name, IndexTreeModel model) {
        super(parent, type, name, model);
    }

    protected void ensureChildren() {
        block3: {
            if (!this.getRefresh()) {
                return;
            }
            try {
                this.updateKids();
            }
            catch (Exception ex) {
                if (!Util.isLoggableINFO()) break block3;
                Util.logINFO("ERROR in IndexTreeNode.ensureChildren.", ex);
            }
        }
        this.setRefresh(false);
    }

    private void updateKids() {
        int i;
        String objectName = (String)this.getAttribute("objectName");
        if (objectName == null || objectName.length() == 0) {
            throw new RuntimeException("Object name attribute is required for tree node: " + this.getName());
        }
        objectName = this.replaceTokens(objectName);
        for (i = 0; i < this.children.size(); ++i) {
            if (this.reserveKids.contains(this.children.get(i))) continue;
            this.reserveKids.add(this.children.get(i));
        }
        this.children.clear();
        block1: for (i = 0; i < this.reserveKids.size(); ++i) {
            IndexTreeNode node = (IndexTreeNode)this.reserveKids.get(i);
            Object monitorAttr = node.getAttribute("monitorAttr");
            if (monitorAttr == null) {
                this.children.add(node);
                continue;
            }
            if (monitorAttr instanceof String) {
                String value = (String)MBeanUtil.getAttribute(objectName, (String)monitorAttr);
                if (value == null || value.equalsIgnoreCase("off")) continue;
                this.children.add(node);
                continue;
            }
            if (!(monitorAttr instanceof ArrayList)) continue;
            Iterator it = ((List)monitorAttr).iterator();
            while (it.hasNext()) {
                String value = (String)MBeanUtil.getAttribute(objectName, (String)it.next());
                if (value == null || value.equalsIgnoreCase("off")) continue;
                this.children.add(node);
                continue block1;
            }
        }
    }
}

