/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.tree;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingTreeViewBase;
import com.iplanet.jato.view.SimpleTreeViewStateData;
import com.iplanet.jato.view.TreeViewStateData;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.view.html.ImageField;
import com.iplanet.jato.view.html.StaticTextField;
import com.sun.enterprise.tools.admingui.handlers.TargetHandlers;
import com.sun.enterprise.tools.admingui.tree.IndexTreeModel;
import com.sun.enterprise.tools.admingui.tree.IndexTreeNode;
import com.sun.enterprise.tools.admingui.tree.NodeNotFoundException;
import com.sun.enterprise.tools.admingui.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.management.ObjectName;
import javax.servlet.ServletException;

public class IndexTreeView
extends RequestHandlingTreeViewBase {
    public static final String CHILD_NAME = "name";
    public static final String CHILD_SHOW_ROOT = "root";
    public static final String CHILD_SHOW_LEAF = "showLeaf";
    public static final String CHILD_SHOW_CONTAINER = "showContainer";
    public static final String CHILD_SHOW_ROOT_I = "Iroot";
    public static final String CHILD_SHOW_LEAF_I = "IshowLeaf";
    public static final String CHILD_SHOW_CONTANER_I = "IshowContainer";
    public static final String CHILD_HANDLE_IMAGE = "Handle";
    private NewTagsText newTags = null;
    private static Object osync = new Object();

    public IndexTreeView(View parent, String name) {
        super(parent, name, Util.getCurrentTreeModel().getStateDataName());
        this.setPrimaryModel(Util.getCurrentTreeModel());
        this.registerChildren();
    }

    protected IndexTreeModel getIndexTreeModel() {
        return (IndexTreeModel)this.getPrimaryModel();
    }

    protected void registerChildren() {
        this.registerChild(CHILD_NAME, StaticTextField.class);
        this.registerChild(CHILD_SHOW_ROOT, HREF.class);
        this.registerChild(CHILD_SHOW_LEAF, HREF.class);
        this.registerChild(CHILD_SHOW_CONTAINER, HREF.class);
        this.registerChild(CHILD_SHOW_ROOT_I, ImageField.class);
        this.registerChild(CHILD_SHOW_LEAF_I, ImageField.class);
        this.registerChild(CHILD_SHOW_CONTANER_I, ImageField.class);
        this.registerChild(CHILD_HANDLE_IMAGE, ImageField.class);
    }

    protected View createChild(String name) {
        if (name.equals(CHILD_NAME)) {
            StaticTextField child = new StaticTextField((View)this, (Model)this.getIndexTreeModel(), CHILD_NAME, CHILD_NAME, (Object)"", null);
            return child;
        }
        if (name.equals(CHILD_SHOW_ROOT) || name.equals(CHILD_SHOW_LEAF) || name.equals(CHILD_SHOW_CONTAINER)) {
            return new HREF((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_SHOW_ROOT_I) || name.equals(CHILD_HANDLE_IMAGE) || name.equals(CHILD_SHOW_LEAF_I) || name.equals(CHILD_SHOW_CONTANER_I)) {
            return new ImageField((ContainerView)this, name, null);
        }
        return null;
    }

    public TreeViewStateData getStateData() {
        String dataName = Util.getCurrentTreeModel().getStateDataName();
        if (!this.getStateDataLookupName().equals(dataName)) {
            this.setStateDataLookupName(dataName);
            TreeViewStateData data = (TreeViewStateData)this.getRequestContext().getRequest().getSession().getAttribute(dataName);
            if (data == null) {
                data = new SimpleTreeViewStateData(new HashMap());
            }
            super.setStateData(data);
        }
        return super.getStateData();
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        IndexTreeModel model = Util.getCurrentTreeModel();
        this.setPrimaryModel(model);
        if (this.getPrimaryModel() == null) {
            throw new ModelControlException("Primary model is null");
        }
        super.beginDisplay(event);
        model.beforeRoot();
        model.nextNode();
        this.getStateData().setNodeExpanded(model.getNodeID(), true);
        IndexTreeNode root = model.getRoot();
        String count = (String)root.getAttribute("kidsToOpen");
        if (count != null) {
            int max = new Integer(count);
            root.setAttribute("kidsToOpen", null);
            Iterator it = root.getChildren().iterator();
            for (int i = 0; it.hasNext() && i < max; ++i) {
                this.getStateData().setNodeExpanded(((IndexTreeNode)it.next()).getPath(), true);
            }
        }
        this.newTags = new NewTagsText();
    }

    public String endIrootDisplay(ChildContentDisplayEvent event) {
        String content = event.getContent();
        this.newTags.setImgTag(content);
        return "";
    }

    public String endRootDisplay(ChildContentDisplayEvent event) {
        String content = event.getContent();
        this.newTags.setHrefTag(content);
        this.newTags.rootNode = true;
        String newContent = this.newTags.toString();
        return newContent;
    }

    public String endIshowLeafDisplay(ChildContentDisplayEvent event) {
        String content = event.getContent();
        this.newTags.setImgTag(content);
        return "";
    }

    public String endShowLeafDisplay(ChildContentDisplayEvent event) {
        String content = event.getContent();
        this.newTags.setHrefTag(content);
        String newContent = this.newTags.toString();
        return newContent;
    }

    public String endIshowContainerDisplay(ChildContentDisplayEvent event) {
        String content = event.getContent();
        this.newTags.setImgTag(content);
        return "";
    }

    public String endShowContainerDisplay(ChildContentDisplayEvent event) {
        String content = event.getContent();
        this.newTags.setHrefTag(content);
        String newContent = this.newTags.toString();
        return newContent;
    }

    public String endGetIdDisplay(ChildContentDisplayEvent event) {
        String id = ((IndexTreeModel)this.getPrimaryModel()).getNodeHID();
        return id;
    }

    public String endTableRowDisplay(ChildContentDisplayEvent event) {
        String tr = "<tr ";
        IndexTreeNode node = (IndexTreeNode)((IndexTreeModel)this.getPrimaryModel()).getCurrentNode();
        if (node.getType().equalsIgnoreCase(CHILD_SHOW_ROOT)) {
            String rootClass = (String)node.getAttribute("rootClass");
            if (rootClass == null) {
                rootClass = "TreRotRow";
            }
            tr = tr + "height=\"30\" class=\"" + rootClass + "\" id=\"r" + node.getHighlightID() + "\">";
        } else {
            tr = tr + "id=\"c" + node.getHighlightID() + "\">";
        }
        return tr;
    }

    public String endAddTdDisplay(ChildContentDisplayEvent event) {
        String content = event.getContent();
        return this.newTags.beginTD2 + content.trim() + this.newTags.endTD;
    }

    public boolean beginHasNextSiblingDisplay(ChildDisplayEvent event) {
        return this.newTags.hasNextSibling();
    }

    public boolean beginHasNoNextSiblingDisplay(ChildDisplayEvent event) {
        return !this.newTags.hasNextSibling();
    }

    public boolean beginHasContainerKidsDisplay(ChildDisplayEvent event) {
        IndexTreeNode node = this.getIndexTreeModel().getNode(this.getPrimaryModel().getNodeID());
        return node.getChildren().size() > 0;
    }

    public boolean beginHasNoContainerKidsDisplay(ChildDisplayEvent event) {
        return !this.beginHasContainerKidsDisplay(event);
    }

    public boolean beginShowContainerDisplay(ChildDisplayEvent event) {
        HREF href = (HREF)this.getDisplayField(CHILD_SHOW_CONTAINER);
        href.setValue(this.getIndexTreeModel().getValue("id"));
        IndexTreeNode node = this.getIndexTreeModel().getNode(this.getPrimaryModel().getNodeID());
        node.setIsExpanded(this.getStateData().isNodeExpanded(this.getPrimaryModel().getNodeID()));
        return true;
    }

    public boolean beginRootDisplay(ChildDisplayEvent event) {
        HREF href = (HREF)this.getDisplayField(CHILD_SHOW_ROOT);
        href.setValue(this.getIndexTreeModel().getValue("id"));
        IndexTreeNode node = this.getIndexTreeModel().getNode(this.getPrimaryModel().getNodeID());
        node.setIsExpanded(this.getStateData().isNodeExpanded(this.getPrimaryModel().getNodeID()));
        return true;
    }

    public boolean beginShowLeafDisplay(ChildDisplayEvent event) {
        HREF href = (HREF)this.getDisplayField(CHILD_SHOW_LEAF);
        href.setValue(this.getIndexTreeModel().getValue("id"));
        IndexTreeNode node = this.getIndexTreeModel().getNode(this.getPrimaryModel().getNodeID());
        node.setIsExpanded(this.getStateData().isNodeExpanded(this.getPrimaryModel().getNodeID()));
        return true;
    }

    private void handleNode(String nodeID, RequestInvocationEvent event) throws ModelControlException, ClassNotFoundException, ServletException, IOException, NodeNotFoundException {
        IndexTreeNode selectedNode = this.getIndexTreeModel().getNode(nodeID);
        selectedNode.handleSelection(this.getRequestContext());
    }

    public void handleShowLeafRequest(RequestInvocationEvent event) throws ModelControlException, ClassNotFoundException, ServletException, IOException, NodeNotFoundException {
        this.handleNode((String)this.getDisplayFieldValue(CHILD_SHOW_LEAF), event);
    }

    public void handleRootRequest(RequestInvocationEvent event) throws ModelControlException, ClassNotFoundException, ServletException, IOException, NodeNotFoundException {
        this.handleNode((String)this.getDisplayFieldValue(CHILD_SHOW_ROOT), event);
    }

    public void handleShowContainerRequest(RequestInvocationEvent event) throws ModelControlException, ClassNotFoundException, ServletException, IOException, NodeNotFoundException {
        this.handleNode((String)this.getDisplayFieldValue(CHILD_SHOW_CONTAINER), event);
    }

    class NewTagsText {
        public final String beginTD1 = "<td align=\"left\" valign=\"center\" width=\"24\" nowrap=\"nowrap\">";
        public final String beginTD2 = "<td align=\"left\" valign=\"center\" nowrap=\"nowrap\">";
        public final String endTD = "</td>\n";
        public final String restartImg = "<img src=\"../images/restartServer.gif\" alt=\"restart\" border=\"0\"/>";
        public final String hrefExtras = "title=\"@@@@\" onmouseover=\"window.status='@@@@'; return true\" onmouseout=\"window.status=''; return true\" onkeypress=\"javascript: this.onClick();\" onblur=\"window.status=''; return true\" onfocus=\"window.status='@@@@'; return true\" ";
        private String imgTag;
        private String hrefTag;
        private Stack sibs;
        public boolean rootNode;

        public NewTagsText() {
            this.reset();
        }

        private void reset() {
            this.imgTag = null;
            this.hrefTag = null;
            this.sibs = null;
            this.rootNode = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNextSibling() {
            if (this.sibs == null) {
                Object object = osync;
                synchronized (object) {
                    this.sibs = new Stack();
                    IndexTreeModel model = (IndexTreeModel)IndexTreeView.this.getPrimaryModel();
                    int level = ((IndexTreeModel)IndexTreeView.this.getPrimaryModel()).getNodeLevel();
                    for (IndexTreeNode node = (IndexTreeNode)model.getCurrentNode(); node != null && (level <= 1 || node.getParent() != null); node = node.getParent()) {
                        Boolean bool = new Boolean(node.getNextSibling() != null);
                        this.sibs.push(bool);
                        this.sibs.push(bool);
                    }
                }
            }
            if (this.sibs.empty()) {
                if (Util.isLoggableFINE()) {
                    Util.logFINE("IndexTreeView.hasNextSibling: Next Sibling Stack is Empty!", null);
                }
                return false;
            }
            Boolean answer = (Boolean)this.sibs.pop();
            return answer;
        }

        public void setImgTag(String s) {
            this.imgTag = s;
        }

        public void setHrefTag(String s) {
            this.hrefTag = s;
        }

        private String addHref(String text, String hrefTag) {
            if (hrefTag == null) {
                return text;
            }
            int i = hrefTag.indexOf(62);
            if (i < 0) {
                return text;
            }
            return hrefTag.substring(0, i + 1) + "\n" + text + "</a>";
        }

        public String toString() {
            String adminServerConfigName;
            String adminServerName;
            String id = ((IndexTreeModel)IndexTreeView.this.getPrimaryModel()).getNodeHID();
            boolean expanded = IndexTreeView.this.getStateData().isNodeExpanded(IndexTreeView.this.getPrimaryModel().getNodeID());
            String icon = ((IndexTreeModel)IndexTreeView.this.getPrimaryModel()).getIconName(expanded);
            IndexTreeNode node = (IndexTreeNode)((IndexTreeModel)IndexTreeView.this.getPrimaryModel()).getCurrentNode();
            if (this.imgTag == null && this.hrefTag == null) {
                return "";
            }
            if (this.imgTag != null && this.hrefTag == null) {
                return this.imgTag;
            }
            if (this.imgTag == null && this.hrefTag != null) {
                return this.hrefTag;
            }
            String status = "";
            String showStatus = (String)node.getAttribute("showStatus", false);
            try {
                if (showStatus != null && showStatus.equalsIgnoreCase("true")) {
                    String objName = (String)node.getAttribute("objectName", false);
                    status = "&nbsp;" + TargetHandlers.getStatusIconHtml(new ObjectName(objName));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.hrefTag = this.hrefTag.replaceAll("this", id);
            String displayName = (String)node.getAttribute("displayName", false);
            if (displayName == null) {
                displayName = node.getName();
            }
            if ((adminServerName = (String)node.getAttribute("adminServerName", false)) != null && displayName.equalsIgnoreCase(adminServerName)) {
                displayName = displayName + " (" + Util.getMessage("tree.adminServer") + ")";
                String asIcon = Util.getMessage("tree.adminServerImage");
                if (asIcon != null && asIcon.length() > 0) {
                    icon = asIcon;
                }
            }
            if ((adminServerConfigName = (String)node.getAttribute("adminServerConfigName", false)) != null && displayName.equalsIgnoreCase("server-config")) {
                displayName = displayName + " (" + Util.getMessage("tree.adminServerConfig") + ")";
                String asIcon = Util.getMessage("tree.adminServerConfigImage");
                if (asIcon != null && asIcon.length() > 0) {
                    icon = asIcon;
                }
            }
            if (!displayName.equals(node.getName())) {
                this.hrefTag = this.addHref(displayName, this.hrefTag);
            }
            String hrefImageTag = this.hrefTag = Util.addHtmlProp(this.hrefTag, "title=\"@@@@\" onmouseover=\"window.status='@@@@'; return true\" onmouseout=\"window.status=''; return true\" onkeypress=\"javascript: this.onClick();\" onblur=\"window.status=''; return true\" onfocus=\"window.status='@@@@'; return true\" ".replaceAll("@@@@", displayName));
            String newImgTag = Util.addHtmlProp(Util.removeHtmlProp(this.imgTag, IndexTreeView.CHILD_NAME), "name=\"i" + id + "\"");
            if (this.rootNode) {
                Object obj = RequestManager.getRequestContext().getRequest().getAttribute("restartRequired");
                boolean replaceIcon = false;
                if (obj != null) {
                    if (obj instanceof Boolean) {
                        replaceIcon = (Boolean)obj;
                    } else if (obj instanceof String) {
                        replaceIcon = "true".equalsIgnoreCase((String)obj);
                    }
                }
                if (replaceIcon) {
                    String rrIcon = Util.getMessage("icon.InstanceRestartRequired");
                    if (rrIcon != null && !rrIcon.equals("")) {
                        icon = rrIcon;
                    }
                    String rrText = Util.getMessage("masthead.restartRequired");
                    hrefImageTag = Util.addHtmlProp(Util.removeHtmlProp(this.hrefTag, "title"), "title=\"" + rrText + "\"");
                    hrefImageTag = Util.addHtmlProp(Util.removeHtmlProp(hrefImageTag, "href"), "href=\"../admingui/restart\"");
                }
            }
            newImgTag = Util.addHtmlProp(Util.removeHtmlProp(newImgTag, "src"), "src=\"../images/" + icon + "\"");
            String newTag = "<td align=\"left\" valign=\"center\" width=\"24\" nowrap=\"nowrap\">" + this.addHref(newImgTag, hrefImageTag) + "</td>\n";
            newTag = newTag + "<td align=\"left\" valign=\"center\" nowrap=\"nowrap\">" + Util.addHtmlProp(this.hrefTag, "id=\"a" + id + "\"") + status + "</td>\n";
            this.reset();
            return newTag.trim();
        }
    }
}

