/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.verifier;

import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.PolicyViolationException;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.impl.policy.spi.PolicyVerifier;

public class SignaturePolicyVerifier
implements PolicyVerifier {
    public void verifyPolicy(SecurityPolicy configPolicy, SecurityPolicy recvdPolicy) throws PolicyViolationException {
        if (PolicyTypeUtil.signaturePolicy(configPolicy) && PolicyTypeUtil.signaturePolicy(recvdPolicy)) {
            SignaturePolicy rsignPolicy = (SignaturePolicy)recvdPolicy;
            SignaturePolicy csignPolicy = (SignaturePolicy)configPolicy;
            SignaturePolicy.FeatureBinding rfBinding = (SignaturePolicy.FeatureBinding)rsignPolicy.getFeatureBinding();
            SignaturePolicy.FeatureBinding cfBinding = (SignaturePolicy.FeatureBinding)csignPolicy.getFeatureBinding();
            String cCanonAlgo = cfBinding.getCanonicalizationAlgorithm();
            String rCanonAlgo = rfBinding.getCanonicalizationAlgorithm();
            if (!(cCanonAlgo == null || cCanonAlgo.length() <= 0 || rCanonAlgo == null && rCanonAlgo.length() <= 0 || rCanonAlgo.equals(cCanonAlgo))) {
                throw new PolicyViolationException("Receiver side requirement verification failed, canonicalization algorithm received in the message is " + rfBinding.getCanonicalizationAlgorithm() + " policy requires " + cfBinding.getCanonicalizationAlgorithm());
            }
            WSSPolicy ckeyBinding = (WSSPolicy)csignPolicy.getKeyBinding();
            if (ckeyBinding != null) {
                String cKeyType = ckeyBinding.getType();
                WSSPolicy rkeyBinding = (WSSPolicy)rsignPolicy.getKeyBinding();
                if (rkeyBinding == null) {
                    throw new PolicyViolationException("KeyType used to sign the message doesnot match with  the receiver side requirements. Configured KeyType is " + ckeyBinding + " KeyType inferred from the message is  " + rkeyBinding);
                }
                String rKeyType = rkeyBinding.getType();
                if (rKeyType != cKeyType) {
                    throw new PolicyViolationException("KeyType used to sign the message doesnot match with  the receiver side requirements. Configured KeyType is " + ckeyBinding + " KeyType inferred from the message is  " + rkeyBinding);
                }
                if (cKeyType != "SAMLAssertionBinding" && cKeyType == "X509CertificateBinding") {
                    this.checkX509CertificateBinding((AuthenticationTokenPolicy.X509CertificateBinding)ckeyBinding, (AuthenticationTokenPolicy.X509CertificateBinding)rkeyBinding);
                }
            }
        }
    }

    private void checkSAMLAssertionBinding(AuthenticationTokenPolicy.SAMLAssertionBinding configPolicy, AuthenticationTokenPolicy.SAMLAssertionBinding recvdPolicy) throws PolicyViolationException {
        boolean matched = true;
        String _cAI = configPolicy.getAuthorityIdentifier();
        String _rAI = recvdPolicy.getAuthorityIdentifier();
        if (_cAI != null && _cAI.length() > 0 && _rAI != null) {
            matched = _cAI.equals(_rAI);
            this._throwError(configPolicy, recvdPolicy, matched);
        }
    }

    private void checkX509CertificateBinding(AuthenticationTokenPolicy.X509CertificateBinding configPolicy, AuthenticationTokenPolicy.X509CertificateBinding recvdPolicy) throws PolicyViolationException {
        boolean matched = true;
        String ckeyAlg = configPolicy.getKeyAlgorithm();
        String rkeyAlg = recvdPolicy.getKeyAlgorithm();
        if (ckeyAlg != null && ckeyAlg.length() > 0 && rkeyAlg.length() > 0) {
            matched = ckeyAlg.equals(rkeyAlg);
        }
        this._throwError(configPolicy, recvdPolicy, matched);
        String cRT = configPolicy.getReferenceType();
        String rRT = recvdPolicy.getReferenceType();
        if (cRT != null && cRT.length() > 0) {
            matched = cRT.equals(rRT);
        }
        this._throwError(configPolicy, recvdPolicy, matched);
        String cVT = configPolicy.getValueType();
        String rVT = recvdPolicy.getValueType();
        if (cVT != null && cVT.length() > 0 && rVT.length() > 0) {
            matched = cVT.equals(rVT);
        }
        this._throwError(configPolicy, recvdPolicy, matched);
    }

    private final void _throwError(SecurityPolicy configPolicy, SecurityPolicy recvdPolicy, boolean matched) throws PolicyViolationException {
        if (!matched) {
            throw new PolicyViolationException("KeyType used to sign the message doesnot match with  the receiver side requirements. Configured KeyType is " + configPolicy + " KeyType inferred from the message is  " + recvdPolicy);
        }
    }
}

