/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.corbaname;

import com.sun.jndi.cosnaming.CNCtx;
import com.sun.jndi.url.corbaname.CNCtxHelper;
import com.sun.jndi.url.corbaname.CorbanameUrl;
import com.sun.jndi.url.corbaname.corbanameURLContext;
import com.sun.logging.LogDomains;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ResolveResult;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class corbanameURLContextFactory
implements ObjectFactory {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.naming");
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_PORT = "2089";
    public static final String[] tests = new String[]{"corbaname:rir:", "corbaname:rir:/NameService", "corbaname:rir:/dev/NameService", "corbaname:rir:,rir:/NameService", "corbaname::", "corbaname::orbhost:999#this/is/a/name", "corbaname::orbhost:999,:webhost#this/is/a/name", "corbaname::orbhost:999,:webhost/key/String#this/is/a/name", "corbaname:iiop:", "corbaname:iiop:orbhost:999#this/is/a/name", "corbaname:iiop:orbhost:999,iiop:webhost#this/is/a/name", "corbaname:iiop:orbhost:999,iiop:webhost/key/String#this/is/a/name", "corbaname:iiop:orbhost:999,:webhost#this/is/a/name", "corbaname::orbhost:999,iiop:webhost#this/is/a/name", "corbaname:foo:bar#this/is/a/name"};

    public java.lang.Object getObjectInstance(java.lang.Object urlInfo, Name name, Context nameCtx, Hashtable env) throws Exception {
        if (urlInfo == null) {
            return new corbanameURLContext(env);
        }
        if (urlInfo instanceof String) {
            return corbanameURLContextFactory.getUsingURL((String)urlInfo, env);
        }
        if (urlInfo instanceof String[]) {
            return corbanameURLContextFactory.getUsingURLs((String[])urlInfo, env);
        }
        throw new IllegalArgumentException("iiopURLContextFactory.getObjectInstance: argument must be an iiop URL String or array of iiop URLs");
    }

    static ResolveResult getUsingURLIgnoreRest(String url, Hashtable env) throws NamingException {
        ORB inOrb;
        ORB oRB = inOrb = env != null ? (ORB)env.get("java.naming.corba.orb") : null;
        if (inOrb != null) {
            try {
                CorbanameUrl parsedUrl = new CorbanameUrl(url);
                Object ncRef = null;
                try {
                    ncRef = inOrb.string_to_object(parsedUrl.getLocation());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (ncRef != null) {
                    Context ctx = CNCtxHelper.getInstance(inOrb, ncRef, env);
                    return new ResolveResult((java.lang.Object)ctx, parsedUrl.getCosName());
                }
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException(e.getMessage());
            }
        }
        url = corbanameURLContextFactory.rewriteUrl(url);
        return CNCtx.createUsingURL((String)url, (Hashtable)env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static java.lang.Object getUsingURL(String url, Hashtable env) throws NamingException {
        ResolveResult res = corbanameURLContextFactory.getUsingURLIgnoreRest(url, env);
        Context ctx = (Context)res.getResolvedObj();
        try {
            java.lang.Object object = ctx.lookup(res.getRemainingName());
            return object;
        }
        finally {
            ctx.close();
        }
    }

    private static java.lang.Object getUsingURLs(String[] urls, Hashtable env) {
        for (int i = 0; i < urls.length; ++i) {
            String url = urls[i];
            try {
                java.lang.Object obj = corbanameURLContextFactory.getUsingURL(url, env);
                if (obj == null) continue;
                return obj;
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        return null;
    }

    static String rewriteUrl(String url) throws NamingException {
        String objAddrList;
        String corbaloc;
        String stringName = null;
        int hash = url.indexOf(35);
        if (hash >= 0) {
            stringName = url.substring(hash + 1);
            corbaloc = url.substring(10, hash);
        } else {
            corbaloc = url.substring(10);
        }
        int firstSlash = corbaloc.indexOf(47);
        if (firstSlash >= 0) {
            String keyString = corbaloc.substring(firstSlash + 1);
            if ("".equals(keyString)) {
                keyString = "NameService";
            } else if (!"NameService".equals(keyString)) {
                throw new InvalidNameException("Support is available only for the NameService key string");
            }
            objAddrList = corbaloc.substring(0, firstSlash);
        } else {
            objAddrList = corbaloc;
        }
        int len = objAddrList.length();
        int start = 0;
        StringBuffer newUrl = new StringBuffer("iiopname://");
        while (start < len) {
            int colon = objAddrList.indexOf(58, start);
            String prot = objAddrList.substring(start, colon);
            if (prot.equals("") || prot.equals("iiop")) {
                String addr;
                int comma = objAddrList.indexOf(44, colon + 1);
                if (comma < 0) {
                    addr = objAddrList.substring(colon + 1, len);
                    start = len;
                } else {
                    addr = objAddrList.substring(colon + 1, comma);
                    start = comma + 1;
                }
                newUrl.append(addr);
                if (addr.indexOf(58) < 0) {
                    newUrl.append(':');
                    newUrl.append(DEFAULT_PORT);
                }
                if (comma < 0) continue;
                newUrl.append(',');
                continue;
            }
            if (prot.equals("rir")) {
                newUrl.append(DEFAULT_HOST);
                newUrl.append(':');
                newUrl.append(DEFAULT_PORT);
                start = colon + 1;
                if (start == len) continue;
                throw new InvalidNameException("Only one rir is supported");
            }
            throw new InvalidNameException("Unknown subscheme: " + url);
        }
        if (stringName != null) {
            newUrl.append('/');
            newUrl.append(stringName);
        }
        return newUrl.toString();
    }

    public static void main(String[] args) {
        for (int i = 0; i < tests.length; ++i) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, tests[i]);
            }
            try {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "    " + corbanameURLContextFactory.rewriteUrl(tests[i]));
                continue;
            }
            catch (NamingException e) {
                _logger.log(Level.SEVERE, "java_jndi.excep_in_main", e);
            }
        }
    }
}

