/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.DeployEventListenerHelper;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.event.ModuleDeployEventListener;
import com.sun.enterprise.appclient.jws.AppclientJWSSupportManager;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.instance.AppclientModulesManager;
import com.sun.enterprise.server.AbstractLoader;
import com.sun.enterprise.server.AbstractManager;
import com.sun.enterprise.server.ApplicationClientModuleLoader;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;

class StandAloneAppClientModulesManager
extends AbstractManager
implements ModuleDeployEventListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager("com.sun.enterprise.server");

    StandAloneAppClientModulesManager(AppclientModulesManager acModuleManager, ClassLoader sharedCL) {
        super(sharedCL, acModuleManager);
        AdminEventListenerRegistry.addModuleDeployEventListener(this);
        AppclientJWSSupportManager.getInstance();
    }

    public synchronized void moduleDeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        boolean jsr77 = false;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In StandAloneAppClientModulesManager moduleDeployed");
            _logger.log(Level.FINEST, "ModuleType=" + event.getModuleType());
        }
        if (event.getModuleType().equals("appclient")) {
            DeployEventListenerHelper.getDeployEventListenerHelper().synchronize(event);
            String modID = event.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "modID=" + modID);
            }
            try {
                this.configManager.refreshConfigContext(event.getConfigContext());
                String action = event.getAction();
                if (action.equals("deploy") || action.equals("redeploy")) {
                    jsr77 = true;
                }
                if (!this.moduleDeployed(jsr77, modID)) {
                    String msg = localStrings.getString("appClientModule deploy failed", modID);
                    throw new AdminEventListenerException(msg);
                }
            }
            catch (ConfigException ce) {
                throw new AdminEventListenerException(ce.getMessage());
            }
        }
    }

    public synchronized void moduleUndeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        String action;
        boolean jsr77 = false;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In StandAloneAppClientModulesManager moduleUndeployed");
        }
        if ((action = event.getAction()).equals("undeploy") || action.equals("redeploy")) {
            jsr77 = true;
        }
        try {
            if (event.getModuleType().equals("appclient")) {
                String modID = event.getModuleName();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "UnDeploying module: " + modID);
                }
                if (!this.moduleUndeployed(jsr77, modID)) {
                    String msg = localStrings.getString("appclient.appclient_undeployed_failed", modID);
                    throw new AdminEventListenerException(msg);
                }
            }
        }
        catch (Exception e) {
            throw new AdminEventListenerException(e.getMessage());
        }
    }

    public synchronized void moduleRedeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In StandAloneAppClientModulesManager moduleRedeployed");
        }
        if (event.getModuleType().equals("appclient")) {
            String modID = event.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "ReDeploying module: " + modID);
            }
            this.moduleUndeployed(event);
            this.moduleDeployed(event);
        }
    }

    public synchronized void moduleEnabled(ModuleDeployEvent event) throws AdminEventListenerException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In StandAloneAppClientModulesManager moduleEnabled");
        }
    }

    public synchronized void moduleDisabled(ModuleDeployEvent event) throws AdminEventListenerException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "In StandAloneAppClientModulesManager moduleDisabled");
        }
    }

    private boolean moduleDeployed(boolean jsr77, String modID) {
        boolean result = false;
        boolean loadJSR77 = jsr77 || this.loadJSR77(modID, DeployableObjectType.CAR);
        try {
            AbstractLoader modLoader = this.getLoader(modID);
            if (loadJSR77) {
                try {
                    modLoader.createRootMBean();
                }
                catch (MBeanException mbe) {
                    _logger.log(Level.WARNING, "core.error_while_creating_jsr77_root_mbean", mbe);
                }
            }
            if (result = modLoader.load(loadJSR77)) {
                this.id2loader.put(modID, modLoader);
            }
        }
        catch (Exception ce) {
            _logger.log(Level.WARNING, "core.error_while_loading_application_client_module", ce);
            result = false;
        }
        return result;
    }

    private boolean moduleUndeployed(boolean jsr77, String modID) {
        boolean result = false;
        try {
            ApplicationClientModuleLoader modLoader = (ApplicationClientModuleLoader)this.id2loader.remove(modID);
            if (modLoader == null) {
                return true;
            }
            if (jsr77) {
                try {
                    modLoader.deleteRootMBean();
                }
                catch (MBeanException mbe) {
                    _logger.log(Level.WARNING, "core.error_while_deleting_jsr77_root_mbean", mbe);
                }
            }
            result = modLoader.unload(jsr77);
        }
        catch (Exception ce) {
            _logger.log(Level.WARNING, "core.error_while_unloading_application_client_module", ce);
            result = false;
        }
        return result;
    }

    protected AbstractLoader getLoader(String moduleId) {
        return new ApplicationClientModuleLoader(moduleId, this.parentClassLoader, (AppclientModulesManager)this.configManager);
    }

    public void moduleReferenceAdded(ModuleDeployEvent event) throws AdminEventListenerException {
    }

    public void moduleReferenceRemoved(ModuleDeployEvent event) throws AdminEventListenerException {
    }
}

