/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans.custom;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.mbeans.custom.CMBStrings;
import com.sun.enterprise.admin.mbeans.custom.CustomMBeanConfigQueries;
import com.sun.enterprise.admin.mbeans.custom.CustomMBeanException;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Mbean;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicCustomMBeanConfigQueries
implements CustomMBeanConfigQueries {
    protected final ConfigContext acc = MBeanRegistryFactory.getAdminContext().getAdminConfigContext();

    @Override
    public boolean existsMBean(String target, String name) throws CustomMBeanException {
        List<String> names = this.listMBeanNames(target);
        boolean exists = false;
        for (String aName : names) {
            if (!aName.equals(name)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    @Override
    public boolean isMBeanEnabled(String target, String name) throws CustomMBeanException {
        boolean enabled = false;
        if (!this.existsMBean(target, name)) {
            String msg = CMBStrings.get("MBeanNotFound", name, target);
            throw new CustomMBeanException(msg);
        }
        List<ObjectName> ons = this.listMBeanConfigObjectNames(target);
        try {
            MBeanServer mbsc = MBeanServerFactory.getMBeanServer();
            String noe = "enabled";
            for (ObjectName on : ons) {
                String s = (String)mbsc.getAttribute(on, "enabled");
                if (!Boolean.valueOf(s).booleanValue()) continue;
                enabled = true;
                break;
            }
            return enabled;
        }
        catch (Exception e) {
            throw new CustomMBeanException(e);
        }
    }

    @Override
    public List<ObjectName> listMBeanConfigObjectNames(String target) throws CustomMBeanException {
        Target t = null;
        try {
            t = TargetBuilder.INSTANCE.createTarget(target, this.acc);
        }
        catch (Exception e) {
            throw new CustomMBeanException(e);
        }
        return this.listMBeanConfigObjectNamesForServer(t.getName());
    }

    @Override
    public List<ObjectName> listMBeanConfigObjectNames(String target, int type, boolean state) throws CustomMBeanException {
        throw new UnsupportedOperationException(CMBStrings.get("NYI", "com.sun.enterprise.admin.mbeans.custom.BasicCustomMBeanConfigQueries.listMBeanConfigObjectNames"));
    }

    @Override
    public List<String> listMBeanNames(String target) throws CustomMBeanException {
        List<ObjectName> ons = this.listMBeanConfigObjectNames(target);
        ArrayList<String> names = new ArrayList<String>();
        try {
            MBeanServer mbsc = MBeanServerFactory.getMBeanServer();
            String noa = "name";
            for (ObjectName on : ons) {
                String voa = (String)mbsc.getAttribute(on, "name");
                names.add(voa);
            }
            return names;
        }
        catch (Exception e) {
            throw new CustomMBeanException(e);
        }
    }

    protected List<ObjectName> listMBeanConfigObjectNamesForServer(String s) throws RuntimeException {
        try {
            List<Mbean> refdMbeans = ServerBeansFactory.getReferencedMBeans(this.acc, s);
            return this.mbeans2ConfigMBeanObjectNames(refdMbeans);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected List<ObjectName> mbeans2ConfigMBeanObjectNames(List<Mbean> mbeans) throws RuntimeException {
        try {
            ArrayList<ObjectName> ons = new ArrayList<ObjectName>();
            for (Mbean m : mbeans) {
                String domain = "com.sun.appserv";
                ObjectName on = MBeanRegistryFactory.getAdminMBeanRegistry().getObjectNameForConfigBean(m, "com.sun.appserv");
                ons.add(on);
            }
            return ons;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

