/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExceptionHandler {
    private Logger _logger;

    public ExceptionHandler(Logger logger) {
        this._logger = logger;
    }

    protected Logger getLogger() {
        return this._logger;
    }

    public InstanceException handleInstanceException(Exception ex, String messageId, String arg) {
        return this.handleInstanceException(ex, messageId, new String[]{arg});
    }

    public InstanceException handleInstanceException(Exception ex, String messageId, String[] args) {
        InstanceException result = null;
        Level level = Level.FINE;
        if (ex instanceof InstanceException) {
            result = (InstanceException)((Object)ex);
        } else if (ex instanceof ConfigException) {
            result = new InstanceException((Throwable)ex);
        } else {
            level = Level.WARNING;
            result = new InstanceException((Throwable)ex);
        }
        StringManagerBase sm = StringManagerBase.getStringManager(this.getLogger().getResourceBundleName());
        this.getLogger().log(level, sm.getString(messageId, args), ex);
        return result;
    }

    public ConfigException handleConfigException(Exception ex, String messageId, String arg) {
        return this.handleConfigException(ex, messageId, new String[]{arg});
    }

    public ConfigException handleConfigException(Exception ex, String messageId, String[] args) {
        ConfigException result = null;
        Level level = Level.FINE;
        if (ex instanceof ConfigException) {
            result = (ConfigException)ex;
        } else {
            level = Level.WARNING;
            result = new ConfigException(ex);
        }
        StringManagerBase sm = StringManagerBase.getStringManager(this.getLogger().getResourceBundleName());
        this.getLogger().log(level, sm.getString(messageId, args), ex);
        return result;
    }
}

