/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.newtimer;

import com.sun.corba.ee.spi.orbutil.newtimer.Named;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerFactory;

public abstract class NamedBase
implements Named {
    private TimerFactory factory;
    private String name;
    private String toStringName;

    protected NamedBase(TimerFactory factory, String name) {
        this.name = name;
        if (factory != null) {
            this.setFactory(factory);
        }
    }

    protected void setFactory(TimerFactory factory) {
        if (this.factory != null) {
            throw new IllegalStateException("NamedBase.factory can only be set once!");
        }
        this.factory = factory;
        this.toStringName = factory.name() + ":" + this.name;
    }

    private void checkFactorySet() {
        if (this.factory == null) {
            throw new IllegalStateException("NamedBase.factory is not set!");
        }
    }

    public TimerFactory factory() {
        this.checkFactorySet();
        return this.factory;
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Named)) {
            return false;
        }
        Named other = (Named)Named.class.cast(obj);
        return other.name().equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        this.checkFactorySet();
        return this.toStringName;
    }
}

