/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.generic;

import com.sun.corba.ee.spi.orbutil.misc.ObjectUtility;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrayFactory {
    private static boolean error = false;

    private ArrayFactory() {
    }

    public static <T> T[] make(T ... args) {
        return args;
    }

    public static <T, S extends T> T[] make(Collection<S> collection, Class<T> cls) {
        if (collection == null) {
            return null;
        }
        Object[] result = (Object[])Array.newInstance(cls, collection.size());
        int index = 0;
        for (S elem : collection) {
            result[index++] = elem;
        }
        return result;
    }

    private static void check(Object obj1, Object obj2, String emsg) {
        if (!ObjectUtility.equals(obj1, obj2)) {
            System.out.println("ArrayFactory: Objects not equal for " + emsg);
            System.out.println("ArrayFactory: " + ObjectUtility.compactObjectToString(obj1));
            System.out.println("ArrayFactory: " + ObjectUtility.compactObjectToString(obj2));
            error = true;
        }
    }

    public static void main(String[] args) {
        String[] empty = new String[]{};
        String[] colors = new String[]{"red", "blue", "green"};
        int[] numbers = new int[]{1, 2, 3, 4};
        BigInteger[] bigNumbers = new BigInteger[]{new BigInteger("23857389573"), new BigInteger("93949384939")};
        System.out.println("ArrayFactory: Testing ArrayFactory");
        ArrayFactory.check(ArrayFactory.make(null, String.class), null, "null");
        ArrayList<String> arg1 = new ArrayList<String>();
        for (String s : empty) {
            arg1.add(s);
        }
        String[] res1 = ArrayFactory.make(arg1, String.class);
        ArrayFactory.check(res1, empty, "empty");
        ArrayList<String> arg2 = new ArrayList<String>();
        for (String s : colors) {
            arg2.add(s);
        }
        String[] res2 = ArrayFactory.make(arg2, String.class);
        ArrayFactory.check(res2, colors, "colors");
        LinkedList<Number> arg4 = new LinkedList<Number>();
        Number[] nres = new Number[numbers.length + bigNumbers.length];
        int index = 0;
        for (int x : numbers) {
            arg4.add(x);
            nres[index++] = x;
        }
        for (BigInteger bi : bigNumbers) {
            arg4.add(bi);
            nres[index++] = bi;
        }
        Number[] numberArray = ArrayFactory.make(arg4, Number.class);
        ArrayFactory.check(numberArray, nres, "int+numbers");
        if (!error) {
            System.out.println("ArrayFactory: test passed");
        }
        System.exit(error ? 1 : 0);
    }
}

