/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.copyobject.newreflect;

import com.sun.corba.ee.impl.copyobject.newreflect.CachingClassCopierFactory;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopier;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierFactory;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierFactoryArrayImpl;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierFactoryPipelineImpl;
import com.sun.corba.ee.impl.copyobject.newreflect.ClassCopierOrdinaryImpl;
import com.sun.corba.ee.impl.copyobject.newreflect.DefaultClassCopiers;
import com.sun.corba.ee.impl.copyobject.newreflect.PipelineClassCopierFactory;
import com.sun.corba.ee.spi.copyobject.ReflectiveCopyException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.TimeZone;
import java.util.WeakHashMap;

public abstract class DefaultClassCopierFactories {
    public static final boolean USE_FAST_CACHE = false;
    private static final Class[] SAFE_TO_COPY = new Class[]{TimeZone.class, Throwable.class, Proxy.class};

    private DefaultClassCopierFactories() {
    }

    public static ClassCopierFactory makeArrayClassCopierFactory(ClassCopierFactory ccf) {
        return new ClassCopierFactoryArrayImpl(ccf);
    }

    public static ClassCopierFactory makeOrdinaryClassCopierFactory(final PipelineClassCopierFactory ccf) {
        return new ClassCopierFactory(){

            @Override
            public ClassCopier getClassCopier(Class cls) throws ReflectiveCopyException {
                if (this.notCopyable(cls)) {
                    return DefaultClassCopiers.getErrorClassCopier();
                }
                return new ClassCopierOrdinaryImpl(ccf, cls);
            }

            private boolean safe(Class cls) {
                for (Class klass : SAFE_TO_COPY) {
                    if (cls != klass) continue;
                    return true;
                }
                return false;
            }

            private boolean notCopyable(Class<?> cls) {
                for (Class<?> current = cls; current != Object.class; current = current.getSuperclass()) {
                    if (this.safe(current)) {
                        return false;
                    }
                    for (Method m : current.getDeclaredMethods()) {
                        if (!m.getName().equals("finalize") && !Modifier.isNative(m.getModifiers())) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static CachingClassCopierFactory makeCachingClassCopierFactory() {
        return new CachingClassCopierFactory(){
            private Map cache = new WeakHashMap();

            public void put(Class cls, ClassCopier copier) {
                this.cache.put(cls, copier);
            }

            public ClassCopier getClassCopier(Class cls) {
                return (ClassCopier)this.cache.get(cls);
            }
        };
    }

    public static ClassCopierFactory getNullClassCopierFactory() {
        return new ClassCopierFactory(){

            public ClassCopier getClassCopier(Class cls) {
                return null;
            }
        };
    }

    public static PipelineClassCopierFactory getPipelineClassCopierFactory() {
        return new ClassCopierFactoryPipelineImpl();
    }
}

