/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.catalina.ssi.SSICommand;
import org.apache.catalina.ssi.SSIMediator;

public final class SSIInclude
implements SSICommand {
    public void process(SSIMediator ssiMediator, String[] paramNames, String[] paramValues, PrintWriter writer) {
        String configErrMsg = ssiMediator.getConfigErrMsg();
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            String paramValue = paramValues[i];
            try {
                if (paramName.equalsIgnoreCase("file") || paramName.equalsIgnoreCase("virtual")) {
                    boolean virtual = paramName.equalsIgnoreCase("virtual");
                    String text = ssiMediator.getFileText(paramValue, virtual);
                    writer.write(text);
                    continue;
                }
                ssiMediator.log("#include--Invalid attribute: " + paramName);
                writer.write(configErrMsg);
                continue;
            }
            catch (IOException e) {
                ssiMediator.log("#include--Couldn't include file: " + paramValue, e);
                writer.write(configErrMsg);
            }
        }
    }
}

