/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xwss;

import com.sun.xml.messaging.saaj.soap.ExpressMessageFactoryImpl;
import com.sun.xml.ws.spi.runtime.MessageContext;
import com.sun.xml.ws.spi.runtime.SOAPMessageContext;
import com.sun.xml.ws.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.PolicyViolationException;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.SecurityAnnotator;
import com.sun.xml.wss.impl.SecurityRecipient;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.config.ApplicationSecurityConfiguration;
import com.sun.xml.wss.impl.config.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.impl.configuration.StaticApplicationContext;
import com.sun.xml.wss.impl.filter.DumpFilter;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.xwss.SecurityConfiguration;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SystemHandlerDelegateImpl
implements SystemHandlerDelegate {
    private boolean MTOM_ON = false;
    private static ThreadLocal wsThreadCtx = new ThreadLocal();
    private HashMap service_to_configMap = new HashMap();
    private SecurityConfiguration config = null;
    private boolean firstTime = true;
    private static final String MESSAGE_SECURITY_CONFIGURATION = "com.sun.xml.ws.security.configuration";
    private static final String CONTEXT_WSDL_OPERATION = "com.sun.xml.ws.wsdl.operation";
    private MessageFactory soap11MF = null;
    private MessageFactory soap12MF = null;
    private ExpressMessageFactoryImpl expMF = null;
    private static final String FAILURE = "com.sun.xml.ws.shd.failure";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static boolean nonOpt = false;
    private static final String ENCRYPTED_BODY_QNAME = "{http://www.w3.org/2001/04/xmlenc#}EncryptedData";
    private static SOAPFactory sf11;
    private static SOAPFactory sf12;

    public SystemHandlerDelegateImpl() {
        try {
            this.soap11MF = MessageFactory.newInstance();
            this.soap12MF = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
            this.expMF = new ExpressMessageFactoryImpl();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getServiceName(MessageContext messageContext) {
        QName serviceQName = (QName)messageContext.get((Object)"javax.xml.ws.wsdl.service");
        String serviceName = null;
        serviceName = serviceQName != null ? serviceQName.getLocalPart() : "server";
        return serviceName;
    }

    private InputStream getServerConfigStream(String serviceName, MessageContext messageContext) {
        String serverConfig = "/WEB-INF/" + serviceName + "_" + "security_config.xml";
        ServletContext context = (ServletContext)messageContext.get((Object)"javax.xml.ws.servlet.context");
        if (context == null) {
            return null;
        }
        InputStream in = context.getResourceAsStream(serverConfig);
        return in;
    }

    private void debugProperties(MessageContext messageContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSecurityConfiguration(MessageContext messageContext) throws XWSSecurityException {
        if (this.config != null) {
            if (!this.config.isEmpty()) {
                messageContext.put((Object)MESSAGE_SECURITY_CONFIGURATION, (Object)this.config);
            }
        } else {
            String serviceName = this.getServiceName(messageContext);
            SecurityConfiguration scf = (SecurityConfiguration)this.service_to_configMap.get(serviceName);
            if (scf != null && !scf.isEmpty()) {
                messageContext.put((Object)MESSAGE_SECURITY_CONFIGURATION, (Object)scf);
                return;
            }
            HashMap hashMap = this.service_to_configMap;
            synchronized (hashMap) {
                SecurityConfiguration _sc = (SecurityConfiguration)this.service_to_configMap.get(serviceName);
                if (_sc == null) {
                    scf = new SecurityConfiguration(this.getServerConfigStream(serviceName, messageContext));
                    if (!scf.isEmpty()) {
                        this.service_to_configMap.put(serviceName, scf);
                    }
                } else {
                    scf = _sc;
                }
            }
            if (!scf.isEmpty()) {
                messageContext.put((Object)MESSAGE_SECURITY_CONFIGURATION, (Object)scf);
                return;
            }
            hashMap = this.service_to_configMap;
            synchronized (hashMap) {
                if (this.config == null) {
                    this.config = new SecurityConfiguration(this.getServerConfigStream("server", messageContext));
                }
            }
            if (!this.config.isEmpty()) {
                messageContext.put((Object)MESSAGE_SECURITY_CONFIGURATION, (Object)this.config);
            }
        }
    }

    public boolean processRequest(MessageContext messageContext) throws RuntimeException {
        this.debugProperties(messageContext);
        Boolean outBound = (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        boolean client = outBound == null ? true : outBound;
        try {
            if (client) {
                return this.secureRequest((SOAPMessageContext)messageContext);
            }
            this.setSecurityConfiguration(messageContext);
            return this.validateRequest((SOAPMessageContext)messageContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void processResponse(MessageContext messageContext) throws RuntimeException {
        this.debugProperties(messageContext);
        Boolean outBound = (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        boolean server = outBound == null ? true : outBound;
        boolean client = !server;
        try {
            if (client) {
                this.validateResponse((SOAPMessageContext)messageContext);
            } else {
                this.setSecurityConfiguration(messageContext);
                this.secureResponse((SOAPMessageContext)messageContext);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private StaticApplicationContext getPolicyContext(SOAPMessageContext messageContext) {
        SecurityConfiguration sConfig = (SecurityConfiguration)messageContext.get((Object)MESSAGE_SECURITY_CONFIGURATION);
        ApplicationSecurityConfiguration config = sConfig.getSecurityConfiguration();
        StaticApplicationContext iContext = (StaticApplicationContext)config.getAllContexts().next();
        StaticApplicationContext sContext = new StaticApplicationContext(iContext);
        String port = null;
        QName portQname = (QName)messageContext.get((Object)"javax.xml.ws.wsdl.port");
        port = portQname == null ? "" : portQname.toString();
        sContext.setPortIdentifier(port);
        return sContext;
    }

    private void copyToMessageContext(SOAPMessageContext messageContext, ProcessingContext context) throws Exception {
        messageContext.setMessage(context.getSOAPMessage());
        Iterator i = context.getExtraneousProperties().keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Object value = context.getExtraneousProperties().get(name);
            messageContext.put((Object)name, value);
        }
    }

    private void copyToProcessingContext(ProcessingContext context, SOAPMessageContext messageContext) throws Exception {
        Iterator i = messageContext.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Object value = messageContext.get((Object)name);
            context.setExtraneousProperty(name, value);
        }
    }

    public void validateResponse(SOAPMessageContext messageContext) throws Exception {
        boolean isSOAP12 = false;
        try {
            SecurityConfiguration sConfig = (SecurityConfiguration)messageContext.get((Object)MESSAGE_SECURITY_CONFIGURATION);
            if (sConfig == null) {
                return;
            }
            SOAPMessage message = messageContext.getMessage();
            if (message.getClass().getName().equals("com.sun.xml.messaging.saaj.soap.ver1_2.Message1_2Impl")) {
                isSOAP12 = true;
            }
            String operation = (String)messageContext.get((Object)CONTEXT_WSDL_OPERATION);
            StaticApplicationContext sContext = this.getPolicyContext(messageContext);
            sContext.setOperationIdentifier(operation.toString());
            ApplicationSecurityConfiguration config = sConfig.getSecurityConfiguration();
            SecurityPolicy policy = config.getSecurityConfiguration(sContext);
            ProcessingContext context = new ProcessingContext();
            this.copyToProcessingContext(context, messageContext);
            context.setPolicyContext(sContext);
            context.setSOAPMessage(messageContext.getMessage());
            if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
                context.setSecurityPolicy(((DeclarativeSecurityConfiguration)policy).receiverSettings());
            } else {
                context.setSecurityPolicy(policy);
            }
            context.setSecurityEnvironment(sConfig.getSecurityEnvironment());
            context.isInboundMessage(true);
            SecurityRecipient.validateMessage(context);
            this.copyToMessageContext(messageContext, context);
            if (messageContext.get((Object)"javax.security.auth.Subject") != null) {
                messageContext.setScope("javax.security.auth.Subject", MessageContext.Scope.APPLICATION);
            }
        }
        catch (WssSoapFaultException soapFaultException) {
            throw this.getSOAPFaultException(soapFaultException, isSOAP12);
        }
        catch (XWSSecurityException xwse) {
            QName qname = null;
            qname = xwse.getCause() instanceof PolicyViolationException ? MessageConstants.WSSE_RECEIVER_POLICY_VIOLATION : MessageConstants.WSSE_FAILED_AUTHENTICATION;
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(qname, xwse.getMessage(), xwse);
            throw this.getSOAPFaultException(wsfe, isSOAP12);
        }
    }

    public boolean secureRequest(SOAPMessageContext messageContext) throws Exception {
        boolean isSOAP12 = false;
        ProcessingContext context = null;
        try {
            SecurityConfiguration sConfig = (SecurityConfiguration)messageContext.get((Object)MESSAGE_SECURITY_CONFIGURATION);
            if (sConfig == null) {
                return true;
            }
            QName operationQName = (QName)messageContext.get((Object)"javax.xml.ws.wsdl.operation");
            String operation = null;
            if (operationQName == null) {
                SOAPMessage message = messageContext.getMessage();
                operation = this.getOperationName(message);
            } else {
                operation = operationQName.toString();
            }
            messageContext.put((Object)CONTEXT_WSDL_OPERATION, (Object)operation);
            StaticApplicationContext sContext = this.getPolicyContext(messageContext);
            sContext.setOperationIdentifier(operation.toString());
            ApplicationSecurityConfiguration config = sConfig.getSecurityConfiguration();
            SecurityPolicy policy = config.getSecurityConfiguration(sContext);
            context = new ProcessingContext();
            this.copyToProcessingContext(context, messageContext);
            context.setPolicyContext(sContext);
            if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
                context.setSecurityPolicy(((DeclarativeSecurityConfiguration)policy).senderSettings());
            } else {
                context.setSecurityPolicy(policy);
            }
            context.setSecurityEnvironment(sConfig.getSecurityEnvironment());
            context.isInboundMessage(false);
            this.setSOAPMessage(messageContext, context, config.isOptimized());
            SecurityAnnotator.secureMessage(context);
            this.copyToMessageContext(messageContext, context);
        }
        catch (WssSoapFaultException soapFaultException) {
            this.addFault(soapFaultException, messageContext.getMessage(), isSOAP12);
        }
        catch (XWSSecurityException xwse) {
            throw new WebServiceException((Throwable)xwse);
        }
        return true;
    }

    public boolean validateRequest(SOAPMessageContext messageContext) throws Exception {
        boolean isSOAP12 = false;
        ProcessingContext context = null;
        try {
            SecurityConfiguration sConfig = (SecurityConfiguration)messageContext.get((Object)MESSAGE_SECURITY_CONFIGURATION);
            if (sConfig == null) {
                return true;
            }
            SOAPMessage message = messageContext.getMessage();
            if (message.getClass().getName().equals("com.sun.xml.messaging.saaj.soap.ver1_2.Message1_2Impl")) {
                isSOAP12 = true;
            }
            StaticApplicationContext sContext = new StaticApplicationContext(this.getPolicyContext(messageContext));
            context = new ProcessingContext();
            this.copyToProcessingContext(context, messageContext);
            context.setSOAPMessage(messageContext.getMessage());
            String operation = this.getOperationName(message);
            ApplicationSecurityConfiguration _sConfig = sConfig.getSecurityConfiguration();
            if (operation.equals(ENCRYPTED_BODY_QNAME) && _sConfig.hasOperationPolicies()) {
                ApplicationSecurityConfiguration config = (ApplicationSecurityConfiguration)_sConfig.getSecurityPolicies(sContext).next();
                if (config != null) {
                    context.setPolicyContext(sContext);
                    context.setSecurityPolicy(config);
                } else {
                    ApplicationSecurityConfiguration config0 = (ApplicationSecurityConfiguration)_sConfig.getAllTopLevelApplicationSecurityConfigurations().iterator().next();
                    context.setPolicyContext(sContext);
                    context.setSecurityPolicy(config0);
                }
            } else {
                sContext.setOperationIdentifier(operation.toString());
                messageContext.put((Object)CONTEXT_WSDL_OPERATION, (Object)operation);
                SecurityPolicy policy = _sConfig.getSecurityConfiguration(sContext);
                context.setPolicyContext(sContext);
                if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
                    context.setSecurityPolicy(((DeclarativeSecurityConfiguration)policy).receiverSettings());
                } else {
                    context.setSecurityPolicy(policy);
                }
            }
            context.setSecurityEnvironment(sConfig.getSecurityEnvironment());
            context.isInboundMessage(true);
            SecurityRecipient.validateMessage(context);
            String operationName = this.getOperationName(message);
            messageContext.put((Object)CONTEXT_WSDL_OPERATION, (Object)operationName);
            this.copyToMessageContext(messageContext, context);
            if (messageContext.get((Object)"javax.security.auth.Subject") != null) {
                messageContext.setScope("javax.security.auth.Subject", MessageContext.Scope.APPLICATION);
            }
        }
        catch (WssSoapFaultException soapFaultException) {
            messageContext.put((Object)FAILURE, (Object)TRUE);
            this.addFault(soapFaultException, messageContext.getMessage(), isSOAP12);
            return false;
        }
        catch (XWSSecurityException xwse) {
            QName qname = null;
            qname = xwse.getCause() instanceof PolicyViolationException ? MessageConstants.WSSE_RECEIVER_POLICY_VIOLATION : MessageConstants.WSSE_FAILED_AUTHENTICATION;
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(qname, xwse.getMessage(), xwse);
            messageContext.put((Object)FAILURE, (Object)TRUE);
            this.addFault(wsfe, messageContext.getMessage(), isSOAP12);
            return false;
        }
        return true;
    }

    public void secureResponse(SOAPMessageContext messageContext) throws Exception {
        boolean isSOAP12 = false;
        try {
            SecurityConfiguration sConfig = (SecurityConfiguration)messageContext.get((Object)MESSAGE_SECURITY_CONFIGURATION);
            if (sConfig == null) {
                return;
            }
            ProcessingContext context = new ProcessingContext();
            this.copyToProcessingContext(context, messageContext);
            if (messageContext.get((Object)FAILURE) == TRUE) {
                DumpFilter.process(context);
                messageContext.put((Object)FAILURE, (Object)FALSE);
                return;
            }
            String operation = (String)messageContext.get((Object)CONTEXT_WSDL_OPERATION);
            StaticApplicationContext sContext = new StaticApplicationContext(this.getPolicyContext(messageContext));
            sContext.setOperationIdentifier(operation.toString());
            ApplicationSecurityConfiguration _sConfig = sConfig.getSecurityConfiguration();
            SecurityPolicy policy = _sConfig.getSecurityConfiguration(sContext);
            context.setPolicyContext(sContext);
            if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
                context.setSecurityPolicy(((DeclarativeSecurityConfiguration)policy).senderSettings());
            } else {
                context.setSecurityPolicy(policy);
            }
            context.setSecurityEnvironment(sConfig.getSecurityEnvironment());
            context.isInboundMessage(false);
            this.setSOAPMessage(messageContext, context, _sConfig.isOptimized());
            SecurityAnnotator.secureMessage(context);
            this.copyToMessageContext(messageContext, context);
        }
        catch (WssSoapFaultException soapFaultException) {
            throw this.getSOAPFaultException(soapFaultException, isSOAP12);
        }
        catch (XWSSecurityException xwse) {
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INTERNAL_SERVER_ERROR, xwse.getMessage(), xwse);
            throw this.getSOAPFaultException(wsfe, isSOAP12);
        }
    }

    public SOAPFaultException getSOAPFaultException(WssSoapFaultException sfe, boolean isSOAP12) {
        SOAPFault fault = null;
        try {
            if (isSOAP12) {
                fault = sf12.createFault(sfe.getFaultString(), SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(sfe.getFaultCode());
            } else {
                fault = sf11.createFault(sfe.getFaultString(), sfe.getFaultCode());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("com.sun.xml.rpc.security.SystemHandlerDelegateImpl: Internal Error while trying to create a SOAPFault");
        }
        return new SOAPFaultException(fault);
    }

    private String getOperationName(SOAPMessage message) throws Exception {
        Node node = null;
        Object key = null;
        SOAPBody body = null;
        if (message == null) {
            throw new XWSSecurityException("SOAPMessage in message context is null");
        }
        body = message.getSOAPBody();
        if (body == null) {
            throw new XWSSecurityException("No body element identifying an operation is found");
        }
        String operation = "";
        for (node = body.getFirstChild(); node != null; node = node.getNextSibling()) {
            operation = operation + "{" + node.getNamespaceURI() + "}" + node.getLocalName() + ":";
        }
        if (operation.length() > 0) {
            return operation.substring(0, operation.length() - 1);
        }
        return operation;
    }

    public void preInvokeEndpointHook(MessageContext messageContext) {
    }

    private void setSOAPMessage(SOAPMessageContext msgContext, ProcessingContext pc, boolean optimized) throws Exception {
        if (msgContext.isAlreadySoap()) {
            pc.setSOAPMessage(msgContext.getMessage());
            return;
        }
        if (nonOpt) {
            pc.setSOAPMessage(msgContext.getMessage());
            return;
        }
        String fiValue = (String)msgContext.get((Object)"com.sun.xml.ws.client.ContentNegotiation");
        if (fiValue != null && fiValue.length() > 0 && "optimistic".equals(fiValue)) {
            SOAPMessage msg = ExpressMessageFactoryImpl.createMessage(msgContext, false);
            pc.setSOAPMessage(msg);
            return;
        }
        MessagePolicy mpolicy = (MessagePolicy)pc.getSecurityPolicy();
        if (!optimized || mpolicy.getOptimizedType() == MessageConstants.NOT_OPTIMIZED) {
            SOAPMessage msg = ExpressMessageFactoryImpl.createMessage(msgContext, false);
            pc.setSOAPMessage(msg);
        } else {
            SOAPMessage msg = ExpressMessageFactoryImpl.createMessage(msgContext);
            pc.setSOAPMessage(msg);
            pc.setConfigType(mpolicy.getOptimizedType());
        }
    }

    public void addFault(WssSoapFaultException sfe, SOAPMessage soapMessage, boolean isSOAP12) throws SOAPException {
        SOAPBody body = soapMessage.getSOAPBody();
        body.removeContents();
        soapMessage.removeAllAttachments();
        QName faultCode = sfe.getFaultCode();
        Object faultCodeName = null;
        if (faultCode == null) {
            faultCode = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client");
        }
        if (isSOAP12) {
            SOAPFault fault = body.addFault(SOAPConstants.SOAP_SENDER_FAULT, sfe.getMessage());
            fault.appendFaultSubcode(faultCode);
        } else {
            body.addFault(faultCode, sfe.getMessage());
        }
        NodeList list = soapMessage.getSOAPPart().getEnvelope().getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        if (list.getLength() > 0) {
            Node node = list.item(0);
            node.getParentNode().removeChild(node);
        }
    }

    static {
        try {
            String value = System.getProperty("jaxws.soapmessage", FALSE);
            if (value != null && value.length() > 0) {
                nonOpt = Boolean.parseBoolean(value);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        sf11 = null;
        sf12 = null;
        try {
            sf11 = SOAPFactory.newInstance();
            sf12 = SOAPFactory.newInstance((String)"SOAP 1.2 Protocol");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

