/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.AlgorithmAlreadyRegisteredException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.InvalidTransformException;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.HelperNodeList;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Transform
extends SignatureElementProxy {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$transforms$Transform == null ? (class$com$sun$org$apache$xml$internal$security$transforms$Transform = Transform.class$("com.sun.org.apache.xml.internal.security.transforms.Transform")) : class$com$sun$org$apache$xml$internal$security$transforms$Transform).getName());
    static boolean _alreadyInitialized = false;
    static HashMap _transformHash = null;
    protected TransformSpi transformSpi = null;
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$transforms$Transform;

    public Transform(Document document, String string, NodeList nodeList) throws InvalidTransformException {
        super(document);
        try {
            this._constructionElement.setAttributeNS(null, "Algorithm", string);
            Class clazz = Transform.getImplementingClass(string);
            if (clazz == null) {
                Object[] objectArray = new Object[]{string};
                throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Create URI \"" + string + "\" class \"" + clazz + "\"");
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "The NodeList is " + nodeList);
            }
            this.transformSpi = (TransformSpi)clazz.newInstance();
            this.transformSpi.setTransform(this);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this._constructionElement.appendChild(nodeList.item(i).cloneNode(true));
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, instantiationException);
        }
    }

    public Transform(Element element, String string) throws InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, string);
        String string2 = element.getAttributeNS(null, "Algorithm");
        if (string2 == null || string2.length() == 0) {
            Object[] objectArray = new Object[]{"Algorithm", "Transform"};
            throw new TransformationException("xml.WrongContent", objectArray);
        }
        try {
            Class clazz = (Class)_transformHash.get(string2);
            this.transformSpi = (TransformSpi)clazz.newInstance();
            this.transformSpi.setTransform(this);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[]{string2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
    }

    public static final Transform getInstance(Document document, String string) throws InvalidTransformException {
        return Transform.getInstance(document, string, (NodeList)null);
    }

    public static final Transform getInstance(Document document, String string, Element element) throws InvalidTransformException {
        HelperNodeList helperNodeList = new HelperNodeList();
        helperNodeList.appendChild(document.createTextNode("\n"));
        helperNodeList.appendChild(element);
        helperNodeList.appendChild(document.createTextNode("\n"));
        return Transform.getInstance(document, string, helperNodeList);
    }

    public static final Transform getInstance(Document document, String string, NodeList nodeList) throws InvalidTransformException {
        return new Transform(document, string, nodeList);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _transformHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string, String string2) throws AlgorithmAlreadyRegisteredException {
        Class clazz = Transform.getImplementingClass(string);
        if (clazz != null) {
            Object[] objectArray = new Object[]{string, clazz};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        try {
            _transformHash.put(string, Class.forName(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public XMLSignatureInput performTransform(XMLSignatureInput xMLSignatureInput) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput xMLSignatureInput2 = null;
        try {
            xMLSignatureInput2 = this.transformSpi.enginePerformTransform(xMLSignatureInput);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Object[] objectArray = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Object[] objectArray = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, sAXException);
        }
        return xMLSignatureInput2;
    }

    public XMLSignatureInput performTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput xMLSignatureInput2 = null;
        try {
            xMLSignatureInput2 = this.transformSpi.enginePerformTransform(xMLSignatureInput, outputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Object[] objectArray = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Object[] objectArray = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, sAXException);
        }
        return xMLSignatureInput2;
    }

    private static Class getImplementingClass(String string) {
        return (Class)_transformHash.get(string);
    }

    public String getBaseLocalName() {
        return "Transform";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

