/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.Switch;
import com.sun.enterprise.security.LoginException;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.jauth.callback.CertStoreCallback;
import com.sun.enterprise.security.jauth.callback.PasswordValidationCallback;
import com.sun.enterprise.security.jauth.callback.PrivateKeyCallback;
import com.sun.enterprise.security.jauth.callback.SecretKeyCallback;
import com.sun.enterprise.security.jauth.callback.TrustStoreCallback;
import com.sun.enterprise.webservice.AppclientWSSCallbackHandler;
import com.sun.enterprise.webservice.EjbServletWSSCallbackHandler;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import sun.security.util.DerValue;

public abstract class WSSCallbackHandler
implements CallbackHandler {
    private static String SUBJECT_KEY_IDENTIFIER_OID = "2.5.29.14";
    protected static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");

    public static CallbackHandler getInstance() {
        if (Switch.getSwitch().getContainerType() == 1) {
            return AppclientWSSCallbackHandler.newInstance();
        }
        return EjbServletWSSCallbackHandler.newInstance();
    }

    abstract boolean isSupportedCallback(Callback var1);

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
    }

    protected void processCallback(Callback callback) throws UnsupportedCallbackException {
        if (callback instanceof PasswordValidationCallback) {
            this.processPasswordValidation((PasswordValidationCallback)callback);
        } else if (callback instanceof PrivateKeyCallback) {
            this.processPrivateKey((PrivateKeyCallback)callback);
        } else if (callback instanceof TrustStoreCallback) {
            TrustStoreCallback tstoreCallback = (TrustStoreCallback)callback;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "container-auth: wss : In TrustStoreCallback Processor");
            }
            tstoreCallback.setStore(SSLUtils.getMergedTrustStore());
        } else if (callback instanceof CertStoreCallback) {
            this.processCertStore((CertStoreCallback)callback);
        } else if (callback instanceof SecretKeyCallback) {
            this.processSecretKey((SecretKeyCallback)callback);
        } else {
            _logger.log(Level.FINE, "wss-container-auth: UnsupportedCallback : " + callback.getClass().getName());
            throw new UnsupportedCallbackException(callback);
        }
    }

    private void processPasswordValidation(PasswordValidationCallback pwdCallback) {
        if (Switch.getSwitch().getContainerType() == 1) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "container-auth: wss : In PasswordValidationCallback Processor for appclient - will do nothing");
            }
            pwdCallback.setResult(true);
            return;
        }
        String username = pwdCallback.getUsername();
        String password = new String(pwdCallback.getPassword());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "container-auth: wss : In PasswordValidationCallback Processor");
        }
        try {
            String defaultRealm = Realm.getDefaultRealm();
            LoginContextDriver.wssLoginUsernamePassword(username, password, defaultRealm);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "container-auth wss: authentication succeeded for user = ", username);
            }
            password = null;
            pwdCallback.setResult(true);
        }
        catch (LoginException le) {
            _logger.log(Level.INFO, "container-auth: wss : Login failed for user :", username);
            pwdCallback.setResult(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPrivateKey(PrivateKeyCallback privKeyCallback) {
        KeyStore[] kstores = SecurityUtil.getSecuritySupport().getKeyStores();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "container-auth: wss : In PrivateKeyCallback Processor");
        }
        if (kstores == null || kstores.length == 0) {
            privKeyCallback.setKey(null, null);
            return;
        }
        String[] passwords = SecurityUtil.getSecuritySupport().getKeyStorePasswords();
        PrivateKeyCallback.Request req = privKeyCallback.getRequest();
        if (req == null) {
            this.setDefaultKey(privKeyCallback, kstores, passwords);
            passwords = null;
            return;
        }
        PrivateKey privKey = null;
        Certificate[] certs = null;
        try {
            if (req instanceof PrivateKeyCallback.AliasRequest) {
                PrivateKeyCallback.AliasRequest aReq = (PrivateKeyCallback.AliasRequest)req;
                String alias = aReq.getAlias();
                KeyStore.PrivateKeyEntry privKeyEntry = null;
                if (alias == null) {
                    this.setDefaultKey(privKeyCallback, kstores, passwords);
                    passwords = null;
                    privKeyCallback.setKey(privKey, certs);
                    passwords = null;
                    return;
                }
                privKeyEntry = SSLUtils.getPrivateKeyEntryFromTokenAlias(alias);
                if (privKeyEntry != null) {
                    privKey = privKeyEntry.getPrivateKey();
                    certs = privKeyEntry.getCertificateChain();
                }
            } else if (req instanceof PrivateKeyCallback.IssuerSerialNumRequest) {
                PrivateKeyCallback.IssuerSerialNumRequest isReq = (PrivateKeyCallback.IssuerSerialNumRequest)req;
                X500Principal issuer = isReq.getIssuer();
                BigInteger serialNum = isReq.getSerialNum();
                if (issuer != null && serialNum != null) {
                    boolean found = false;
                    for (int i = 0; i < kstores.length && !found; ++i) {
                        Enumeration<String> aliases = kstores[i].aliases();
                        while (aliases.hasMoreElements() && !found) {
                            Certificate[] certificates;
                            X509Certificate eeCert;
                            String nextAlias = aliases.nextElement();
                            Key key = kstores[i].getKey(nextAlias, passwords[i].toCharArray());
                            if (key == null || !(key instanceof PrivateKey) || !(eeCert = (X509Certificate)(certificates = kstores[i].getCertificateChain(nextAlias))[0]).getIssuerX500Principal().equals(issuer) || !eeCert.getSerialNumber().equals(serialNum)) continue;
                            privKey = (PrivateKey)key;
                            certs = certificates;
                            found = true;
                        }
                    }
                }
            } else if (req instanceof PrivateKeyCallback.SubjectKeyIDRequest) {
                PrivateKeyCallback.SubjectKeyIDRequest skReq = (PrivateKeyCallback.SubjectKeyIDRequest)req;
                byte[] subjectKeyID = skReq.getSubjectKeyID();
                if (subjectKeyID != null) {
                    boolean found = false;
                    DerValue derValue1 = new DerValue(4, subjectKeyID);
                    DerValue derValue2 = new DerValue(4, derValue1.toByteArray());
                    byte[] derSubjectKeyID = derValue2.toByteArray();
                    for (int i = 0; i < kstores.length && !found; ++i) {
                        Enumeration<String> aliases = kstores[i].aliases();
                        while (aliases.hasMoreElements() && !found) {
                            Certificate[] certificates;
                            X509Certificate eeCert;
                            byte[] derSubKeyID;
                            String nextAlias = aliases.nextElement();
                            Key key = kstores[i].getKey(nextAlias, passwords[i].toCharArray());
                            if (key == null || !(key instanceof PrivateKey) || (derSubKeyID = (eeCert = (X509Certificate)(certificates = kstores[i].getCertificateChain(nextAlias))[0]).getExtensionValue(SUBJECT_KEY_IDENTIFIER_OID)) == null || !Arrays.equals(derSubKeyID, derSubjectKeyID)) continue;
                            privKey = (PrivateKey)key;
                            certs = certificates;
                            found = true;
                        }
                    }
                }
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "invalid request type: " + req.getClass().getName());
            }
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "container-auth: wss : In PrivateKeyCallback Processor:  Error reading key !", e);
            }
        }
        finally {
            privKeyCallback.setKey(privKey, certs);
            passwords = null;
        }
    }

    private void setDefaultKey(PrivateKeyCallback privKeyCallback, KeyStore[] kstores, String[] passwords) {
        PrivateKey privKey = null;
        Certificate[] certs = null;
        try {
            for (int i = 0; i < kstores.length && privKey == null; ++i) {
                Enumeration<String> aliases = kstores[i].aliases();
                while (aliases.hasMoreElements() && privKey == null) {
                    String nextAlias = aliases.nextElement();
                    privKey = null;
                    certs = null;
                    Key key = kstores[i].getKey(nextAlias, passwords[i].toCharArray());
                    if (key == null || !(key instanceof PrivateKey)) continue;
                    privKey = (PrivateKey)key;
                    certs = kstores[i].getCertificateChain(nextAlias);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        privKeyCallback.setKey(privKey, certs);
    }

    private void processCertStore(CertStoreCallback certStoreCallback) {
        KeyStore certStore;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "container-auth: wss : In CertStoreCallback Processor");
        }
        if ((certStore = SSLUtils.getMergedTrustStore()) == null) {
            certStoreCallback.setStore(null);
        }
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        CollectionCertStoreParameters ccsp = null;
        try {
            Enumeration<String> enu = certStore.aliases();
            while (enu.hasMoreElements()) {
                String alias = enu.nextElement();
                if (!certStore.isCertificateEntry(alias)) continue;
                try {
                    Certificate cert = certStore.getCertificate(alias);
                    list.add(cert);
                }
                catch (KeyStoreException kse) {
                    _logger.log(Level.FINE, "container-auth : wss: Cannot retrievecertificate for alias " + alias);
                }
            }
            ccsp = new CollectionCertStoreParameters(list);
            CertStore certstore = CertStore.getInstance("Collection", ccsp);
            certStoreCallback.setStore(certstore);
        }
        catch (KeyStoreException kse) {
            _logger.log(Level.FINE, "container-auth: wss :  Cannot determine truststore aliases", kse);
        }
        catch (InvalidAlgorithmParameterException iape) {
            _logger.log(Level.FINE, "container-auth: wss :  Cannot instantiate CertStore", iape);
        }
        catch (NoSuchAlgorithmException nsape) {
            _logger.log(Level.FINE, "container-auth: wss :  Cannot instantiate CertStore", nsape);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSecretKey(SecretKeyCallback secretKeyCallback) {
        String alias;
        KeyStore secretStore;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "container-auth: wss : In SecretKeyCallback Processor");
        }
        if ((secretStore = SecurityUtil.getSecuritySupport().getKeyStores()[0]) == null) {
            secretKeyCallback.setKey(null);
        }
        if ((alias = ((SecretKeyCallback.AliasRequest)secretKeyCallback.getRequest()).getAlias()) != null) {
            String pass = SSLUtils.getKeyStorePass();
            try {
                Key key = secretStore.getKey(alias, pass.toCharArray());
                if (key instanceof SecretKey) {
                    secretKeyCallback.setKey((SecretKey)key);
                }
                secretKeyCallback.setKey(null);
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "container-auth: wss : In SecretKeyCallback Processor:  Error reading key ! for alias " + alias, e);
                }
                secretKeyCallback.setKey(null);
            }
            finally {
                pass = null;
            }
        } else {
            secretKeyCallback.setKey(null);
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "container-auth: wss : No support to read Principals in SecretKeyCallback");
            }
        }
    }
}

