/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.async;

import com.sun.enterprise.web.connector.grizzly.AsyncExecutor;
import com.sun.enterprise.web.connector.grizzly.AsyncFilter;
import com.sun.enterprise.web.connector.grizzly.AsyncHandler;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.async.AsyncProcessorTask;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DefaultAsyncHandler
implements AsyncHandler {
    private ConcurrentLinkedQueue<AsyncProcessorTask> asyncProcessors = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<AsyncProcessorTask> interrruptedQueue = new ConcurrentLinkedQueue();
    private ArrayList<AsyncFilter> asyncFilters = new ArrayList();
    private String asyncExecutorClassName = "com.sun.enterprise.web.connector.grizzly.async.DefaultAsyncExecutor";

    private AsyncProcessorTask newAsyncProcessorTask() {
        AsyncProcessorTask asyncProcessorTask = new AsyncProcessorTask();
        asyncProcessorTask.setAsyncExecutor(this.newAsyncExecutor(asyncProcessorTask));
        return asyncProcessorTask;
    }

    private AsyncExecutor newAsyncExecutor(AsyncProcessorTask asyncProcessorTask) {
        Class<?> className = null;
        AsyncExecutor asyncExecutor = null;
        try {
            className = Class.forName(this.asyncExecutorClassName);
            asyncExecutor = (AsyncExecutor)className.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        if (asyncExecutor != null) {
            asyncExecutor.setAsyncProcessorTask(asyncProcessorTask);
            for (AsyncFilter l : this.asyncFilters) {
                asyncExecutor.addAsyncFilter(l);
            }
        }
        return asyncExecutor;
    }

    private AsyncProcessorTask getAsyncProcessorTask() {
        AsyncProcessorTask asyncProcessorTask = this.asyncProcessors.poll();
        if (asyncProcessorTask == null) {
            asyncProcessorTask = this.newAsyncProcessorTask();
        } else {
            asyncProcessorTask.recycle();
        }
        return asyncProcessorTask;
    }

    public void handle(Task task) {
        boolean wasInterrupted;
        AsyncProcessorTask apt = null;
        if (task.getType() == 2) {
            apt = this.getAsyncProcessorTask();
            apt.setProcessorTask((ProcessorTask)task);
        }
        if (!(wasInterrupted = this.interrruptedQueue.remove(task)) && apt == null) {
            throw new IllegalStateException();
        }
        if (apt == null) {
            apt = (AsyncProcessorTask)task;
        }
        apt.execute();
    }

    public void returnTask(AsyncProcessorTask asyncProcessorTask) {
        this.asyncProcessors.offer(asyncProcessorTask);
    }

    public void addToInterruptedQueue(Task task) {
        this.interrruptedQueue.offer((AsyncProcessorTask)task);
    }

    public void removeFromInterruptedQueue(Task task) {
        this.interrruptedQueue.remove(task);
    }

    public void setAsyncExecutorClassName(String asyncExecutorClassName) {
        this.asyncExecutorClassName = asyncExecutorClassName;
    }

    public String getAsyncExecutorClassName() {
        return this.asyncExecutorClassName;
    }

    public void addAsyncFilter(AsyncFilter asyncFilter) {
        this.asyncFilters.add(asyncFilter);
    }

    public boolean removeAsyncFilter(AsyncFilter asyncFilter) {
        return this.asyncFilters.remove(asyncFilter);
    }
}

