/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllJSPsMustBeCompilable
extends WebTest
implements WebCheck {
    @Override
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        this.addGoodDetails(result, compName);
        result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "All JSPs are compilable."));
        result.setStatus(0);
        this.addErrorDetails(result, compName);
        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".exception", "Error: Some JSPs bundled inside [ {0} ] could not be compiled. See details below.", new Object[]{descriptor.getName()}));
        for (JasperException e : this.compile(descriptor)) {
            result.failed(this.formatMessage(descriptor, e.toString()));
        }
        return result;
    }

    protected List<JasperException> compile(WebBundleDescriptor descriptor) {
        String archiveUri = this.getAbstractArchiveUri(descriptor);
        File outDir = this.getVerifierContext().getOutDir();
        this.logger.log(Level.INFO, "Compiling JSPs in [ " + new File(archiveUri).getName() + " ]");
        JspC jspc = new JspC();
        jspc.setUriroot(archiveUri);
        jspc.setCompile(true);
        jspc.setOutputDir(outDir.getAbsolutePath());
        jspc.setFailOnError(false);
        String as_lib_root = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator;
        String cp = this.getVerifierContext().getClassPath();
        if (!this.getVerifierContext().isAppserverMode()) {
            cp = as_lib_root + "javaee.jar" + File.pathSeparator + cp;
        }
        this.logger.log(Level.FINE, "JSPC classpath " + cp);
        jspc.setSystemClassPath(cp);
        JspC.setSchemaResourcePrefix("/schemas/");
        JspC.setDtdResourcePrefix("/dtds/");
        if (this.logger.isLoggable(Level.FINEST)) {
            jspc.setVerbose(1);
        }
        try {
            jspc.execute();
        }
        catch (JasperException je) {
            List<JasperException> errors = jspc.getJSPCompilationErrors();
            errors.add(je);
            return errors;
        }
        return jspc.getJSPCompilationErrors();
    }

    private String formatMessage(WebBundleDescriptor descriptor, String message) {
        if (message == null || descriptor == null) {
            return null;
        }
        String formattedMessage = message;
        String archiveUri = this.getAbstractArchiveUri(descriptor);
        int index = message.indexOf(archiveUri);
        if (index != -1) {
            formattedMessage = message.substring(index + archiveUri.length() + 1);
        }
        return formattedMessage;
    }
}

