/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ss;

import com.sun.appserv.server.ServerLifecycle;
import com.sun.enterprise.admin.server.core.AdminChannelLifecycle;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.jms.JmsProviderLifecycle;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.ss.ASSocketService;
import com.sun.enterprise.server.ss.ASSocketServiceConfig;
import com.sun.enterprise.server.ss.provider.ASClientSocketFactory;
import com.sun.enterprise.server.ss.provider.ASServerSocketFactory;
import com.sun.enterprise.server.ss.provider.PortConflictException;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ASLazyKernel {
    private static final String AS_SELECTOR_PROVIDER = "com.sun.enterprise.server.ss.provider.ASSelectorProvider";
    private static final String SELECTOR_PROVIDER_PROP = "java.nio.channels.spi.SelectorProvider";
    private static final String QUICK_STARTUP = "com.sun.enterprise.server.ss.ASQuickStartup";
    private static final String DEFAULT_SELECTOR_PROVIDER = "sun.nio.ch.DefaultSelectorProvider";
    private static boolean defaultSelectorProviderCreatable = false;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.core");
    private Config conf = null;
    private JmsProviderLifecycle jmslc = null;
    private AdminChannelLifecycle adminlc = null;

    public boolean startASSocketServices(ServerContext context) {
        try {
            if (this.initializeASSocketService()) {
                ASLazyKernel.logFine("STARTING ASSocketService");
                ASSocketService.initialize();
                this.initializeAdminService(context);
                this.setupSocketListeners(context);
                this.setupInitialServices(context);
                logger.log(Level.INFO, "socketservice.init_done");
                return true;
            }
            ASLazyKernel.logFine("Not using ASSocketService. Proceeding with normal startup");
        }
        catch (PortConflictException pex) {
            logger.log(Level.SEVERE, "socketservice.port_conflict", new Object[]{String.valueOf(pex.getConflictedPort())});
            this.exitServer(context, pex.getConflictedPort());
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "socketservice.unknown_ex", ex);
            this.exitServer(context, 0);
        }
        return false;
    }

    private void exitServer(ServerContext context, int port) {
        ASLazyKernel.logFine("Stopped MQ");
        this.abortAdminService(context, port);
        ASLazyKernel.logFine("Aborted admin service");
        System.exit(1);
    }

    private void setupSocketListeners(ServerContext scontext) throws PortConflictException, ConfigException {
        ConfigContext ctxt = scontext.getConfigContext();
        this.conf = ServerBeansFactory.getConfigBean(ctxt);
        HttpService httpService = this.conf.getHttpService();
        HttpListener[] httpListeners = httpService.getHttpListener();
        for (int i = 0; i < httpListeners.length; ++i) {
            this.startService(httpListeners[i]);
            ASLazyKernel.logFine("Started ASSocketService for HTTP(S) ");
        }
        IiopService iiopService = this.conf.getIiopService();
        IiopListener[] iiopListeners = iiopService.getIiopListener();
        for (int i = 0; i < iiopListeners.length; ++i) {
            if (!iiopListeners[i].isEnabled()) continue;
            this.startService(iiopListeners[i]);
            ASLazyKernel.logFine("Started ASSocketService for IIOP(S)");
        }
        AdminService adminService = this.conf.getAdminService();
        JmxConnector[] jmxConnectors = adminService.getJmxConnector();
        for (int i = 0; i < jmxConnectors.length; ++i) {
            if (!jmxConnectors[i].isEnabled()) continue;
            this.startService(jmxConnectors[i]);
            ASLazyKernel.logFine("Started ASSocketService for JMX Connector ");
        }
        JmsService jmsService_ = this.conf.getJmsService();
        String defaultJmsHost = jmsService_.getDefaultJmsHost();
        JmsHost jmsHost_ = null;
        jmsHost_ = defaultJmsHost == null || defaultJmsHost.equals("") ? ServerBeansFactory.getJmsHostBean(ctxt) : jmsService_.getJmsHostByName(defaultJmsHost);
        if (jmsService_.getType().equalsIgnoreCase("embedded") && jmsHost_ != null && jmsHost_.isEnabled()) {
            ASSocketServiceConfig ssConfig = new ASSocketServiceConfig(jmsHost_);
            ssConfig.setPortTag("port");
            new ASSocketService(ssConfig).start();
            ASLazyKernel.logFine("Started ASSocketService for JMS ");
        }
    }

    private void startService(ConfigBean bean) throws PortConflictException {
        ASSocketServiceConfig ssConfig = new ASSocketServiceConfig(bean);
        ssConfig.setAddressTag("address");
        ssConfig.setPortTag("port");
        new ASSocketService(ssConfig).start();
    }

    private void setupInitialServices(ServerContext context) throws Exception {
        this.startAdminService(context);
    }

    private void initializeAdminService(ServerContext context) throws Exception {
        this.createAdminChannelLifecycle();
        this.adminlc.onInitialization(context);
    }

    private void startAdminService(ServerContext context) throws Exception {
        ASLazyKernel.logFine("About to start AdminService ");
        this.createAdminChannelLifecycle();
        this.adminlc.onStartup(context);
        this.adminlc.onReady(context);
    }

    private void abortAdminService(ServerContext sc, int port) {
        try {
            this.createAdminChannelLifecycle();
            this.adminlc.onAbort(port);
            ASSocketService.waitForClientNotification();
            this.adminlc.onShutdown();
            this.adminlc.onTermination();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createAdminChannelLifecycle() {
        if (this.adminlc == null) {
            this.adminlc = new AdminChannelLifecycle();
        }
    }

    private void stopLifecycle(ServerLifecycle lifecycle) {
        try {
            lifecycle.onShutdown();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "socketservice.stop_lc_ex", t);
        }
        try {
            lifecycle.onTermination();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "socketservice.stop_lc_ex", t);
        }
    }

    private void startLifecycle(ServerLifecycle lifecycle, ServerContext sc) throws Exception {
        lifecycle.onInitialization(sc);
        lifecycle.onStartup(sc);
        lifecycle.onReady(sc);
    }

    public static boolean isQuickStartupEnabled() {
        String quickStartValue = System.getProperty(QUICK_STARTUP);
        if (quickStartValue == null || quickStartValue.equals("true")) {
            return ASLazyKernel.isDefaultSelectorProviderCreatable();
        }
        return false;
    }

    private static void logFine(String msg) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(msg);
        }
    }

    private boolean initializeASSocketService() throws IOException {
        if (ASLazyKernel.isQuickStartupEnabled()) {
            System.setProperty(SELECTOR_PROVIDER_PROP, AS_SELECTOR_PROVIDER);
            ServerSocket.setSocketFactory(new ASServerSocketFactory());
            Socket.setSocketImplFactory(new ASClientSocketFactory());
            return true;
        }
        return false;
    }

    private static boolean isDefaultSelectorProviderCreatable() {
        if (defaultSelectorProviderCreatable) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName(DEFAULT_SELECTOR_PROVIDER);
            Method createMeth = clazz.getMethod("create", new Class[0]);
            createMeth.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            ASLazyKernel.logFine("Exception in isDefaultSelectorProviderCreatable : " + e);
            return false;
        }
        defaultSelectorProviderCreatable = true;
        return true;
    }
}

