/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.event;

import com.sun.enterprise.deployment.Application;

public class ApplicationEvent {
    public static final int BEFORE_APPLICATION_LOAD = 0;
    public static final int AFTER_APPLICATION_LOAD = 1;
    public static final int BEFORE_APPLICATION_UNLOAD = 2;
    public static final int AFTER_APPLICATION_UNLOAD = 3;
    private int eventType;
    private Application application;
    private ClassLoader loader;

    public ApplicationEvent(int eventType, Application application, ClassLoader loader) {
        this.eventType = eventType;
        this.application = application;
        this.loader = loader;
    }

    public int getEventType() {
        return this.eventType;
    }

    public Application getApplication() {
        return this.application;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer("AppEvent: ");
        return this.toString(sbuf);
    }

    protected String toString(StringBuffer sbuf) {
        switch (this.eventType) {
            case 0: {
                sbuf.append("BEFORE_LOAD -> ");
                break;
            }
            case 1: {
                sbuf.append("AFTER_LOAD -> ");
                break;
            }
            case 2: {
                sbuf.append("BEFORE_UNLOAD -> ");
                break;
            }
            case 3: {
                sbuf.append("AFTER_UNLOAD -> ");
                break;
            }
        }
        if (this.application != null) {
            sbuf.append(this.application.getRegistrationName());
        }
        return sbuf.toString();
    }
}

